/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.hwclouds.scs.dws.DWSConfig;
import com.huawei.hwclouds.scs.mysql.parser.MysqlSchemaParser;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlRoot;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.util.SqlString;
import com.huawei.hwclouds.scs.sql.writer.SqlPrettyWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MysqlConvertor
implements DatabaseConvertor {
    private SqlRoot root = null;
    private SqlDialect dialect = SqlDialect.DWS;
    private DWSConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs = new HashMap<String, ConvertConfig>();

    public MysqlConvertor(Map<String, DWSConfig> configs) {
        this(null, configs);
    }

    public MysqlConvertor(DWSConfig dwsConfig, Map<String, DWSConfig> configs) {
        this.defaultConfig = dwsConfig == null ? DWSConfig.buildConfig() : dwsConfig;
        Map<String, DWSConfig> tableDefaultConfigs = DWSConfig.loadTableConfigs();
        for (Map.Entry<String, DWSConfig> et : tableDefaultConfigs.entrySet()) {
            this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
        }
        if (configs != null) {
            for (Map.Entry<String, DWSConfig> et : configs.entrySet()) {
                this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
            }
        }
    }

    public void parse(String sql) throws ParserException {
        MysqlSchemaParser parser = new MysqlSchemaParser();
        SqlRoot sqlNode = parser.parse(sql);
        if (this.root == null) {
            this.root = sqlNode;
        } else {
            this.root.addNode(sqlNode);
        }
    }

    public SqlString convert() throws ParserException {
        if (this.root == null) {
            throw new ParserException("No parse sql defined.");
        }
        UnParserContext context = new UnParserContext();
        SqlPrettyWriter writer = new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
        this.root.unparse(writer, context);
        return writer.toSqlString();
    }

    public void reset() {
        this.root = new SqlRoot();
    }

    public Map<String, ConvertConfig> getConfigs() {
        return this.tableConfigs;
    }
}

