/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.scs.dws.MysqlConvertor;
import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.util.SqlString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleClauseConvert {
    private static final Logger LOGGER = LogManager.getLogger(SingleClauseConvert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(String fromDb, String toDb, String originSql, String defaultDB, Map propMap, SchemaFilter filter, SchemaMapper mapper) throws ParserException, IOException {
        MysqlConvertor convertor = new MysqlConvertor(null);
        if (propMap == null) {
            propMap = new HashMap<String, String>();
        }
        propMap.put(MysqlPropEnum.TABLE_ORIENTATION_FOR_DWS.getValue(), "DEFAULT_CREATE_IN_DWS");
        propMap.put(MysqlPropEnum.TABLE_CREATE_COMMENT_CONSTRAINT.getValue(), "true");
        propMap.put(MysqlPropEnum.SCHEMA_NAME.getValue(), "ori");
        if (!fromDb.equalsIgnoreCase("MySQL")) {
            LOGGER.error("The source database \"" + fromDb + "\" is not supported for single statement conversion. Only MySQL is supported for now.");
            throw new ParserException("The source database \"" + fromDb + "\" is not supported for single statement conversion. Only MySQL is supported for now.");
        }
        if (!toDb.equalsIgnoreCase("DWS")) {
            LOGGER.error("The target database \"" + toDb + "\" is not supported for single statement conversion. Only DWS is supported for now.");
            throw new ParserException("The target database \"" + toDb + "\" is not supported for single statement conversion. Only DWS is supported for now.");
        }
        StringBuilder sb = new StringBuilder();
        String line = originSql;
        try {
            PropertyLoader.loadPropertyMap(propMap);
            sb.append(line);
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            sb.delete(0, sb.length());
            String beforeFormat = str.toString().replaceAll("\\s+", "");
            String afterFormat = SqlFormatter.format((String)str.toString()).replaceAll("\\s+", "");
            if (beforeFormat.equalsIgnoreCase(afterFormat)) {
                String string = SqlString.handleErrorRes(SqlFormatter.format((String)str.toString()));
                return string;
            }
            String string = str.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Can't Convert The Sql \n" + line);
            String string = "/* sql not support\r\n" + line + "\r\n*/;";
            return string;
        }
        finally {
            PropertyLoader.clearPropMapCxt();
        }
    }

    public static interface SchemaMapper {
        public String mapper(String var1);

        public String mapper(String var1, String var2);

        public String mapper(String var1, String var2, String var3);

        public String mapper(String var1, String var2, String var3, String var4);
    }

    public static interface SchemaFilter {
        public boolean filter(String var1, String var2);

        public boolean filter(String var1, String var2, String var3);

        public boolean filter(String var1, String var2, String var3, String var4);

        public String ddlOperations(String var1, String var2, String var3);
    }
}

