/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlRenameColumn;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlRenameColumn.class)
public class SqlAlterRenameColumnUnParser
implements UnParser<SqlRenameColumn> {
    @Override
    public void unparse(SqlRenameColumn sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("ALTER TABLE").writeSpace(1);
        sqlNode.getTableName().unparse(writer, context);
        String oldColumn = QuoteUtils.addDoubleQuoteForDigitField(sqlNode.getOldColumn());
        String newColumn = QuoteUtils.addDoubleQuoteForDigitField(sqlNode.getNewColumn());
        writer.append("RENAME COLUMN").writeSpace(1).append(oldColumn).writeSpace(1).append("TO").writeSpace(1);
        String caseSensitive = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_COLUMN_CASE_SENSITIVE.getValue());
        if (caseSensitive.equalsIgnoreCase("true")) {
            writer.append(newColumn).append(";");
        } else {
            ConvertConfig configForCase = writer.getConfig("param.config.flag");
            if (ConfigUtil.getConfigValue(configForCase, "table.create.columnCase", "true").equalsIgnoreCase("true")) {
                writer.append(newColumn.toLowerCase(Locale.ROOT)).append(";");
            } else {
                writer.append(newColumn).append(";");
            }
        }
    }
}

