/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableOptionAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionCharset;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionCollate;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionEngine;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionUnion;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlAlterTableOptionAction.class)
public class SqlAlterTableOptionActionUnParser
implements UnParser<SqlAlterTableOptionAction> {
    private static final Logger LOGGER = LogManager.getLogger(SqlAlterTableOptionActionUnParser.class);

    @Override
    public void unparse(SqlAlterTableOptionAction sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getOptions() != null) {
            for (int i = 0; i < sqlNode.getOptions().getNodes().size(); ++i) {
                SqlTableOption sqlTableOption = sqlNode.getOptions().getNodes().get(i);
                if (sqlTableOption instanceof SqlTableOptionEngine || sqlTableOption instanceof SqlTableOptionCharset || sqlTableOption instanceof SqlTableOptionCollate) {
                    LOGGER.error("Engine, charset, collate of alter table actions are not supported in DWS.");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter table actions(engine,charset,collate)");
                }
                if (sqlTableOption instanceof SqlTableOptionUnion) continue;
                sqlNode.getOptions().unparse(writer, context);
            }
        }
    }
}

