/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTableTruncatePartitionAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlAlterTableTruncatePartitionAction.class)
public class SqlAlterTableTruncatePartitionActionUnParser
implements UnParser<SqlAlterTableTruncatePartitionAction> {
    private static final Logger LOGGER = LogManager.getLogger(SqlAlterTableTruncatePartitionActionUnParser.class);

    @Override
    public void unparse(SqlAlterTableTruncatePartitionAction sqlNode, SqlWriter writer, UnParserContext context) {
        String content = writer.toSqlString().getSql();
        writer.writeSpace(1).append("TRUNCATE PARTITION");
        if (sqlNode.getPartitionName() != null) {
            List<SqlIdentifier> partitionNames = sqlNode.getPartitionName();
            for (int i = 0; i < partitionNames.size(); ++i) {
                if (i == 0) {
                    writer.writeSpace(1).append(partitionNames.get(i).getIdentifier());
                    continue;
                }
                writer.append(";").newLine();
                writer.append(content).writeSpace(1);
                writer.append("TRUNCATE PARTITION").writeSpace(1).append(partitionNames.get(i).getIdentifier());
            }
        } else if (sqlNode.isAll()) {
            LOGGER.error("TRUNCATE PARTITION ALL is not supported in dsc");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "truncate partition all");
        }
    }
}

