/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterRenameTableAction;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterTable;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlAlterTable.class)
public class SqlAlterTableUnParser
implements UnParser<SqlAlterTable> {
    private static final Logger LOGGER = LogManager.getLogger(SqlAlterTableUnParser.class);

    @Override
    public void unparse(SqlAlterTable sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        context.setCurrentTableName(sqlNode.getTableName());
        if (!sqlNode.getActions().isEmpty()) {
            SqlWriter nWriter = writer.cloneEmpty();
            nWriter.append("ALTER TABLE");
            if (sqlNode.isExists()) {
                nWriter.writeSpace(1).append("IF EXISTS");
            }
            nWriter.writeSpace(1);
            sqlNode.getTableName().unparse(nWriter, context);
            long strLength = nWriter.toSqlString().getSql().length();
            for (int i2 = 0; i2 < sqlNode.getActions().size(); ++i2) {
                String sql;
                if (sqlNode.getActions().get(i2).getClass().equals(SqlAlterRenameTableAction.class)) {
                    sqlNode.getActions().get(i2).setTableName(sqlNode.getTableName());
                }
                sqlNode.getActions().get(i2).unparse(nWriter, context);
                if (i2 == sqlNode.getActions().size() - 1 || (sql = nWriter.toSqlString().getSql()).endsWith(",")) continue;
                nWriter.append(",");
            }
            if (strLength != (long)nWriter.toSqlString().getSql().length()) {
                String sqlEnd = nWriter.toSqlString().getSql();
                if (sqlEnd.endsWith(",")) {
                    SqlWriter sqlWriter = nWriter.cloneEmpty();
                    sqlWriter.append(sqlEnd.substring(0, sqlEnd.length() - 1));
                    sqlWriter.sqlEnd();
                    writer.append(sqlWriter);
                } else {
                    nWriter.sqlEnd();
                    writer.append(nWriter);
                }
            }
        }
        context.setNodeListSeparator(";");
        sqlNode.getIndexExtNodeSql().unparse(writer, context);
        for (i = 0; i < sqlNode.getSqlRenameColumnList().size(); ++i) {
            sqlNode.getSqlRenameColumnList().get(i).unparse(writer, context);
        }
        for (i = 0; i < sqlNode.getSqlRenameIndexList().size(); ++i) {
            sqlNode.getSqlRenameIndexList().get(i).unparse(writer, context);
        }
        if (sqlNode.getAlterType() != null) {
            LOGGER.error("IndexVisibility, storagePolicy ...etc of alter table actions are not supported in DWS.");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "IndexVisibility, storagePolicy ...etc of alter table actions");
        }
        sqlNode.getIndependentSqls().unparse(writer, context);
        context.resetNodeListSeparator();
        if (sqlNode.isRemovePartition()) {
            SqlWriter sqlWriter = writer.cloneEmpty();
            sqlWriter.append("/* ").append("ALTER TABLE").writeSpace(1);
            sqlNode.getTableName().unparse(sqlWriter, context);
            sqlWriter.writeSpace(1).append("REMOVE").writeSpace(1).append("PARTITIONING;").writeSpace(1).append("*/");
            writer.append(sqlWriter);
        }
    }
}

