/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.unparser.SqlExpressionUnParser;
import com.huawei.hwclouds.scs.dws.util.ColumnUtil;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlColumnDefinition.class)
public class SqlColumnDefinitionUnParser
implements UnParser<SqlColumnDefinition> {
    private static final Logger LOGGER = LogManager.getLogger(SqlColumnDefinitionUnParser.class);
    private static Set<SqlTypeName> unSupportDistributedColumns = new HashSet<SqlTypeName>();

    @Override
    public void unparse(SqlColumnDefinition sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isAutoIncrement()) {
            switch (sqlNode.getDataType().getTypeName()) {
                case TINYINT: {
                    sqlNode.getDataType().setTypeName(SqlTypeName.SMALLSERIAL);
                    sqlNode.getDataType().setPrecision(null);
                    sqlNode.getDataType().setScale(null);
                    break;
                }
                case SMALLINT: {
                    if (sqlNode.getDataType().getUnsigned().booleanValue()) {
                        sqlNode.getDataType().setTypeName(SqlTypeName.SERIAL);
                    } else {
                        sqlNode.getDataType().setTypeName(SqlTypeName.SMALLSERIAL);
                    }
                    sqlNode.getDataType().setPrecision(null);
                    sqlNode.getDataType().setScale(null);
                    break;
                }
                case DOUBLE: 
                case FLOAT: 
                case SERIAL: 
                case BIGINT: {
                    sqlNode.getDataType().setTypeName(SqlTypeName.BIGSERIAL);
                    sqlNode.getDataType().setPrecision(null);
                    sqlNode.getDataType().setScale(null);
                    break;
                }
                case INT: 
                case INTEGER: {
                    if (sqlNode.getDataType().getUnsigned().booleanValue()) {
                        sqlNode.getDataType().setTypeName(SqlTypeName.BIGSERIAL);
                    } else {
                        sqlNode.getDataType().setTypeName(SqlTypeName.SERIAL);
                    }
                    sqlNode.getDataType().setPrecision(null);
                    sqlNode.getDataType().setScale(null);
                    break;
                }
                default: {
                    sqlNode.getDataType().setTypeName(SqlTypeName.SERIAL);
                    sqlNode.getDataType().setPrecision(null);
                    sqlNode.getDataType().setScale(null);
                    break;
                }
            }
        } else if (SqlTypeName.SERIAL.getName().equals(sqlNode.getDataType().getTypeName().getName())) {
            sqlNode.getDataType().setTypeName(SqlTypeName.BIGSERIAL);
            sqlNode.getDataType().setPrecision(null);
            sqlNode.getDataType().setScale(null);
        }
        sqlNode.getColumnName().unparse(writer, context);
        writer.writeSpace(1);
        sqlNode.getDataType().setFiledNameForEnum(sqlNode.getColumnName().getIdentifier());
        this.convertColTypeForDistributeCol(sqlNode);
        sqlNode.getDataType().setColumnName(sqlNode.getColumnName());
        sqlNode.getDataType().unparse(writer, context);
        SqlLiteral nonNotNon = sqlNode.getNonNotNon();
        if (!(nonNotNon == null || nonNotNon.isNull() || sqlNode.getDataType().getTypeName().toString().equals("JSONB") && sqlNode.isAddColumn())) {
            writer.writeSpace(1).append("NOT NULL").writeSpace(1);
        }
        if (sqlNode.getDefaultValue() != null) {
            if (sqlNode.getDefaultValue().getValue() != null) {
                writer.writeSpace(1).append("DEFAULT").writeSpace(1);
                if (sqlNode.getDefaultValue().isExpression()) {
                    writer.append("(");
                    SqlExpression sqlExpression = (SqlExpression)sqlNode.getDefaultValue().getValue();
                    new SqlExpressionUnParser().unparse(sqlExpression, writer, context);
                    writer.writeSpace(1).append(")");
                } else {
                    if (!sqlNode.getDefaultValue().isSpecialType()) {
                        sqlNode.getDefaultValue().setValue(ColumnUtil.getDefaultValue(sqlNode.getDataType(), sqlNode.getDefaultValue()));
                    }
                    sqlNode.getDefaultValue().unparse(writer, context);
                }
            } else if (nonNotNon != null && !nonNotNon.isNull()) {
                this.unparseDefaultWithNotNull(sqlNode, writer, context);
            } else {
                writer.writeSpace(1).append("DEFAULT NULL");
            }
        } else if (nonNotNon != null && !nonNotNon.isNull()) {
            this.unparseDefaultWithNotNull(sqlNode, writer, context);
        }
        ConvertConfig config = writer.getConfig(context.getCurrentTableName().getTableName().getIdentifier());
        this.verifySqlNode(sqlNode, writer, context, config);
    }

    private void convertColTypeForDistributeCol(SqlColumnDefinition sqlNode) {
        boolean isPKorUK;
        boolean bl = isPKorUK = sqlNode.isConstraintPK() || sqlNode.isConstraintUK() || sqlNode.isUniquekey() || sqlNode.isPrimaryKey();
        if (isPKorUK && unSupportDistributedColumns.contains((Object)sqlNode.getDataType().getTypeName())) {
            switch (sqlNode.getDataType().getTypeName()) {
                case DOUBLE: 
                case FLOAT: 
                case DOUBLE_PRECISION: {
                    sqlNode.getDataType().setTypeName(SqlTypeName.DECIMAL);
                    break;
                }
            }
        }
    }

    private void verifySqlNode(SqlColumnDefinition sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig config) {
        if (sqlNode.isAutoIncrement()) {
            switch (writer.getDialect()) {
                case DWS: 
                case POSTGRESQL: {
                    break;
                }
                default: {
                    LOGGER.error("The keyword 'AutoIncrement' is only supported in DWS and PostgreSql");
                    throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "The keyword 'AutoIncrement' is only supported in DWS and PostgreSql. Syntax : autoincrement of " + (Object)((Object)writer.getDialect()));
                }
            }
        }
        if (sqlNode.isPrimaryKey() && !sqlNode.isConstraintPK()) {
            writer.writeSpace(1).append("PRIMARY").writeSpace(1).append("KEY");
        }
        if (sqlNode.isUniquekey() && !sqlNode.isConstraintUK()) {
            writer.writeSpace(1).append("UNIQUE");
        }
        if (sqlNode.getSqlCheckColumnConstraint() != null) {
            sqlNode.getSqlCheckColumnConstraint().unparse(writer, context);
        }
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        if (sqlNode.getOnUpdateValue() != null && !stringProperty.contains("811") && !stringProperty.contains("813")) {
            writer.writeSpace(1).append("ONUPDATE").append(sqlNode.getOnUpdateValue());
        }
        if (sqlNode.getComment() != null && !stringProperty.contains("811")) {
            writer.writeSpace(1);
            sqlNode.getComment().unparse(writer, context);
        }
        if (sqlNode.getColumnFormat() != null) {
            writer.writeSpace(1).append("COLUMN_FORMAT").writeSpace(1).append(sqlNode.getColumnFormat());
        }
        if (sqlNode.getStorage() != null) {
            writer.writeSpace(1).append("STORAGE").writeSpace(1).append(sqlNode.getColumnFormat());
        }
    }

    private void unparseDefaultWithNotNull(SqlColumnDefinition sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isAddColumn()) {
            switch (sqlNode.getDataType().getOriTypeName().toString().toUpperCase(Locale.ROOT)) {
                case "TINYINT": 
                case "SMALLINT": 
                case "MEDIUMINT": 
                case "INT": 
                case "INTEGER": 
                case "BIGINT": 
                case "TINYINT UNSIGNED": 
                case "SMALLINT UNSIGNED": 
                case "MEDIUMINT UNSIGNED": 
                case "INT UNSIGNED": 
                case "BIGINT UNSIGNED": 
                case "FLOAT": 
                case "FLOAT UNSIGNED": 
                case "DOUBLE": 
                case "DOUBLE UNSIGNED": 
                case "DOUBLE_PRECISION": 
                case "REAL": 
                case "NUMERIC": 
                case "DECIMAL": 
                case "BOOLEAN": 
                case "BOOL": {
                    writer.append("DEFAULT").writeSpace(1).append("0");
                    break;
                }
                case "CHAR": 
                case "CHARACTER": 
                case "NCHAR": 
                case "VARCHAR": 
                case "TINYTEXT": 
                case "TEXT": 
                case "MEDIUMTEXT": 
                case "LONGTEXT": 
                case "BINARY": 
                case "VARBINARY": 
                case "CHARBYTE": 
                case "TINYBLOB": 
                case "BLOB": 
                case "BYTEA": 
                case "MEDIUMBLOB": 
                case "LONGBLOB": 
                case "SET": {
                    writer.append("DEFAULT").writeSpace(1).append("''");
                    break;
                }
                case "DATE": {
                    writer.append("DEFAULT").writeSpace(1).append("'1970-01-01'");
                    break;
                }
                case "TIME": {
                    writer.append("DEFAULT").writeSpace(1).append("'00:00:00'");
                    break;
                }
                case "DATETIME": 
                case "TIMESTAMP": {
                    writer.append("DEFAULT").writeSpace(1).append("'1970-01-01 00:00:00");
                    if (sqlNode.getDataType().getPrecision() != null && sqlNode.getDataType().getPrecision() > 0L) {
                        writer.append(".");
                        for (int i = 0; (long)i < sqlNode.getDataType().getPrecision() && i < 6; ++i) {
                            writer.append("0");
                        }
                    }
                    writer.append("'");
                    break;
                }
                case "YEAR": {
                    writer.append("DEFAULT").writeSpace(1).append("'0000'");
                    break;
                }
                case "BIT": {
                    writer.append("DEFAULT").writeSpace(1);
                    if (sqlNode.getDataType().getPrecision() == null) break;
                    writer.append("0::BIT(").append(sqlNode.getDataType().getPrecision().toString()).append(")").writeSpace(1);
                    break;
                }
                case "ENUM": {
                    writer.append("DEFAULT").writeSpace(1);
                    writer.append(sqlNode.getDataType().getStringLiteral().get(0)).writeSpace(1);
                    break;
                }
                case "SERIAL": {
                    LOGGER.error("DWS 's not supported to alter table add serial column");
                    throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "alter table add serial column", "alter table add serial column");
                }
            }
        }
    }

    static {
        unSupportDistributedColumns.add(SqlTypeName.DOUBLE);
        unSupportDistributedColumns.add(SqlTypeName.FLOAT);
    }
}

