/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.CreateIndexUtil;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlCreateIndex.class)
public class SqlCreateIndexUnParser
implements UnParser<SqlCreateIndex> {
    private static final Logger LOGGER = LogManager.getLogger(SqlCreateIndexUnParser.class);

    @Override
    public void unparse(SqlCreateIndex sqlCreateIndex, SqlWriter writer, UnParserContext context) {
        String comment;
        boolean isComment;
        block10: {
            block9: {
                isComment = this.isCommentIndex(sqlCreateIndex, writer);
                if (isComment) {
                    writer.append("/* ");
                }
                this.unparseIndexBody(sqlCreateIndex, writer, context);
                if (sqlCreateIndex.getSpecialType() == null) break block9;
                switch (sqlCreateIndex.getSpecialType()) {
                    case NORMAL: 
                    case PRIMARY: 
                    case UNIQUE: {
                        break block10;
                    }
                    case SPATIAL: {
                        writer.writeSpace(1).append("USING").writeSpace(1).append("GIST");
                        break block10;
                    }
                    case FULLTEXT: {
                        writer.writeSpace(1).append("USING").writeSpace(1).append("GIN(to_tsvector(coalesce(");
                        sqlCreateIndex.getIndexColumns().unparse(writer, context);
                        writer.append(",'')))").sqlEnd();
                        if (isComment) {
                            writer.append(" */");
                        }
                        return;
                    }
                    default: {
                        LOGGER.error("Not supported index special type " + (Object)((Object)sqlCreateIndex.getSpecialType()));
                        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "index special type " + (Object)((Object)sqlCreateIndex.getSpecialType()));
                    }
                }
            }
            this.unparseBtreeHashIndex(sqlCreateIndex, writer);
        }
        context.setNodeListSeparator(",");
        writer.writeSpace(1);
        writer.append("(");
        sqlCreateIndex.getIndexColumns().unparse(writer, context);
        writer.append(")");
        if (sqlCreateIndex.getOptions() != null && sqlCreateIndex.getOptions().getIndexOptions() != null && sqlCreateIndex.getOptions().getIndexOptions().containsKey("COMMENT") && (comment = sqlCreateIndex.getOptions().getIndexOptions().get("COMMENT")) != null) {
            StringBuilder sb = new StringBuilder(comment);
            sb.replace(0, 1, "'");
            sb.replace(sb.length() - 1, sb.length(), "'");
            writer.writeSpace(1).append("COMMENT").writeSpace(1).append(sb.toString());
        }
        writer.sqlEnd();
        if (isComment) {
            writer.append(" */");
        }
        context.resetNodeListSeparator();
    }

    private void unparseIndexBody(SqlCreateIndex sqlCreateIndex, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE INDEX");
        if (sqlCreateIndex.getIndexName() != null) {
            this.createIndexNameByArgs(sqlCreateIndex, writer, context);
        } else {
            SqlIdentifier sqlIndexName = sqlCreateIndex.getConstructedIndexName(writer, context);
            writer.writeSpace(1);
            sqlIndexName.unparse(writer, context);
        }
        writer.writeSpace(1).append("ON").writeSpace(1);
        if (sqlCreateIndex.getTableName() == null) {
            LOGGER.error("Can not found table name when create index.");
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Can not found table name when create index.");
        }
        sqlCreateIndex.getTableName().unparse(writer, context);
    }

    private void createIndexNameByArgs(SqlCreateIndex sqlCreateIndex, SqlWriter writer, UnParserContext context) {
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        String indexName = sqlCreateIndex.getIndexName().getIdentifier();
        String tableName = sqlCreateIndex.getTableName().getTableName().getIdentifier();
        if (stringProperty.toUpperCase(Locale.ROOT).contains("INDEX_RENAME")) {
            writer.writeSpace(1);
            writer.append(CreateIndexUtil.appendIndexNameWithTableName(indexName, tableName));
            return;
        }
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.index.rename", "false").equalsIgnoreCase("true")) {
            writer.writeSpace(1);
            writer.append(CreateIndexUtil.appendIndexNameWithTableName(indexName, tableName));
            return;
        }
        writer.writeSpace(1);
        sqlCreateIndex.getIndexName().unparse(writer, context);
    }

    private void unparseBtreeHashIndex(SqlCreateIndex sqlCreateIndex, SqlWriter writer) {
        if (sqlCreateIndex.getIndexType() != null) {
            if (sqlCreateIndex.getIndexType().equals("BTREE")) {
                writer.writeSpace(1).append("USING").writeSpace(1).append("BTREE");
            }
        } else if (sqlCreateIndex.getOptions() != null) {
            Map<String, String> res = sqlCreateIndex.getOptions().getIndexOptions();
            if (res.containsKey("INDEX_TYPE") && res.get("INDEX_TYPE").equals("BTREE")) {
                writer.writeSpace(1).append("USING").writeSpace(1).append("BTREE");
            }
        } else {
            writer.writeSpace(1).append("USING").writeSpace(1).append("BTREE");
        }
    }

    private boolean isCommentIndex(SqlCreateIndex sqlCreateIndex, SqlWriter writer) {
        String isMapComment;
        boolean isComment = false;
        boolean isGoal = false;
        SqlCreateIndex.SpecialType specialType = sqlCreateIndex.getSpecialType();
        if (specialType != null && (specialType.equals((Object)SqlCreateIndex.SpecialType.PRIMARY) || specialType.equals((Object)SqlCreateIndex.SpecialType.UNIQUE) || specialType.equals((Object)SqlCreateIndex.SpecialType.FULLTEXT))) {
            isGoal = true;
        }
        if ((isMapComment = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_CREATE_COMMENT_CONSTRAINT.getValue())).equalsIgnoreCase("true")) {
            if (isGoal) {
                isComment = true;
            }
        } else {
            ConvertConfig commentConfig = writer.getConfig("table.create.comment.constraint");
            if (ConfigUtil.getConfigValue(commentConfig, "table.create.comment.constraint", "false").equalsIgnoreCase("true") && isGoal) {
                isComment = true;
            }
        }
        if (sqlCreateIndex.getIndexColumns() != null && sqlCreateIndex.getIndexColumns().getNodes().get(0).getColumnName().getIdentifier().equals("__adb_auto_id__")) {
            isComment = true;
        }
        return isComment;
    }
}

