/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.CreateIndexUtil;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.dws.util.TableUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.config.PartitionKeyChooseStrategy;
import com.huawei.hwclouds.scs.sql.nodes.SqlCheckTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlDataTypeSpec;
import com.huawei.hwclouds.scs.sql.nodes.SqlDistributeOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlDistributionOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlFKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlKeysTypeOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinitions;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionOptionParameter;
import com.huawei.hwclouds.scs.sql.nodes.SqlStructDataType;
import com.huawei.hwclouds.scs.sql.nodes.SqlStructType;
import com.huawei.hwclouds.scs.sql.nodes.SqlSynapseTableOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionComment;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionCompress;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionCompressLevel;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionOrientation;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionRowFormat;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionTablespace;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionUnion;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeFamily;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.nodes.SqlUKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.StructInfo;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.ConvertRuntimeException;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlCreateTable.class)
public class SqlCreateTableUnParser
implements UnParser<SqlCreateTable> {
    private static final Logger LOGGER = LogManager.getLogger(SqlCreateTableUnParser.class);
    private static final String STORAGE_POLICY_COLD = "'COLD'";
    private static final String STORAGE_POLICY_MIXED = "'MIXED'";
    private static final String ADB_AUTO_ID = "__adb_auto_id__";

    @Override
    public void unparse(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig commentConfig;
        ConvertConfig bigQueryConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(bigQueryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery")) {
            this.appendCreateType(sqlNode, writer, context);
        }
        if (sqlNode.isExternal()) {
            LOGGER.error("Create external table is not supported in dws");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create external table");
        }
        context.setCurrentTableName(sqlNode.getTableName());
        ConvertConfig config = writer.getConfig(sqlNode.getTableName().getTableName().getIdentifier());
        SqlNodeList<SqlTableOption> newList = new SqlNodeList<SqlTableOption>();
        SqlNodeList<SqlDistributeOptions> distributeByList = new SqlNodeList<SqlDistributeOptions>();
        SqlNodeList<SqlTableOptionComment> commentList = new SqlNodeList<SqlTableOptionComment>();
        SqlNodeList<SqlKeysTypeOptions> keysTypeList = new SqlNodeList<SqlKeysTypeOptions>();
        if (sqlNode.getOptions() == null) {
            sqlNode.setOptions(new SqlNodeList<SqlTableOption>());
        } else {
            for (int i = 0; i < sqlNode.getOptions().getNodes().size(); ++i) {
                if (sqlNode.getOptions().getNodes().get(i) instanceof SqlTableOptionRowFormat) continue;
                if (sqlNode.getOptions().getNodes().get(i) instanceof SqlTableOptionUnion) {
                    this.checkSqlNodeWithUnion(sqlNode, writer, context);
                    sqlNode.getOptions().getNodes().get(i).unparse(writer, context);
                    return;
                }
                SqlTableOption option = sqlNode.getOptions().getNodes().get(i);
                if (option instanceof SqlTableOptionComment) {
                    commentList.addNode((SqlTableOptionComment)option);
                    continue;
                }
                if (option instanceof SqlDistributeOptions) {
                    distributeByList.addNode((SqlDistributeOptions)option);
                    continue;
                }
                if (option instanceof SqlKeysTypeOptions) {
                    SqlKeysTypeOptions keysTypeOptions = (SqlKeysTypeOptions)option;
                    if (sqlNode.getPartitionDefinitions() != null) {
                        keysTypeOptions.setPartition(true);
                    }
                    keysTypeList.addNode((SqlKeysTypeOptions)option);
                    continue;
                }
                newList.addNode(sqlNode.getOptions().getNodes().get(i));
            }
        }
        SqlCreateTable sqlCreateTable = this.checkPrimaryKeyAndUnique(sqlNode);
        this.handlePartitionPeriod(sqlNode);
        this.convertSchema(sqlNode, writer, context, config);
        String orientationValue = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_ORIENTATION_FOR_DWS.getValue());
        if (!orientationValue.equalsIgnoreCase("DEFAULT_CREATE_IN_DWS")) {
            this.optionOrientation(config, newList, writer, context, sqlNode);
        }
        String storage = "";
        for (SqlNode sqlNode2 : sqlNode.getOptions().getNodes()) {
            if (!(sqlNode2 instanceof SqlTableOptionTablespace)) continue;
            storage = ((SqlTableOptionTablespace)sqlNode2).getTablespaceStorage();
            break;
        }
        config.setStringValue("table.tablespace.storage", storage);
        this.unparseCompressedReplicatedTable(sqlNode, writer, context, config, distributeByList);
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        if (commentList.getNodes().size() > 0 && !stringProperty.contains("811")) {
            StringBuilder stringBuilder = new StringBuilder(((SqlTableOptionComment)commentList.getNodes().get(0)).getStringLiteral());
            stringBuilder.replace(0, 1, "'");
            stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "'");
            writer.newLine().indentation(1).append("COMMENT").writeSpace(1).append(stringBuilder.toString());
        }
        if (sqlNode.getSqlTableOptionRowFormat() != null) {
            writer.append("/*").writeSpace(1).append("ROW_FORMAT").writeSpace(1).append("=").writeSpace(1);
            writer.append(sqlNode.getSqlTableOptionRowFormat().getRowFormat().toString()).append("*/");
        }
        if (sqlNode.getRtEngine() != null) {
            writer.append("/* ").append("RT_ENGINE = ").append(sqlNode.getRtEngine()).writeSpace(1).append("*/");
        }
        if (sqlNode.isRemovePartition()) {
            writer.append("/* ").append("REMOVE").writeSpace(1).append("PARTITIONING").writeSpace(1).append("*/");
        }
        if (sqlNode.getTableOptionTextList() != null && !sqlNode.getTableOptionTextList().isEmpty()) {
            for (String optionText : sqlNode.getTableOptionTextList()) {
                writer.append("/* ").append(optionText).append(" */");
            }
        }
        writer.sqlEnd();
        String string = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_CREATE_COMMENT_CONSTRAINT.getValue());
        if (!string.equalsIgnoreCase("true") && !ConfigUtil.getConfigValue(commentConfig = writer.getConfig("table.create.comment.constraint"), "table.create.comment.constraint", "false").equalsIgnoreCase("true")) {
            this.createIndexOfRemoveUnique(sqlNode, writer, context, sqlCreateTable);
        }
        this.getSqlNode(sqlNode, writer, context);
        this.getKeysTypeOptionsSqlNode(keysTypeList, writer, context);
        if (stringProperty.contains("811")) {
            this.appendComment(commentList, sqlNode, writer, context);
        }
    }

    private void handlePartitionPeriod(SqlCreateTable sqlNode) {
        List<SqlColumnDefinition> columns = sqlNode.getColumns();
        if (sqlNode.getPartitionDefinitions() != null && sqlNode.getPartitionDefinitions().getPartitionFunctionDefinition() != null && sqlNode.getPartitionDefinitions().getPartitionFunctionDefinition().getFullColumnName() != null) {
            String columnName = sqlNode.getPartitionDefinitions().getPartitionFunctionDefinition().getFullColumnName();
            if (columnName.equalsIgnoreCase("_PARTITIONDATE")) {
                SqlColumnDefinition partitionCol = new SqlColumnDefinition();
                partitionCol.setColumnName(new SqlIdentifier(columnName));
                SqlDataTypeSpec sqlDataTypeSpec = new SqlDataTypeSpec();
                sqlDataTypeSpec.setTypeName(SqlTypeName.DATE);
                sqlDataTypeSpec.setOriTypeName(SqlTypeName.DATE);
                partitionCol.setDataType(sqlDataTypeSpec);
                partitionCol.setDefaultValue(new SqlLiteral(SqlTypeName.ANY, "CURRENT_DATE"));
                columns.add(partitionCol);
            } else if (columnName.equalsIgnoreCase("_PARTITIONTIME")) {
                SqlColumnDefinition partitionCol = new SqlColumnDefinition();
                partitionCol.setColumnName(new SqlIdentifier(columnName));
                SqlDataTypeSpec sqlDataTypeSpec = new SqlDataTypeSpec();
                sqlDataTypeSpec.setTypeName(SqlTypeName.TIMESTAMP);
                sqlDataTypeSpec.setOriTypeName(SqlTypeName.TIMESTAMP);
                partitionCol.setDataType(sqlDataTypeSpec);
                partitionCol.setDefaultValue(new SqlLiteral(SqlTypeName.ANY, "CURRENT_TIMESTAMP"));
                columns.add(partitionCol);
                if (sqlNode.getPartitionDefinitions().getPartitionFunctionDefinition().getPartitionInterval() == null) {
                    sqlNode.getPartitionDefinitions().getPartitionFunctionDefinition().setPartitionInterval("hour");
                }
            }
        }
    }

    private void appendComment(SqlNodeList<SqlTableOptionComment> commentList, SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        List<SqlColumnDefinition> columns = sqlNode.getColumns();
        SqlTableName tableName = sqlNode.getTableName();
        if (commentList.getNodes().size() > 0) {
            StringBuilder sb = new StringBuilder(commentList.getNodes().get(0).getStringLiteral());
            sb.replace(0, 1, "'");
            sb.replace(sb.length() - 1, sb.length(), "'");
            writer.append("COMMENT ON TABLE ");
            tableName.getTableName().unparse(writer, context);
            writer.append("IS ").append(sb.toString());
            writer.sqlEnd();
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i).getComment() == null) continue;
            writer.append("COMMENT ON COLUMN ");
            tableName.getTableName().unparse(writer, context);
            writer.append(".");
            columns.get(i).getColumnName().unparse(writer, context);
            writer.append("IS ");
            this.dealWithKeyWordForComment(columns.get(i));
            columns.get(i).getComment().unparse(writer, context);
            writer.sqlEnd();
        }
    }

    private void dealWithKeyWordForComment(SqlColumnDefinition column) {
        String commentValue = column.getComment().getValue().toString();
        StringBuilder comment = new StringBuilder(commentValue);
        comment.replace(0, 7, "");
        column.setComment(new SqlLiteral(SqlTypeName.ANY, comment));
    }

    private void appendCreateType(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        List<SqlColumnDefinition> columns = sqlNode.getColumns();
        ArrayList<StructInfo> structInfoList = new ArrayList<StructInfo>();
        String tableName = this.dealWithTableName(sqlNode.getTableName(), writer, context);
        for (i = 0; i < columns.size(); ++i) {
            this.ifExistArrayOrStruct(columns.get(i).getDataType().getTypeName(), context);
            if (!columns.get(i).getDataType().getTypeName().equals((Object)SqlTypeName.STRUCT)) continue;
            SqlStructDataType structDataType = columns.get(i).getDataType().getStructDataType();
            this.dealWithStructDataType(structDataType, structInfoList, tableName, columns.get(i).getColumnName(), columns.get(i).getColumnName());
        }
        context.setStructInfoList(structInfoList);
        for (i = structInfoList.size() - 1; i >= 0; --i) {
            writer.append("CREATE TYPE ");
            writer.append(((StructInfo)structInfoList.get(i)).getTableName() + "_" + ((StructInfo)structInfoList.get(i)).getColumnName().getIdentifier() + "_" + ((StructInfo)structInfoList.get(i)).getFieldName().getIdentifier()).writeSpace(1);
            writer.append("AS (");
            List<SqlStructType> nodes = ((StructInfo)structInfoList.get(i)).getStructDataType().getSqlStructTypeSqlNodeList().getNodes();
            for (int j = 0; j < nodes.size(); ++j) {
                SqlWriter sqlWriter = writer.cloneEmpty();
                writer.append(nodes.get(j).getUid()).writeSpace(1);
                context.setColumnNameForStructType(new SqlIdentifier(((StructInfo)structInfoList.get(i)).getColumnName().getIdentifier() + "_" + nodes.get(j).getUid()));
                nodes.get(j).getDataType().unparse(sqlWriter, context);
                context.setColumnNameForStructType(null);
                writer.append(sqlWriter);
                if (j == nodes.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(");\n");
        }
    }

    private void ifExistArrayOrStruct(SqlTypeName typeName, UnParserContext context) {
        if (typeName.equals((Object)SqlTypeName.STRUCT) || typeName.equals((Object)SqlTypeName.ARRAY)) {
            context.setExistArrayOrStruct(true);
        }
    }

    private void dealWithStructDataType(SqlStructDataType stuDataType, List<StructInfo> structInfoList, String tableName, SqlIdentifier columnName, SqlIdentifier fieldName) {
        StructInfo structInfo = new StructInfo();
        structInfo.setTableName(tableName);
        structInfo.setColumnName(columnName);
        structInfo.setFieldName(fieldName);
        structInfo.setStructDataType(stuDataType);
        structInfoList.add(structInfo);
        for (int i = 0; i < stuDataType.getSqlStructTypeSqlNodeList().getNodes().size(); ++i) {
            if (stuDataType.getSqlStructTypeSqlNodeList().getNodes().get(i).getDataType().getStructDataType() == null) continue;
            this.dealWithStructDataType(stuDataType.getSqlStructTypeSqlNodeList().getNodes().get(i).getDataType().getStructDataType(), structInfoList, tableName, columnName, new SqlIdentifier(stuDataType.getSqlStructTypeSqlNodeList().getNodes().get(i).getUid()));
        }
    }

    private String dealWithTableName(SqlTableName tableName, SqlWriter writer, UnParserContext context) {
        String res = QuoteUtils.removeAllQuote(tableName.getTableName().getIdentifier());
        String[] namePart = res.split("\\.");
        res = namePart[namePart.length - 1];
        if ("true".equalsIgnoreCase(context.getConfigValue(writer, "table.type.schema.prefix", "true"))) {
            if (tableName.getSchemaName() != null && tableName.getDatabaseName() != null) {
                res = QuoteUtils.removeAllQuote(tableName.getSchemaName().getIdentifier()) + "." + res;
            } else if (tableName.getDatabaseName() != null) {
                res = QuoteUtils.removeAllQuote(tableName.getDatabaseName().getIdentifier()) + "." + res;
            }
        }
        return res;
    }

    private void parseTableOptionsRowStore(SqlTableOptionOrientation op, SqlTableOptionCompress compress, ConvertConfig config) {
        op.setOrientation(SqlTableOptionOrientation.ORIENTATION.ROW);
        if (ConfigUtil.getConfigValue(config, "table.compress.row", "").equalsIgnoreCase("YES")) {
            compress.setCompress(SqlTableOptionCompress.COMPRESS.valueOf("YES"));
        }
        if (ConfigUtil.getConfigValue(config, "table.compress.row", "").equalsIgnoreCase("NO")) {
            compress.setCompress(SqlTableOptionCompress.COMPRESS.valueOf("NO"));
        }
    }

    private void parseTableOptionsColumnStore(SqlTableOptionOrientation op, SqlTableOptionCompress compress, ConvertConfig config, SqlTableOptionCompressLevel compressLevel) {
        op.setOrientation(SqlTableOptionOrientation.ORIENTATION.COLUMN);
        String tableCompressColumn = ConfigUtil.getConfigValue(config, "table.compress.column", null);
        if (tableCompressColumn == null || tableCompressColumn.isEmpty()) {
            return;
        }
        try {
            compress.setCompress(SqlTableOptionCompress.COMPRESS.valueOf(tableCompressColumn));
        }
        catch (Exception e) {
            throw new ParserRuntimeException(ParserExceptionDef.APPLICATION_ERROR, "can not set COMPRESSION,check this param in config file: table.compress.mode");
        }
        if (!tableCompressColumn.equalsIgnoreCase("NO")) {
            compressLevel.setCompressLevel(ConfigUtil.getConfigValue(config, "table.compress.level", "0"));
        }
    }

    public void partitionkeyUnparser(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig config) {
        List<SqlSynapseTableOption> nodes;
        boolean haveDistribution = false;
        if (sqlNode.getSqlWithOptions() != null) {
            nodes = sqlNode.getSqlWithOptions().getSqlSynapseTableOptionSqlNodeList().getNodes();
            for (SqlSynapseTableOption node : nodes) {
                if (node.getSqlDistributionOption() == null) continue;
                haveDistribution = true;
                break;
            }
        }
        if (haveDistribution) {
            nodes = sqlNode.getSqlWithOptions().getSqlSynapseTableOptionSqlNodeList().getNodes();
            for (SqlSynapseTableOption node : nodes) {
                if (node.getSqlDistributionOption() == null) continue;
                this.distributionForSynapse(node.getSqlDistributionOption(), writer);
            }
        } else {
            String partitionStrategy = ConfigUtil.getConfigValue(config, "table.partition-key.choose.strategy", null);
            if (partitionStrategy.equals("partitionKeyChooserStrategy")) {
                partitionStrategy = "com.huawei.hwclouds.scs.dws.DWSPartitionKeyChooserStrategy";
            }
            PartitionKeyChooseStrategy partitionKeyChooseStrategy = null;
            try {
                partitionKeyChooseStrategy = (PartitionKeyChooseStrategy)this.getClass().getClassLoader().loadClass(partitionStrategy).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new ConvertRuntimeException("Can not found partition strategy class:" + partitionStrategy, e);
            }
            SqlCreateTable sqlCreateTable = partitionKeyChooseStrategy.chooseDistributeKeyContainsConstraint(sqlNode, config);
            if (sqlCreateTable.getColumns() == null) {
                writer.append("ROUNDROBIN");
            } else {
                writer.append("HASH").writeSpace(1);
                writer.append("(");
                List<SqlTableConstraint> constraints = sqlCreateTable.getConstraints();
                if (constraints != null && !constraints.isEmpty()) {
                    SqlUKeyTableConstraint constraint = (SqlUKeyTableConstraint)constraints.get(0);
                    List<SqlIndexColumnName> indexColumns = constraint.getIndexColumns();
                    String caseSensitive = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_COLUMN_CASE_SENSITIVE.getValue());
                    ConvertConfig configForCase = writer.getConfig("param.config.flag");
                    if (caseSensitive.equalsIgnoreCase("true") || !ConfigUtil.getConfigValue(configForCase, "table.create.columnCase", "true").equalsIgnoreCase("true")) {
                        for (int i = 0; i < indexColumns.size(); ++i) {
                            String column = indexColumns.get(i).getColumnName().getIdentifier();
                            writer.append(QuoteUtils.addDoubleQuote(column));
                            if (i == indexColumns.size() - 1) continue;
                            writer.append(", ");
                        }
                    } else {
                        for (int i = 0; i < indexColumns.size(); ++i) {
                            String column = indexColumns.get(i).getColumnName().getIdentifier().toLowerCase(Locale.ROOT);
                            writer.append(QuoteUtils.addDoubleQuote(column));
                            if (i == indexColumns.size() - 1) continue;
                            writer.append(", ");
                        }
                    }
                } else {
                    List<SqlColumnDefinition> partitionColumns = sqlCreateTable.getColumns();
                    for (int i = 0; i < partitionColumns.size(); ++i) {
                        partitionColumns.get(i).getColumnName().unparse(writer, context);
                        if (i == partitionColumns.size() - 1) continue;
                        writer.append(", ");
                    }
                }
                writer.append(")");
            }
        }
    }

    private void distributionForSynapse(SqlDistributionOption sqlDistributionOption, SqlWriter writer) {
        ConvertConfig configForCase = writer.getConfig("param.config.flag");
        switch (sqlDistributionOption.getDistributionType()) {
            case "HASH": {
                writer.append("HASH(");
                for (int i = 0; i < sqlDistributionOption.getUidList().size(); ++i) {
                    if (ConfigUtil.getConfigValue(configForCase, "table.create.columnCase", "true").equalsIgnoreCase("true")) {
                        writer.append(QuoteUtils.addDoubleQuote(sqlDistributionOption.getUidList().get(i).toLowerCase(Locale.ROOT)));
                    } else {
                        writer.append(QuoteUtils.addDoubleQuote(sqlDistributionOption.getUidList().get(i)));
                    }
                    if (i == sqlDistributionOption.getUidList().size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(")");
                break;
            }
            case "ROUND_ROBIN": {
                writer.append("ROUND_ROBIN");
                break;
            }
            case "REPLICATE": {
                writer.append("REPLICATE");
                break;
            }
        }
    }

    private boolean isHavePrimary(SqlCreateTable sqlNode) {
        boolean isMutiple = false;
        for (SqlColumnDefinition sd : sqlNode.getColumns()) {
            if (!sd.isPrimaryKey()) continue;
            isMutiple = true;
            break;
        }
        return isMutiple;
    }

    private void convertSchema(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig config) {
        this.checkSqlNode(sqlNode, writer, context);
        ConvertConfig bigQueryConfig = writer.getConfig("param.config.flag");
        if (sqlNode.getSqlTableOptionClusteredBy() != null) {
            boolean otherConvertClusterBy;
            boolean bigQueryConvertClusterBy = ConfigUtil.getConfigValue(bigQueryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery") && ConfigUtil.getConfigValue(bigQueryConfig, "table.orientation", "COLUMN").equalsIgnoreCase("COLUMN") && !context.isExistArrayOrStruct();
            boolean bl = otherConvertClusterBy = !ConfigUtil.getConfigValue(bigQueryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery") && ConfigUtil.getConfigValue(config, "table.orientation", "COLUMN").equalsIgnoreCase("COLUMN");
            if (bigQueryConvertClusterBy || otherConvertClusterBy) {
                writer.append(",").newLine();
                sqlNode.getSqlTableOptionClusteredBy().unparse(writer, context);
            }
        }
        SqlWriter constraintsWriter = writer.cloneEmpty();
        if (sqlNode.getConstraints() != null && !sqlNode.getConstraints().isEmpty()) {
            if (sqlNode.isHaveAdbAutoId()) {
                constraintsWriter.append("/* ");
            }
            constraintsWriter.append(",");
            long clen = constraintsWriter.toSqlString().getSql().length();
            ArrayList<SqlTableConstraint> conList = new ArrayList<SqlTableConstraint>();
            for (SqlTableConstraint con : sqlNode.getConstraints()) {
                if (ConfigUtil.getConfigValue(config, "table.orientation", "ROW").equalsIgnoreCase("ROW")) {
                    boolean havePrimary = this.isHavePrimary(sqlNode);
                    if (con instanceof SqlFKeyTableConstraint || con instanceof SqlUKeyTableConstraint && havePrimary) continue;
                    conList.add(con);
                    continue;
                }
                if (con instanceof SqlFKeyTableConstraint || con instanceof SqlUKeyTableConstraint || con instanceof SqlCheckTableConstraint) continue;
                conList.add(con);
            }
            for (int i = 0; i < conList.size(); ++i) {
                SqlTableConstraint constraint = (SqlTableConstraint)conList.get(i);
                SqlWriter tmpConstraintsWriter = writer.cloneEmpty();
                tmpConstraintsWriter.newLine();
                tmpConstraintsWriter.indentation(1);
                int strLen = tmpConstraintsWriter.toSqlString().getSql().length();
                constraint.unparse(tmpConstraintsWriter, context);
                if (strLen != tmpConstraintsWriter.toSqlString().getSql().length()) {
                    constraintsWriter.append(tmpConstraintsWriter.toSqlString().getSql());
                }
                if (i == conList.size() - 1) continue;
                constraintsWriter.append(",");
            }
            if (sqlNode.isHaveAdbAutoId()) {
                constraintsWriter.append(" */");
            }
            if (clen != (long)constraintsWriter.toSqlString().getSql().length()) {
                writer.append(constraintsWriter.toSqlString().getSql());
            }
        }
        writer.newLine();
        writer.append(")");
    }

    private void checkSqlNodeWithUnion(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE");
        writer.writeSpace(1).append("VIEW");
        if (sqlNode.isIfExists()) {
            writer.writeSpace(1).append("IF NOT EXISTS");
        }
        writer.writeSpace(1);
        sqlNode.getTableName().unparse(writer, context);
        writer.newLine();
        writer.append("(");
        writer.newLine();
        for (int i = 0; i < sqlNode.getColumns().size(); ++i) {
            writer.indentation(1);
            writer.append(sqlNode.getColumns().get(i).getColumnName().getIdentifier());
            if (i == sqlNode.getColumns().size() - 1) continue;
            writer.append(",");
            writer.newLine();
        }
        writer.newLine().append(")");
    }

    private void checkSqlNode(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE");
        if (sqlNode.isTemporary()) {
            writer.writeSpace(1).append("TEMPORARY");
        }
        if (sqlNode.isDimension()) {
            writer.writeSpace(1).append("/* DIMENSION */");
        }
        writer.writeSpace(1).append("TABLE");
        if (sqlNode.isIfExists()) {
            writer.writeSpace(1).append("IF NOT EXISTS");
        }
        writer.writeSpace(1);
        if (sqlNode.isTemporary()) {
            sqlNode.getTableName().setTemporaryTable(true);
        }
        sqlNode.getTableName().unparse(writer, context);
        writer.newLine();
        writer.append("(");
        writer.newLine();
        for (int i = 0; i < sqlNode.getColumns().size(); ++i) {
            boolean isAdbAutoId;
            writer.indentation(1);
            SqlColumnDefinition sqlColumnDefinition = sqlNode.getColumns().get(i);
            boolean bl = isAdbAutoId = !sqlNode.isHaveAdbAutoId() && sqlColumnDefinition.getColumnName().getIdentifier().equalsIgnoreCase(ADB_AUTO_ID);
            if (isAdbAutoId) {
                sqlNode.setHaveAdbAutoId(true);
                writer.append("/* ");
            }
            this.UnparseRenameFieldName(sqlColumnDefinition.getColumnName());
            sqlNode.getColumns().get(i).unparse(writer, context);
            if (sqlNode.getConstraints() != null) {
                this.addColumnTypeToConstraint(sqlNode.getConstraints(), sqlColumnDefinition);
            }
            if (i != sqlNode.getColumns().size() - 1) {
                writer.append(",");
                if (isAdbAutoId) {
                    writer.append(" */");
                }
                writer.newLine();
                continue;
            }
            if (!isAdbAutoId) continue;
            writer.append(" */");
        }
    }

    private void addColumnTypeToConstraint(List<SqlTableConstraint> constraints, SqlColumnDefinition sqlColumnDefinition) {
        for (SqlTableConstraint sqlTableConstraint : constraints) {
            String type;
            if (sqlTableConstraint instanceof SqlUKeyTableConstraint) {
                SqlUKeyTableConstraint sqlUKeyTableConstraint = (SqlUKeyTableConstraint)sqlTableConstraint;
                List<SqlIndexColumnName> indexColumns = sqlUKeyTableConstraint.getIndexColumns();
                for (SqlIndexColumnName sqlIndexColumnName : indexColumns) {
                    if (!sqlIndexColumnName.getColumnName().getIdentifier().equals(sqlColumnDefinition.getColumnName().getIdentifier())) continue;
                    type = sqlColumnDefinition.getDataType().getTypeName().getName().toUpperCase(Locale.ROOT);
                    sqlIndexColumnName.setColumnType(new SqlIdentifier(type));
                }
            }
            if (!(sqlTableConstraint instanceof SqlPKeyTableConstraint)) continue;
            SqlPKeyTableConstraint sqlPKeyTableConstraint = (SqlPKeyTableConstraint)sqlTableConstraint;
            SqlNodeList<SqlIndexColumnName> sqlNodeList = sqlPKeyTableConstraint.getIndexColumns();
            for (SqlIndexColumnName sqlIndexColumnName : sqlNodeList.getNodes()) {
                if (!sqlIndexColumnName.getColumnName().getIdentifier().equals(sqlColumnDefinition.getColumnName().getIdentifier())) continue;
                type = sqlColumnDefinition.getDataType().getTypeName().getName().toUpperCase(Locale.ROOT);
                sqlIndexColumnName.setColumnType(new SqlIdentifier(type));
            }
        }
    }

    private void UnparseRenameFieldName(SqlIdentifier columnName) {
        switch (columnName.getIdentifier()) {
            case "xc_node_id": {
                columnName.setIdentifier("xc_node_id_new");
                break;
            }
            case "tableoid": {
                columnName.setIdentifier("tableoid_new");
                break;
            }
            case "cmax": {
                columnName.setIdentifier("cmax_new");
                break;
            }
            case "cmin": {
                columnName.setIdentifier("cmin_new");
                break;
            }
            case "xmax": {
                columnName.setIdentifier("xmax_new");
                break;
            }
            case "xmin": {
                columnName.setIdentifier("xmin_new");
                break;
            }
            case "ctid": {
                columnName.setIdentifier("ctid_new");
                break;
            }
            case "tid": {
                columnName.setIdentifier("tid_new");
                break;
            }
        }
    }

    private void unparseCompressedReplicatedTable(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig config, SqlNodeList<SqlDistributeOptions> distributeByList) throws ParserRuntimeException {
        String spaceStorageConfig = ConfigUtil.getConfigValue(config, "table.tablespace.storage", null);
        if (!spaceStorageConfig.isEmpty()) {
            String tablespaceModeConfig = ConfigUtil.getConfigValue(config, "table.tablespace", null);
            if (tablespaceModeConfig == null) {
                config.setStringValue("table.tablespace", "RESERVE");
                tablespaceModeConfig = ConfigUtil.getConfigValue(config, "table.tablespace", "RESERVE");
            }
            switch (tablespaceModeConfig) {
                case "RESERVE": {
                    writer.newLine().indentation(1).append("TABLESPACE").writeSpace(1).append(spaceStorageConfig);
                    break;
                }
                case "COMMENT": {
                    writer.newLine().indentation(1).append("/*TABLESPACE").writeSpace(1).append(spaceStorageConfig).append("*/");
                    break;
                }
                default: {
                    LOGGER.info("TABLE.TABLESPACE value is invalid. Hence set it as RESERVE by default.");
                    config.setStringValue("table.tablespace", "RESERVE");
                    writer.newLine().indentation(1).append("TABLESPACE").writeSpace(1).append(spaceStorageConfig);
                }
            }
        }
        if (sqlNode.isHaveAdbAutoId()) {
            writer.append("/* ");
        }
        writer.newLine().indentation(1).append("DISTRIBUTE").writeSpace(1).append("BY").writeSpace(1);
        if (distributeByList.getNodes().size() > 0) {
            SqlDistributeOptions sqlDistributeOptions = distributeByList.getNodes().get(0);
            if (sqlDistributeOptions.getKeyWord().equalsIgnoreCase("BROADCAST")) {
                writer.append("REPLICATION");
            } else {
                writer.append(sqlDistributeOptions.getKeyWord()).writeSpace(1);
                writer.append("(");
                for (int i = 0; i < sqlDistributeOptions.getUidList().size(); ++i) {
                    String distributeOptionUid = sqlDistributeOptions.getUidList().get(i);
                    if (distributeOptionUid.startsWith("`") && distributeOptionUid.endsWith("`")) {
                        writer.append(QuoteUtils.addDoubleQuote(QuoteUtils.removeQuote(distributeOptionUid)));
                    } else {
                        writer.append(distributeOptionUid);
                    }
                    if (i == sqlDistributeOptions.getUidList().size() - 1) continue;
                    writer.append(",").writeSpace(1);
                }
                writer.append(")").writeSpace(1);
            }
        } else if (ConfigUtil.getConfigValue(config, "table.type", null).equalsIgnoreCase("REPLICATION")) {
            writer.append("REPLICATION");
        } else if (ConfigUtil.getConfigValue(config, "table.type", null).equalsIgnoreCase("ROUND-ROBIN")) {
            writer.append("ROUNDROBIN");
        } else {
            this.partitionkeyUnparser(sqlNode, writer, context, config);
        }
        if (sqlNode.getPartitionDefinitions() != null) {
            sqlNode.getPartitionDefinitions().unparse(writer, context);
        }
        if (sqlNode.isHaveAdbAutoId()) {
            writer.append(" */");
        }
    }

    private void getSqlNode(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getIndexs() != null && !sqlNode.getIndexs().isEmpty()) {
            for (int m = 0; m < sqlNode.getIndexs().size(); ++m) {
                SqlCreateIndex sqlCreateIndex = sqlNode.getIndexs().get(m);
                if (this.isCommentIndex(sqlCreateIndex, writer)) continue;
                writer.newLine();
                sqlNode.getIndexs().get(m).unparse(writer, context);
            }
        }
    }

    private void getKeysTypeOptionsSqlNode(SqlNodeList<SqlKeysTypeOptions> sqlKeysTypeOptionsList, SqlWriter writer, UnParserContext context) {
        if (sqlKeysTypeOptionsList == null || sqlKeysTypeOptionsList.getNodes() == null) {
            return;
        }
        for (SqlKeysTypeOptions sqlKeysTypeOptions : sqlKeysTypeOptionsList.getNodes()) {
            writer.newLine();
            sqlKeysTypeOptions.unparse(writer, context);
        }
    }

    private boolean isCommentIndex(SqlCreateIndex sqlCreateIndex, SqlWriter writer) {
        String isMapComment;
        boolean isComment = false;
        boolean isGoal = false;
        SqlCreateIndex.SpecialType specialType = sqlCreateIndex.getSpecialType();
        if (specialType != null && specialType.equals((Object)SqlCreateIndex.SpecialType.FULLTEXT)) {
            isGoal = true;
        }
        if ((isMapComment = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_CREATE_COMMENT_CONSTRAINT.getValue())).equalsIgnoreCase("true")) {
            if (isGoal) {
                isComment = true;
            }
        } else {
            ConvertConfig commentConfig = writer.getConfig("table.create.comment.constraint");
            if (ConfigUtil.getConfigValue(commentConfig, "table.create.comment.constraint", "false").equalsIgnoreCase("true") && isGoal) {
                isComment = true;
            }
        }
        return isComment;
    }

    private SqlCreateTable checkPrimaryKeyAndUnique(SqlCreateTable sqlNode) {
        boolean primaryKeyExist = false;
        int multiUniqueNums = 0;
        List<SqlColumnDefinition> sqlColumnDefinitions = sqlNode.getColumns();
        for (int i = 0; i < sqlColumnDefinitions.size(); ++i) {
            if (sqlColumnDefinitions.get(i).isPrimaryKey()) {
                primaryKeyExist = true;
            }
            if (!sqlColumnDefinitions.get(i).isUniquekey()) continue;
            ++multiUniqueNums;
        }
        List<SqlTableConstraint> sqlUKeyTableConstraint = this.getSqlUKeyTableConstraint(sqlNode.getConstraints());
        ArrayList<SqlColumnDefinition> res = new ArrayList<SqlColumnDefinition>();
        if (primaryKeyExist || multiUniqueNums + sqlUKeyTableConstraint.size() > 1) {
            for (SqlColumnDefinition col : sqlNode.getColumns()) {
                if (!col.isUniquekey() && !col.isPrimaryKey()) continue;
                res.add(col);
                col.setUniquekey(false);
            }
        }
        SqlCreateTable sqlCreateTable = new SqlCreateTable();
        sqlCreateTable.setConstraints(sqlNode.getConstraints());
        if (!primaryKeyExist && multiUniqueNums == 0 && sqlUKeyTableConstraint.size() == 1) {
            sqlCreateTable.setConstraints(null);
        }
        if (!primaryKeyExist && multiUniqueNums + sqlUKeyTableConstraint.size() > 1) {
            sqlNode.setConstraints(null);
        }
        sqlCreateTable.setColumns(res);
        return sqlCreateTable;
    }

    private void createIndexOfRemoveUnique(SqlCreateTable sqlNode, SqlWriter writer, UnParserContext context, SqlCreateTable sqlCreateTable) {
        List<SqlColumnDefinition> definitions = sqlCreateTable.getColumns();
        SqlNodeList<SqlIdentifier> primaryColumnList = new SqlNodeList<SqlIdentifier>();
        for (int i = 0; i < definitions.size(); ++i) {
            String indexName = CreateIndexUtil.getIndexName(sqlNode, definitions.get(i), writer, context);
            SqlIdentifier columnName = definitions.get(i).getColumnName();
            if (definitions.get(i).isPrimaryKey()) {
                primaryColumnList.addNode(new SqlIdentifier(columnName.getIdentifier(), false));
                continue;
            }
            writer.newLine();
            writer.append("CREATE INDEX").writeSpace(1);
            writer.append(QuoteUtils.addDoubleQuote(indexName));
            writer.writeSpace(1).append("ON").writeSpace(1);
            sqlNode.getTableName().unparse(writer, context);
            writer.append("(");
            columnName.unparse(writer, context);
            writer.append(")");
            writer.sqlEnd();
        }
        List<SqlTableConstraint> constraints = sqlCreateTable.getConstraints();
        if (constraints != null && constraints.size() > 0) {
            for (int i = 0; i < constraints.size(); ++i) {
                if (!(constraints.get(i) instanceof SqlUKeyTableConstraint)) continue;
                String indexName = CreateIndexUtil.getIndexNameConstraint(sqlNode, (SqlUKeyTableConstraint)constraints.get(i), writer, context);
                SqlNodeList<SqlIdentifier> columnNameList = CreateIndexUtil.getUniqueColumnNameOfConstraint((SqlUKeyTableConstraint)constraints.get(i));
                if (this.comparePkAndUk(primaryColumnList, columnNameList)) continue;
                writer.newLine();
                writer.append("CREATE INDEX").writeSpace(1);
                writer.append(QuoteUtils.addDoubleQuote(indexName));
                writer.writeSpace(1).append("ON").writeSpace(1);
                sqlNode.getTableName().unparse(writer, context);
                writer.append("(");
                List<SqlIdentifier> columnNameListNodes = columnNameList.getNodes();
                for (int j = 0; j < columnNameListNodes.size(); ++j) {
                    columnNameListNodes.get(j).setIdentifier(QuoteUtils.removeAllQuoteForField(columnNameListNodes.get(j).getIdentifier()));
                    columnNameListNodes.get(j).unparse(writer, context);
                    if (j == columnNameListNodes.size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(")");
                writer.sqlEnd();
            }
        }
    }

    private boolean comparePkAndUk(SqlNodeList<SqlIdentifier> primaryColumnList, SqlNodeList<SqlIdentifier> columnNameList) {
        int sameColumnCnt = 0;
        List<SqlIdentifier> primaryColumnListNodes = primaryColumnList.getNodes();
        List<SqlIdentifier> columnNameListNodes = columnNameList.getNodes();
        if (primaryColumnListNodes.size() == columnNameListNodes.size()) {
            for (int i = 0; i < primaryColumnListNodes.size(); ++i) {
                for (int j = 0; j < columnNameListNodes.size(); ++j) {
                    if (!primaryColumnListNodes.get(i).getIdentifier().equalsIgnoreCase(columnNameListNodes.get(j).getIdentifier())) continue;
                    ++sameColumnCnt;
                }
            }
            if (sameColumnCnt == primaryColumnListNodes.size()) {
                return true;
            }
        }
        return false;
    }

    private List<SqlTableConstraint> getSqlUKeyTableConstraint(List<SqlTableConstraint> constraints) {
        ArrayList<SqlTableConstraint> sqlTableConstraints = new ArrayList<SqlTableConstraint>();
        for (int i = 0; i < constraints.size(); ++i) {
            if (!(constraints.get(i) instanceof SqlUKeyTableConstraint)) continue;
            sqlTableConstraints.add(constraints.get(i));
        }
        return sqlTableConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optionOrientation(ConvertConfig config, SqlNodeList<SqlTableOption> newList, SqlWriter writer, UnParserContext context, SqlCreateTable sqlCreateTable) {
        String tableCompressMode;
        String tableOptionColversion;
        SqlPartitionFunctionDefinition partitionFunctionDefinition;
        SqlTableOptionOrientation op = new SqlTableOptionOrientation();
        ConvertConfig bigqeuryConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery")) {
            this.bigQueryPartitionConvert(writer, context, sqlCreateTable, bigqeuryConfig);
            return;
        }
        SqlTableOptionCompress compress = new SqlTableOptionCompress();
        SqlTableOptionCompressLevel compressLevel = new SqlTableOptionCompressLevel();
        String orientationConfig = ConfigUtil.getConfigValue(config, "table.orientation", "ROW");
        if (orientationConfig.equalsIgnoreCase("ROW")) {
            this.parseTableOptionsRowStore(op, compress, config);
        } else {
            this.parseTableOptionsColumnStore(op, compress, config, compressLevel);
            if (compressLevel.getCompressLevel() != null) {
                newList.addNode(compressLevel);
            }
        }
        newList.addNode(op);
        if (compress.getCompress() != null) {
            newList.addNode(compress);
        }
        writer.newLine().indentation(1).append("WITH").writeSpace(1).append("(").writeSpace(1);
        context.setNodeListSeparator(", ");
        try {
            newList.unparse(writer, context);
        }
        finally {
            context.resetNodeListSeparator();
        }
        if (sqlCreateTable.getPartitionDefinitions() != null && (partitionFunctionDefinition = sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition()) != null && SqlPartitionFunctionDefinition.PartitionFunction.VALUE.equals((Object)partitionFunctionDefinition.getPartitionFunction())) {
            this.setDataTypeSpecName(sqlCreateTable);
            this.appendAutoPartition(partitionFunctionDefinition, writer);
        }
        if (sqlCreateTable.getSqlTableOptionStoragePolicy() != null) {
            if (STORAGE_POLICY_COLD.equals(sqlCreateTable.getSqlTableOptionStoragePolicy().getStringLiteral())) {
                writer.append(",STORAGE_POLICY = 'HPN:0'");
            } else if (STORAGE_POLICY_MIXED.equals(sqlCreateTable.getSqlTableOptionStoragePolicy().getStringLiteral())) {
                writer.append(",STORAGE_POLICY = 'HPN:").append(sqlCreateTable.getSqlTableOptionStoragePolicy().getCount()).append("'");
            }
        }
        if (orientationConfig.equalsIgnoreCase("COLUMN") && (tableOptionColversion = ConfigUtil.getConfigValue(config, "table.option.colversion", null)) != null && !tableOptionColversion.isEmpty()) {
            writer.append(", colversion = ").append(tableOptionColversion);
        }
        writer.writeSpace(1).append(")");
        if (orientationConfig.equalsIgnoreCase("ROW") && (tableCompressMode = ConfigUtil.getConfigValue(config, "table.compress.mode", null)) != null && !tableCompressMode.isEmpty()) {
            writer.newLine().indentation(1).append(tableCompressMode);
        }
    }

    private void setDataTypeSpecName(SqlCreateTable sqlCreateTable) {
        if (sqlCreateTable.getPartitionDefinitions() == null || sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition() == null) {
            return;
        }
        String partitionColumn = sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition().getFullColumnName().replace("`", "");
        for (int i = 0; i < sqlCreateTable.getColumns().size(); ++i) {
            SqlColumnDefinition sqlColumnDefinition = sqlCreateTable.getColumns().get(i);
            String columnName = sqlColumnDefinition.getColumnName().getIdentifier().replace("`", "");
            if (!columnName.equalsIgnoreCase(partitionColumn)) continue;
            sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition().setDataTypeSpecName(sqlColumnDefinition.getDataType().getTypeName());
            break;
        }
    }

    private void appendAutoPartition(SqlPartitionFunctionDefinition partition, SqlWriter writer) {
        String number = partition.getNumber();
        TableUtil.setAutoPartitionType(partition);
        String period = "";
        switch (partition.getValuePartitionFormat().toString()) {
            case "DATE": 
            case "INTEGER": {
                period = "day";
                break;
            }
            case "YEAR": {
                period = "year";
                break;
            }
            case "YEARMONTH": {
                period = "month";
                break;
            }
        }
        if (number != null && !number.isEmpty()) {
            writer.append(", TTL = '" + number + " " + period + "s'");
        }
        writer.append(", PERIOD = '1 " + period + "'");
        if (partition.getDataTypeSpecName() != null && partition.getDataTypeSpecName().getFamily() == SqlTypeFamily.NUMERIC) {
            writer.append(",TIME_FORMAT='YYYYMMDD'");
        } else if (partition.getDataTypeSpecName() != null && partition.getDataTypeSpecName().getFamily() == SqlTypeFamily.CHARACTER) {
            writer.append(",TIME_FORMAT='YYYY-MM-DD'");
        }
    }

    private void bigQueryPartitionConvert(SqlWriter writer, UnParserContext context, SqlCreateTable sqlCreateTable, ConvertConfig bigqeuryConfig) {
        writer.newLine().indentation(1).append("WITH").writeSpace(1).append("(").writeSpace(1);
        String orientation = ConfigUtil.getConfigValue(bigqeuryConfig, "table.orientation", "ROW");
        if (context.isExistArrayOrStruct()) {
            orientation = "ROW";
            context.setExistArrayOrStruct(false);
        }
        writer.append(" ORIENTATION").writeSpace(1).append("=").writeSpace(1).append(orientation);
        if (orientation.equalsIgnoreCase("COLUMN")) {
            writer.append(", colversion = ");
            String colVersion = bigqeuryConfig.getStringValue("table.option.colversion");
            if (colVersion != null && !colVersion.isEmpty()) {
                writer.append(colVersion).writeSpace(1);
            } else {
                writer.append("2.0 ");
            }
        }
        if (sqlCreateTable.getPartitionDefinitions() != null) {
            String optionInterval = null;
            if (sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition().getPartitionInterval() != null) {
                optionInterval = sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition().getPartitionInterval();
            }
            this.getTTLOption(sqlCreateTable.getPartitionDefinitions(), context, writer, optionInterval);
            if (sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition().getPartitionFunction().equals((Object)SqlPartitionFunctionDefinition.PartitionFunction.PERIOD)) {
                if (optionInterval != null) {
                    writer.append(", PERIOD = '1 ").append(optionInterval).append("'");
                } else if (sqlCreateTable.getPartitionDefinitions().getPartitionFunctionDefinition().getRangeBucket() == null) {
                    writer.append(", PERIOD = '1 day'");
                }
            }
            this.setDataTypeSpecName(sqlCreateTable);
        }
        writer.writeSpace(1).append(")");
    }

    private void getTTLOption(SqlPartitionDefinitions partitionDefinitions, UnParserContext context, SqlWriter writer, String optionInterval) {
        if (partitionDefinitions.getPartitionFunctionDefinition() != null && partitionDefinitions.getPartitionFunctionDefinition().getSqlPartitionOptions() != null) {
            SqlNodeList<SqlPartitionOptionParameter> partitionOptionParameterSqlNodeList = partitionDefinitions.getPartitionFunctionDefinition().getSqlPartitionOptions().getPartitionOptionParameterSqlNodeList();
            ConvertConfig config = writer.getConfig("param.config.flag");
            Calendar calendar = Calendar.getInstance();
            Date currentTime = new Date();
            if (ConfigUtil.getConfigValue(config, "date.test", "false").equalsIgnoreCase("true")) {
                calendar.set(1, Integer.parseInt(ConfigUtil.getConfigValue(config, "partition.year", "2024")));
                calendar.set(2, Integer.parseInt(ConfigUtil.getConfigValue(config, "partition.month", "7")) - 1);
                calendar.set(5, Integer.parseInt(ConfigUtil.getConfigValue(config, "partition.day", "15")));
            } else {
                calendar.setTime(currentTime);
            }
            for (int i = 0; i < partitionOptionParameterSqlNodeList.getNodes().size(); ++i) {
                if (!partitionOptionParameterSqlNodeList.getNodes().get(i).getParameterKey().equalsIgnoreCase("partition_expiration_days")) continue;
                String parameterValue = partitionOptionParameterSqlNodeList.getNodes().get(i).getParameterValue();
                BigDecimal parameterValueDecimal = new BigDecimal(parameterValue);
                String ttlRule = context.getConfigValue(writer, "table.option.partition.ttl", "HALF_UP");
                parameterValue = "CEILING".equalsIgnoreCase(ttlRule) ? parameterValueDecimal.setScale(0, RoundingMode.CEILING).toString() : ("FLOOR".equalsIgnoreCase(ttlRule) ? parameterValueDecimal.setScale(0, RoundingMode.FLOOR).toString() : parameterValueDecimal.setScale(0, RoundingMode.HALF_UP).toString());
                writer.append(", TTL = '").append(parameterValue).append(" day'");
                partitionDefinitions.getPartitionFunctionDefinition().getSqlPartitionOptions().setTtlValue(parameterValue);
                break;
            }
        }
    }
}

