/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTrigger;
import com.huawei.hwclouds.scs.sql.nodes.SqlDeclareVariable;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlCreateTrigger.class)
public class SqlCreateTriggerUnParser
implements UnParser<SqlCreateTrigger> {
    @Override
    public void unparse(SqlCreateTrigger sqlNode, SqlWriter writer, UnParserContext context) {
        List<SqlDeclareVariable> variables;
        writer.append("CREATE").writeSpace(1).append("FUNCTION").writeSpace(1);
        StringBuilder stringBuilder = new StringBuilder();
        String triggerName = stringBuilder.append("tri_").append(sqlNode.getTriggerTime().toLowerCase(Locale.ROOT)).append("_").append(sqlNode.getTriggerEvent().toLowerCase(Locale.ROOT)).append("_").append(sqlNode.getTableName().toLowerCase(Locale.ROOT)).append("_func()").toString();
        writer.append(triggerName).writeSpace(1).append("RETURNS").writeSpace(1).append("TRIGGER").writeSpace(1);
        writer.append("AS");
        writer.newLine();
        writer.append("$$");
        writer.newLine();
        writer.append("DECLARE").writeSpace(1);
        if (sqlNode.getSqlRoutineBody() != null && sqlNode.getSqlRoutineBody().getBlockStatement() != null && (variables = sqlNode.getSqlRoutineBody().getBlockStatement().getSqlDeclareVariables()) != null) {
            for (int i = 0; i < variables.size(); ++i) {
                for (int j = 0; j < variables.get(i).getUidList().size(); ++j) {
                    writer.append(variables.get(i).getUidList().get(j)).writeSpace(1);
                }
                if (variables.get(i).getDataType() != null) {
                    writer.append(variables.get(i).getDataType().getTypeName().getName());
                }
                if (variables.get(i).getExpression() != null) {
                    writer.writeSpace(1).append(":=").writeSpace(1);
                    variables.get(i).getExpression().unparse(writer, context);
                }
                writer.writeSpace(1).append(";");
            }
        }
        writer.newLine();
        writer.append("BEGIN");
        writer.newLine();
        if (sqlNode.getSqlRoutineBody() != null) {
            if (sqlNode.getSqlRoutineBody().getBlockStatement() != null) {
                sqlNode.getSqlRoutineBody().getBlockStatement().unparse(writer, context);
                writer.newLine();
            } else if (sqlNode.getSqlRoutineBody().getSqlStatement() != null) {
                sqlNode.getSqlRoutineBody().getSqlStatement().unparse(writer, context);
            }
        }
        writer.newLine();
        writer.append("RETURN").writeSpace(1);
        if (sqlNode.getTriggerEvent().equalsIgnoreCase("INSERT")) {
            writer.append("NEW");
        } else if (sqlNode.getTriggerEvent().equalsIgnoreCase("DELETE")) {
            writer.append("OLD");
        } else if (sqlNode.getTriggerEvent().equalsIgnoreCase("UPDATE")) {
            if (sqlNode.isNew()) {
                writer.append("NEW");
            } else {
                writer.append("OLD");
            }
        }
        writer.append(";");
        writer.newLine();
        writer.append("END");
        writer.newLine();
        writer.append("$$").writeSpace(1).append("LANGUAGE").writeSpace(1).append("PLPGSQL;");
        writer.append("CREATE").writeSpace(1).append("TRIGGER").writeSpace(1);
        if (sqlNode.getFullId() != null) {
            writer.append(sqlNode.getFullId());
        }
        writer.newLine();
        if (sqlNode.getTriggerTime() != null) {
            writer.writeSpace(1).append(sqlNode.getTriggerTime());
        }
        if (sqlNode.getTriggerEvent() != null) {
            writer.writeSpace(1).append(sqlNode.getTriggerEvent());
        }
        writer.writeSpace(1).append("ON");
        if (sqlNode.getTableName() != null) {
            writer.writeSpace(1).append(sqlNode.getTableName());
        }
        writer.writeSpace(1).append("FOR").writeSpace(1).append("EACH").writeSpace(1).append("ROW");
        writer.newLine();
        writer.append("EXECUTE").writeSpace(1).append("PROCEDURE").writeSpace(1).append(triggerName);
        writer.sqlEnd();
    }
}

