/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateView;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlCreateView.class)
public class SqlCreateViewUnParser
implements UnParser<SqlCreateView> {
    @Override
    public void unparse(SqlCreateView sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE").writeSpace(1);
        if (sqlNode.isHavingOr()) {
            writer.append("OR").writeSpace(1).append("REPLACE").writeSpace(1);
        }
        writer.append("VIEW").writeSpace(1);
        if (sqlNode.getFullId() != null) {
            ConvertConfig bigqeuryConfig = writer.getConfig("param.config.flag");
            if (ConfigUtil.getConfigValue(bigqeuryConfig, "table.origin.database.type", "mysql").equalsIgnoreCase("bigquery")) {
                String fullId = sqlNode.getFullId().substring(sqlNode.getFullId().indexOf(".") + 1, sqlNode.getFullId().length() - 1);
                sqlNode.setFullId(fullId);
            }
            writer.append(QuoteUtils.changeQuoteToDouble(sqlNode.getFullId())).writeSpace(1);
        }
        if (sqlNode.getUidList() != null) {
            writer.append("(");
            for (int i = 0; i < sqlNode.getUidList().size(); ++i) {
                writer.append(sqlNode.getUidList().get(i));
                if (i == sqlNode.getUidList().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(")").writeSpace(1);
        }
        writer.append("AS").writeSpace(1);
        if (sqlNode.getSelectStatement() != null) {
            sqlNode.getSelectStatement().unparse(writer, context);
        }
        writer.sqlEnd();
    }
}

