/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropDatabase;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlDropDatabase.class)
public class SqlDropDataBaseUnParser
implements UnParser<SqlDropDatabase> {
    private static final Logger LOGGER = LogManager.getLogger(SqlDropDataBaseUnParser.class);

    @Override
    public void unparse(SqlDropDatabase sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig defaultConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(defaultConfig, "table.databaseAsSchema", "true").equalsIgnoreCase("true")) {
            this.schemaUnparser(sqlNode, writer, context);
        } else {
            this.databaseUnparser(sqlNode, writer, context);
        }
    }

    public void schemaUnparser(SqlDropDatabase sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("DROP").writeSpace(1).append("SCHEMA").writeSpace(1).append("IF").writeSpace(1).append("EXISTS").writeSpace(1);
        sqlNode.getName().unparse(writer, context);
        writer.sqlEnd();
    }

    public void databaseUnparser(SqlDropDatabase sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("DROP").writeSpace(1).append("DATABASE").writeSpace(1).writeSpace(1).append("IF").writeSpace(1).append("EXISTS").writeSpace(1);
        sqlNode.getName().unparse(writer, context);
        writer.sqlEnd();
    }
}

