/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.CreateIndexUtil;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropIndex;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Collection;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlDropIndex.class)
public class SqlDropIndexUnParser
implements UnParser<SqlDropIndex> {
    @Override
    public void unparse(SqlDropIndex sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("DROP INDEX");
        SqlWriter sqlWriter = writer.cloneEmpty();
        sqlNode.getTableIndexs().keySet().forEach(i -> i.unparse(sqlWriter, context));
        String sql = sqlWriter.toSqlString().getSql();
        String[] attr = sql.split("\\.");
        String schemaName = attr[0];
        String tableName = QuoteUtils.removeDoubleQuote(attr[1]);
        if (this.changeIndexNameFlag(writer, "param.config.flag")) {
            writer.writeSpace(1).append("IF EXISTS");
        } else if (sqlNode.isExists()) {
            writer.writeSpace(1).append("IF EXISTS");
        }
        writer.writeSpace(1).append(schemaName).append(".");
        SqlWriter indexNameWriter = writer.cloneEmpty();
        sqlNode.getTableIndexs().values().stream().flatMap(Collection::stream).forEach(i -> i.unparse(indexNameWriter, context));
        String indexName = QuoteUtils.removeDoubleQuote(indexNameWriter.toSqlString().getSql());
        String result = this.changeIndexNameFlag(writer, "param.config.flag") ? QuoteUtils.removeDoubleQuote(CreateIndexUtil.appendIndexNameWithTableName(indexName, tableName)) : indexName;
        writer.writeSpace(1).append(QuoteUtils.addDoubleQuote(result));
        writer.writeSpace(1).append("RESTRICT");
        writer.sqlEnd();
    }

    private boolean changeIndexNameFlag(SqlWriter writer, String tableName) {
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        if (stringProperty.toUpperCase(Locale.ROOT).contains("INDEX_RENAME")) {
            return true;
        }
        ConvertConfig config = writer.getConfig(tableName);
        return ConfigUtil.getConfigValue(config, "table.index.rename", "false").equalsIgnoreCase("true");
    }

    private String appendIndexNameWithTableName(String indexName, String tableName) {
        String result = tableName + "_" + QuoteUtils.removeDoubleQuote(indexName);
        if (result.length() > 63) {
            result = result.substring(0, 63);
        }
        return result.toLowerCase(Locale.ROOT);
    }
}

