/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlDropTable;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlDropTable.class)
public class SqlDropTableUnParser
implements UnParser<SqlDropTable> {
    private static final Logger LOGGER = LogManager.getLogger(SqlDropTableUnParser.class);

    @Override
    public void unparse(SqlDropTable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("DROP").writeSpace(1).append("TABLE");
        if (sqlNode.isExists()) {
            writer.writeSpace(1).append("IF").writeSpace(1).append("EXISTS");
        }
        writer.writeSpace(1);
        for (int i = 0; i < sqlNode.getTables().size(); ++i) {
            sqlNode.getTables().get(i).unparse(writer, context);
            if (i == sqlNode.getTables().size() - 1) continue;
            writer.append(", ");
        }
        if (sqlNode.getDroptype() == SqlDropTable.DROPTYPE.CASCADE) {
            switch (writer.getDialect()) {
                case DWS: 
                case POSTGRESQL: {
                    writer.writeSpace(1).append("CASCADE");
                    break;
                }
                default: {
                    LOGGER.error("Cascading delete is only supported in DWS and PostgreSql");
                    throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Cascading delete is only supported in DWS and PostgreSql. Syntax : cascade of " + (Object)((Object)writer.getDialect()));
                }
            }
        }
        writer.sqlEnd();
    }
}

