/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.util.ColumnUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArg;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlFunctionArg.class)
public class SqlFunctionArgUnParser
implements UnParser<SqlFunctionArg> {
    @Override
    public void unparse(SqlFunctionArg sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getConstantUid() != null) {
            String literal = sqlNode.getConstantUid();
            if ((context.isJsonCase() && context.isJsonSetCase() || context.isJsonUnquoteCase()) && !(literal = this.convertJsonLiteral(literal, context)).equalsIgnoreCase("?")) {
                literal = QuoteUtils.addSingleQuote(QuoteUtils.removeAllQuote(literal));
            }
            if (literal.length() >= 3 && literal.startsWith("r") && literal.charAt(1) == '\'' && literal.charAt(literal.length() - 1) == '\'') {
                literal = literal.substring(1);
            }
            sqlNode.setConstantUid(literal);
            writer.append(sqlNode.getConstantUid()).writeSpace(1);
        } else if (sqlNode.getFullColumnName() != null) {
            String fullColumn = sqlNode.getFullColumnName();
            fullColumn = fullColumn.replace("`", "\"");
            fullColumn = ColumnUtil.getFullColumnName(fullColumn);
            writer.append(fullColumn).writeSpace(1);
        } else if (sqlNode.getSqlExpression() != null) {
            sqlNode.getSqlExpression().unparse(writer, context);
        } else if (sqlNode.getSqlFunctionCall() != null) {
            sqlNode.getSqlFunctionCall().unparse(writer, context);
        } else if (sqlNode.getComplex() != null) {
            writer.append(sqlNode.getComplex()).writeSpace(1);
        }
    }

    private String convertJsonLiteral(String literal, UnParserContext context) {
        if (literal.contains("$.")) {
            literal = literal.replace("$.", "");
            literal = QuoteUtils.removeAllQuote(literal);
            if (!context.isJsonUnquoteCase()) {
                literal = "{" + literal + "}";
            }
            literal = QuoteUtils.addSingleQuote(literal);
            return literal;
        }
        return literal;
    }
}

