/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.util.JsonFunctionUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlCastDataTypeFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlConvertDataTypeFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArg;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArgs;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlScalarFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlSpecificFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlUdfFunctionCall;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.ConvertRuntimeException;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlFunctionCall.class)
public class SqlFunctionCallUnParser
implements UnParser<SqlFunctionCall> {
    private static final Logger LOGGER = LogManager.getLogger(SqlFunctionCallUnParser.class);

    @Override
    public void unparse(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        this.functionConvert(sqlNode, writer);
        if (sqlNode.getSqlSpecificFunctionCall() != null) {
            sqlNode.getSqlSpecificFunctionCall().getSqlSpecificFunction().unparse(writer, context);
        } else if (sqlNode.getSqlAggregateFunctionCall() != null) {
            sqlNode.getSqlAggregateFunctionCall().unparse(writer, context);
        } else if (sqlNode.getSqlNonAggregateFunctionCall() != null) {
            sqlNode.getSqlNonAggregateFunctionCall().unparse(writer, context);
        } else if (sqlNode.getSqlScalarFunctionCall() != null) {
            this.getSqlScalarFunctionCallByArgs(sqlNode, writer, context);
        } else if (sqlNode.getSqlUdfFunctionCall() != null) {
            String functionName = sqlNode.getSqlUdfFunctionCall().getFullId();
            if (functionName.equalsIgnoreCase("get_json_object")) {
                String newFunction = JsonFunctionUtil.getNewFunction(sqlNode, writer, context);
                writer.append(newFunction);
                return;
            }
            writer.append(functionName);
            writer.append("(");
            if (sqlNode.getSqlUdfFunctionCall().getSqlFunctionArgs() != null) {
                List<SqlFunctionArg> sqlFunctionArgList = sqlNode.getSqlUdfFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
                for (int i = 0; i < sqlFunctionArgList.size(); ++i) {
                    sqlFunctionArgList.get(i).unparse(writer, context);
                    if (i == sqlFunctionArgList.size() - 1) continue;
                    writer.append(",").writeSpace(1);
                }
            }
            writer.append(")").writeSpace(1);
            if (sqlNode.getSqlUdfFunctionCall().getConstant() != null) {
                writer.append("[");
                writer.append(sqlNode.getSqlUdfFunctionCall().getConstant()).writeSpace(1);
                writer.append("]").writeSpace(1);
            }
        } else if (sqlNode.getSqlPasswordFunctionCall() != null) {
            LOGGER.error("PasswordFunctionCall is not supported in DSC");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "password(args)");
        }
    }

    private void getSqlScalarFunctionCallByArgs(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        String functionName = sqlNode.getSqlScalarFunctionCall().getScalarFunctionName();
        if (functionName.equalsIgnoreCase("json_extract")) {
            sqlNode.getSqlScalarFunctionCall().setScalarFunctionName("jsonb_extract");
            String newFunction = JsonFunctionUtil.getNewFunction(sqlNode, writer, context);
            writer.append(newFunction);
            return;
        }
        if (functionName.equalsIgnoreCase("json_set")) {
            this.dealWithJsonSet(sqlNode, writer, context);
            return;
        }
        if (functionName.equalsIgnoreCase("json_unquote")) {
            this.dealWithJsonUnquote(sqlNode, writer, context);
            return;
        }
        if (functionName.equalsIgnoreCase("concat")) {
            this.getConcatFunctionByArgs(sqlNode, writer, context);
            return;
        }
        if (functionName.equalsIgnoreCase("dateDiff")) {
            this.getDateDiffFunctionByArgs(sqlNode, writer, context);
            return;
        }
        if (functionName.equalsIgnoreCase("timestamp") || functionName.equalsIgnoreCase("time")) {
            this.getTimestampAndTimeFunctionByArgs(sqlNode, writer, context);
            return;
        }
        if (functionName.equalsIgnoreCase("log") && sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes().size() == 1) {
            writer.append("ln");
        } else if (functionName.equalsIgnoreCase("log2") || functionName.equalsIgnoreCase("log10")) {
            writer.append("log");
        } else if (functionName.equalsIgnoreCase("time_format")) {
            this.getFunctionNameByArgs(sqlNode, writer);
        } else if (functionName.equalsIgnoreCase("mid")) {
            writer.append("substr");
        } else if (functionName.equalsIgnoreCase("from_base64")) {
            writer.append("decode");
        } else if (functionName.equalsIgnoreCase("to_base64")) {
            writer.append("encode");
        } else if (functionName.equalsIgnoreCase("from_utf8")) {
            writer.append("convert_from");
        } else if (functionName.equalsIgnoreCase("to_utf8")) {
            writer.append("convert_to");
        } else {
            writer.append(functionName).writeSpace(1);
        }
        writer.append("(");
        if (sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs() != null) {
            List<SqlFunctionArg> sqlFunctionArgs = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
            if (functionName.equalsIgnoreCase("log2")) {
                writer.append("2, ");
            } else if (functionName.equalsIgnoreCase("log10")) {
                writer.append("10, ");
            }
            for (int i = 0; i < sqlFunctionArgs.size(); ++i) {
                sqlFunctionArgs.get(i).unparse(writer, context);
                if (i == sqlFunctionArgs.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            if (functionName.equalsIgnoreCase("IF") && sqlNode.getSqlScalarFunctionCall().getCommasNum() == 1) {
                writer.append(", NULL");
            }
            if (functionName.equalsIgnoreCase("from_base64") || functionName.equalsIgnoreCase("to_base64")) {
                writer.append(", 'BASE64'");
            }
            if (functionName.equalsIgnoreCase("from_utf8") || functionName.equalsIgnoreCase("to_utf8")) {
                writer.append(", 'UTF8'");
            }
        }
        writer.append(")").writeSpace(1);
    }

    private void dealWithJsonUnquote(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        sqlNode.getSqlScalarFunctionCall().setScalarFunctionName("jsonb_extract_path_text");
        List<SqlFunctionArg> nodes = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
        if (nodes.get(0).getSqlFunctionCall() != null && nodes.get(0).getSqlFunctionCall().getSqlScalarFunctionCall() != null && nodes.get(0).getSqlFunctionCall().getSqlScalarFunctionCall().getScalarFunctionName().equalsIgnoreCase("json_extract")) {
            SqlFunctionArgs sqlFunctionArgs = nodes.get(0).getSqlFunctionCall().getSqlScalarFunctionCall().getSqlFunctionArgs();
            sqlNode.getSqlScalarFunctionCall().setSqlFunctionArgs(sqlFunctionArgs);
            nodes = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
        }
        writer.append(sqlNode.getSqlScalarFunctionCall().getScalarFunctionName());
        writer.append("(").writeSpace(1);
        if (nodes.size() > 1) {
            context.setJsonUnquoteCase(true);
            for (int i = 0; i < nodes.size(); ++i) {
                nodes.get(i).unparse(writer, context);
                if (i != 0) continue;
                writer.append("::jsonb, ");
            }
            context.setJsonUnquoteCase(false);
        } else {
            context.setJsonUnquoteCase(true);
            nodes.get(0).unparse(writer, context);
            context.setJsonUnquoteCase(false);
        }
        writer.append(") ");
    }

    private void dealWithJsonSet(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        sqlNode.getSqlScalarFunctionCall().setScalarFunctionName("jsonb_set");
        writer.append(sqlNode.getSqlScalarFunctionCall().getScalarFunctionName()).writeSpace(1);
        SqlNodeList<SqlFunctionArg> sqlFunctionArgSqlNodeList = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList();
        writer.append("(");
        for (int i = 0; i < sqlFunctionArgSqlNodeList.getNodes().size(); ++i) {
            if (i == 0) {
                sqlFunctionArgSqlNodeList.getNodes().get(i).unparse(writer, context);
                writer.append("::jsonb");
            } else {
                context.setJsonCase(true);
                context.setJsonSetCase(true);
                sqlFunctionArgSqlNodeList.getNodes().get(i).unparse(writer, context);
                context.setJsonCase(false);
                context.setJsonSetCase(false);
            }
            if (i == sqlFunctionArgSqlNodeList.getNodes().size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
    }

    public void functionConvert(SqlFunctionCall node, SqlWriter writer) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        SqlScalarFunctionCall sqlScalarFunctionCall = node.getSqlScalarFunctionCall();
        if (sqlScalarFunctionCall != null) {
            String scalarFunctionName = sqlScalarFunctionCall.getScalarFunctionName();
            if (scalarFunctionName.equalsIgnoreCase("uuid")) {
                if (ConfigUtil.getConfigValue(config, "table.function.uuid", "false").equalsIgnoreCase("true")) {
                    sqlScalarFunctionCall.setScalarFunctionName("uuid");
                } else {
                    sqlScalarFunctionCall.setScalarFunctionName("sys_guid");
                }
            }
            if (scalarFunctionName.equalsIgnoreCase("curdate")) {
                sqlScalarFunctionCall.setScalarFunctionName("current_date");
            }
            if (scalarFunctionName.equalsIgnoreCase("rand")) {
                sqlScalarFunctionCall.setScalarFunctionName("random");
            }
            if (scalarFunctionName.equalsIgnoreCase("curtime")) {
                sqlScalarFunctionCall.setScalarFunctionName("current_time");
            }
            if (scalarFunctionName.equalsIgnoreCase("date_add") && sqlScalarFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes().get(1).getSqlExpression() != null) {
                sqlScalarFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes().get(1).getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom().getSqlIntervalExpressionAtom().setKeywords("date_add_interval");
            }
            if (scalarFunctionName.equalsIgnoreCase("date_sub") && sqlScalarFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes().get(1).getSqlExpression() != null) {
                sqlScalarFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes().get(1).getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom().getSqlIntervalExpressionAtom().setKeywords("date_sub_interval");
            }
        }
        this.castFunctionConvert(node, config);
        if (node.getSqlUdfFunctionCall() != null) {
            SqlNodeList<SqlFunctionArg> sqlFunctionArgSqlNodeList;
            SqlUdfFunctionCall sqlUdfFunctionCall;
            if (node.getSqlUdfFunctionCall().getFullId().equalsIgnoreCase("slice")) {
                node.getSqlUdfFunctionCall().setFullId("concat_ws");
                SqlFunctionArg initPosArg = null;
                List<SqlFunctionArg> sqlFunctionArgs = node.getSqlUdfFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
                try {
                    initPosArg = sqlFunctionArgs.get(1).deepClone();
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new ConvertRuntimeException(e.getMessage());
                }
                sqlFunctionArgs.get(0).getSqlFunctionCall().getSqlUdfFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().addNode(initPosArg);
                int initPos = Integer.parseInt(sqlFunctionArgs.get(1).getConstantUid());
                int numOfDigits = Integer.parseInt(sqlFunctionArgs.get(2).getConstantUid());
                int i = initPos + 1;
                int j = 1;
                while (i < numOfDigits + initPos) {
                    try {
                        SqlFunctionCall newNode = sqlFunctionArgs.get(0).getSqlFunctionCall().deepClone();
                        newNode.getSqlUdfFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes().get(2).setConstantUid(String.valueOf(i));
                        sqlFunctionArgs.get(j).setSqlFunctionCall(newNode);
                        sqlFunctionArgs.get(j).setConstantUid(null);
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new ConvertRuntimeException(e.getMessage());
                    }
                    ++i;
                    ++j;
                }
            }
            if ((sqlUdfFunctionCall = node.getSqlUdfFunctionCall()).getFullId().equalsIgnoreCase("split")) {
                if (!ConfigUtil.getConfigValue(config, "table.function.split", "true").equalsIgnoreCase("true")) {
                    sqlUdfFunctionCall.setFullId("split_part");
                    if (sqlUdfFunctionCall.getConstant() != null) {
                        SqlFunctionArg sqlFunctionArg = new SqlFunctionArg();
                        sqlFunctionArg.setConstantUid(sqlUdfFunctionCall.getConstant());
                        sqlUdfFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().addNode(sqlFunctionArg);
                        sqlUdfFunctionCall.setConstant(null);
                    }
                }
            } else if (sqlUdfFunctionCall.getFullId().equalsIgnoreCase("PARSE_DATE")) {
                sqlUdfFunctionCall.setFullId("TO_DATE");
                sqlFunctionArgSqlNodeList = sqlUdfFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList();
                SqlFunctionArg formatArg = sqlFunctionArgSqlNodeList.getNodes().get(0);
                SqlFunctionArg dateArg = sqlFunctionArgSqlNodeList.getNodes().get(1);
                sqlFunctionArgSqlNodeList = new SqlNodeList();
                sqlFunctionArgSqlNodeList.addNode(dateArg);
                formatArg.setConstantUid(formatArg.getConstantUid().replace("%Y", "YYYY").replace("%m", "MM").replace("%d", "DD"));
                sqlFunctionArgSqlNodeList.addNode(formatArg);
                sqlUdfFunctionCall.getSqlFunctionArgs().setSqlFunctionArgSqlNodeList(sqlFunctionArgSqlNodeList);
            } else if (sqlUdfFunctionCall.getFullId().equalsIgnoreCase("FORMAT_DATE")) {
                sqlUdfFunctionCall.setFullId("DATE_FORMAT");
                sqlFunctionArgSqlNodeList = sqlUdfFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList();
                SqlFunctionArg formatArg = sqlFunctionArgSqlNodeList.getNodes().get(0);
                SqlFunctionArg dateArg = sqlFunctionArgSqlNodeList.getNodes().get(1);
                sqlFunctionArgSqlNodeList = new SqlNodeList();
                sqlFunctionArgSqlNodeList.addNode(dateArg);
                formatArg.setConstantUid(formatArg.getConstantUid().replace("\"", "'"));
                sqlFunctionArgSqlNodeList.addNode(formatArg);
                sqlUdfFunctionCall.getSqlFunctionArgs().setSqlFunctionArgSqlNodeList(sqlFunctionArgSqlNodeList);
            } else if (sqlUdfFunctionCall.getFullId().equalsIgnoreCase("APPROX_QUANTILES")) {
                sqlUdfFunctionCall.setFullId("PERCENTILE_CONT");
                sqlFunctionArgSqlNodeList = sqlUdfFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList();
                SqlFunctionArg splitCountArg = sqlFunctionArgSqlNodeList.getNodes().get(1);
                BigDecimal splitCount = new BigDecimal(splitCountArg.getConstantUid());
                BigDecimal offset = new BigDecimal(sqlUdfFunctionCall.getConstant());
                BigDecimal percentileCont = offset.divide(splitCount, 2, RoundingMode.HALF_UP);
                splitCountArg.setConstantUid(percentileCont.toPlainString());
                sqlUdfFunctionCall.setConstant(null);
            } else if (sqlUdfFunctionCall.getFullId().equalsIgnoreCase("REGEXP_CONTAINS")) {
                sqlUdfFunctionCall.setFullId("REGEXP_LIKE");
            } else if (sqlUdfFunctionCall.getFullId().equalsIgnoreCase("TO_HEX")) {
                sqlUdfFunctionCall.setFullId("HEX");
            }
        }
    }

    private void castFunctionConvert(SqlFunctionCall node, ConvertConfig config) {
        SqlConvertDataTypeFunctionCall sqlConvertDataTypeFunctionCall;
        SqlSpecificFunctionCall sqlSpecificFunctionCall = node.getSqlSpecificFunctionCall();
        if (sqlSpecificFunctionCall != null && sqlSpecificFunctionCall.getSqlSpecificFunction().getSqlConvertDataTypeFunctionCall() != null && (sqlConvertDataTypeFunctionCall = sqlSpecificFunctionCall.getSqlSpecificFunction().getSqlConvertDataTypeFunctionCall()).getFunctionName().equalsIgnoreCase("convert")) {
            sqlConvertDataTypeFunctionCall.setFunctionName("cast");
            sqlConvertDataTypeFunctionCall.setKeyWords("AS");
        }
        if (sqlSpecificFunctionCall != null && sqlSpecificFunctionCall.getSqlSpecificFunction().getSqlCastDataTypeFunctionCall() != null) {
            SqlCastDataTypeFunctionCall sqlCastDataTypeFunctionCall = sqlSpecificFunctionCall.getSqlSpecificFunction().getSqlCastDataTypeFunctionCall();
            if (sqlCastDataTypeFunctionCall.getFunctionName().equalsIgnoreCase("try_cast")) {
                if (ConfigUtil.getConfigValue(config, "table.function.tryCast", "false").equalsIgnoreCase("true")) {
                    sqlCastDataTypeFunctionCall.setFunctionName("try_cast");
                } else {
                    sqlCastDataTypeFunctionCall.setFunctionName("cast");
                }
            }
            if (sqlCastDataTypeFunctionCall.getFunctionName().equalsIgnoreCase("cast")) {
                String convertTypeName = sqlCastDataTypeFunctionCall.getConvertedDataType();
                switch (convertTypeName.toLowerCase(Locale.ROOT)) {
                    case "double": {
                        sqlCastDataTypeFunctionCall.setConvertedDataType("double precision");
                        break;
                    }
                    case "string": {
                        sqlCastDataTypeFunctionCall.setConvertedDataType("varchar");
                        break;
                    }
                    case "datetime": {
                        sqlCastDataTypeFunctionCall.setConvertedDataType("timestamp");
                        break;
                    }
                }
            }
        }
    }

    private void getFunctionNameByArgs(SqlFunctionCall sqlNode, SqlWriter writer) {
        int i = 0;
        List<SqlFunctionArg> sqlFunctionArgs = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
        if (i < sqlFunctionArgs.size()) {
            if (sqlFunctionArgs.get(i).isConvertDateFormat()) {
                writer.append("date_format");
            } else {
                writer.append("time_format");
            }
            return;
        }
    }

    private void getConcatFunctionByArgs(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("concat(");
        List<SqlFunctionArg> sqlFunctionArgs = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
        for (int i = 0; i < sqlFunctionArgs.size(); ++i) {
            String constantUid = sqlFunctionArgs.get(i).getConstantUid();
            if (constantUid != null && constantUid.startsWith("\"") && constantUid.endsWith("\"")) {
                constantUid = QuoteUtils.addSingleQuote(QuoteUtils.removeDoubleQuote(constantUid));
            }
            sqlFunctionArgs.get(i).setConstantUid(constantUid);
            sqlFunctionArgs.get(i).unparse(writer, context);
            if (i == sqlFunctionArgs.size() - 1) continue;
            writer.append(",").writeSpace(1);
        }
        writer.append(")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getDateDiffFunctionByArgs(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("dateDiff(");
        List<SqlFunctionArg> sqlFunctionArgs = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
        if (sqlFunctionArgs.size() == 3) {
            if (!QuoteUtils.removeSingleQuote(sqlFunctionArgs.get(0).getConstantUid()).equalsIgnoreCase("day")) throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Other time or date type");
            sqlFunctionArgs.get(2).unparse(writer, context);
            writer.append(",").writeSpace(1);
            sqlFunctionArgs.get(1).unparse(writer, context);
        } else {
            for (int i = 0; i < sqlFunctionArgs.size(); ++i) {
                sqlFunctionArgs.get(i).unparse(writer, context);
                if (i == sqlFunctionArgs.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
        }
        writer.append(")");
    }

    private void getTimestampAndTimeFunctionByArgs(SqlFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        List<SqlFunctionArg> sqlFunctionArgs = sqlNode.getSqlScalarFunctionCall().getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
        for (int i = 0; i < sqlFunctionArgs.size(); ++i) {
            sqlFunctionArgs.get(i).unparse(writer, context);
            if (i == sqlFunctionArgs.size() - 1) continue;
            writer.append(",").writeSpace(1);
        }
        writer.append("::").append(sqlNode.getSqlScalarFunctionCall().getScalarFunctionName());
    }
}

