/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlLiteral.class)
public class SqlLiteralUnParser
implements UnParser<SqlLiteral> {
    @Override
    public void unparse(SqlLiteral sqlNode, SqlWriter writer, UnParserContext context) {
        switch (sqlNode.getType()) {
            case BOOLEAN: {
                writer.append(sqlNode.getValue().toString());
                return;
            }
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case INT: 
            case TEXT: 
            case ANY: {
                String dateTime = sqlNode.getValue().toString();
                if (dateTime.equalsIgnoreCase("'CURRENT_TIMESTAMP'") || dateTime.equalsIgnoreCase("'CURRENT_DATE'")) {
                    writer.append(SqlLiteralUnParser.createNumeric(QuoteUtils.removeAllQuoteForField(dateTime)));
                } else {
                    writer.append(SqlLiteralUnParser.createNumeric(dateTime));
                }
                return;
            }
            case VARCHAR: 
            case CHAR: {
                writer.append(QuoteUtils.addSingleQuote(QuoteUtils.removeAllQuoteForField(sqlNode.getValue().toString())));
                return;
            }
        }
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "date type " + sqlNode.getType().getName());
    }

    public static String createNumeric(String str) {
        return str;
    }

    public static String createText(String str) {
        return str;
    }
}

