/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlLockTableElement;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlLockTableElement.class)
public class SqlLockTableElementUnParser
implements UnParser<SqlLockTableElement> {
    private static final Logger LOGGER = LogManager.getLogger(SqlLockTableElementUnParser.class);

    @Override
    public void unparse(SqlLockTableElement lockTableElement, SqlWriter writer, UnParserContext context) {
        if (lockTableElement.getTableName() != null) {
            lockTableElement.getTableName().unparse(writer, context);
        }
        writer.writeSpace(1).append("IN").writeSpace(1);
        switch (lockTableElement.getLockActions()) {
            case READ: 
            case MYSQL_READ_LOCAL: {
                if (!lockTableElement.getLockActions().equals((Object)SqlLockTableElement.LockActions.READ)) break;
                writer.append("ACCESS").writeSpace(1).append("SHARE");
                break;
            }
            case WRITE: 
            case MYSQL_LOW_PRIORITY_WRITE: {
                if (!lockTableElement.getLockActions().equals((Object)SqlLockTableElement.LockActions.WRITE)) break;
                writer.append("ACCESS").writeSpace(1).append("EXCLUSIVE");
                break;
            }
            default: {
                LOGGER.error("Other lock actions are not supported in DSC");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "the lock actions " + (Object)((Object)lockTableElement.getLockActions()));
            }
        }
        writer.writeSpace(1).append("MODE");
    }
}

