/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.google.common.collect.Lists;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.util.TableUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.RangeBucket;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionFunctionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeFamily;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlPartitionFunctionDefinition.class)
public class SqlPartitionFunctionDefinitionUnParser
implements UnParser<SqlPartitionFunctionDefinition> {
    private static final List<SqlTypeFamily> PARTITION_VALUE_SUPPORT_TYPE = Lists.newArrayList((Object[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER, SqlTypeFamily.DATE, SqlTypeFamily.TIMESTAMP});

    @Override
    public void unparse(SqlPartitionFunctionDefinition partitionFunction, SqlWriter writer, UnParserContext context) {
        if (partitionFunction.getPartitionFunction() != null) {
            switch (partitionFunction.getPartitionFunction()) {
                case HASH: {
                    if (partitionFunction.isLinear()) {
                        writer.append("LINEAR").writeSpace(1);
                    }
                    writer.append("HASH (").append(partitionFunction.getExpression()).append(")");
                    break;
                }
                case KEY: {
                    if (partitionFunction.isLinear()) {
                        writer.append("LINEAR").writeSpace(1);
                    }
                    writer.append("KEY").writeSpace(1);
                    if (partitionFunction.getAlgorithm() != null) {
                        writer.append("ALGORITHM = ").append(partitionFunction.getAlgorithm()).writeSpace(1);
                    }
                    writer.append("(");
                    List<SqlIdentifier> columnNames = partitionFunction.getColumnName().getNodes();
                    for (int i = 0; i < columnNames.size(); ++i) {
                        writer.append(columnNames.get(i).getIdentifier());
                        if (i == columnNames.size() - 1) continue;
                        writer.append(", ");
                    }
                    writer.append(")");
                    break;
                }
                case LIST: {
                    writer.append("LIST").writeSpace(1).append("(");
                    this.getExpressionOrColumn(partitionFunction, writer, context);
                    writer.append(")");
                    break;
                }
                case RANGE: {
                    writer.append("RANGE").writeSpace(1).append("(");
                    this.getExpressionOrColumn(partitionFunction, writer, context);
                    writer.append(")");
                    break;
                }
                case VALUE: {
                    if (!PARTITION_VALUE_SUPPORT_TYPE.contains((Object)partitionFunction.getDataTypeSpecName().getFamily())) {
                        throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "partition by value only supports numeric/character/date/timestamp type");
                    }
                    writer.append("RANGE (").append(partitionFunction.getFullColumnName().replace("`", "\"")).append(")");
                    break;
                }
                case HASH_KEY: {
                    writer.append("HASH KEY(").append(partitionFunction.getFullColumnName()).append(")");
                    break;
                }
                case PERIOD: {
                    writer.append("RANGE(");
                    SqlIdentifier sqlIdentifier = new SqlIdentifier(partitionFunction.getFullColumnName());
                    sqlIdentifier.unparse(writer, context);
                    writer.append(") ");
                    if (partitionFunction.getSqlPartitionOptions() == null || partitionFunction.getPartitionFunctionName() == null || !partitionFunction.getPartitionFunctionName().equalsIgnoreCase("RANGE_BUCKET")) break;
                    this.appendRangeBucket(partitionFunction, writer, context);
                    break;
                }
            }
        }
    }

    private void convertAutoPartition(SqlPartitionFunctionDefinition partitionFunction, SqlWriter writer) {
        TableUtil.setAutoPartitionType(partitionFunction);
        int autoPartitionCnt = Integer.parseInt(partitionFunction.getNumber());
        String startTime = this.getPartitionValue(autoPartitionCnt, partitionFunction.getValuePartitionFormat().toString(), writer);
        String endTime = this.getPartitionValue(0, partitionFunction.getValuePartitionFormat().toString(), writer);
        writer.append("PARTITION P1 START ");
        writer.append("('" + startTime + "')").append(" END ").append("('" + endTime + "') ");
        this.intervalPartition(writer, partitionFunction.getValuePartitionFormat().toString());
    }

    private void intervalPartition(SqlWriter writer, String timeFormat) {
        writer.append("EVERY (INTERVAL '1 ");
        switch (timeFormat) {
            case "DATE": 
            case "TIMESTAMP": 
            case "INTEGER": {
                writer.append("day')");
                break;
            }
            case "YEAR": {
                writer.append("year')");
                break;
            }
            case "YEARMONTH": {
                writer.append("month')");
                break;
            }
        }
    }

    private String getPartitionValue(int autoPartitionCnt, String timeFormat, SqlWriter writer) {
        Date currentTime = new Date();
        Calendar calendar = Calendar.getInstance();
        String timeStamp = null;
        ConvertConfig config = writer.getConfig("param.config.flag");
        if ("true".equalsIgnoreCase(ConfigUtil.getConfigValue(config, "date.test", "false"))) {
            calendar.set(1, Integer.parseInt(ConfigUtil.getConfigValue(config, "partition.year", "2024")));
            calendar.set(2, Integer.parseInt(ConfigUtil.getConfigValue(config, "partition.month", "10")) - 1);
            calendar.set(5, Integer.parseInt(ConfigUtil.getConfigValue(config, "partition.day", "28")));
        } else {
            calendar.setTime(currentTime);
        }
        switch (timeFormat) {
            case "DATE": {
                SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
                calendar.add(5, autoPartitionCnt * -1);
                timeStamp = date.format(calendar.getTime());
                break;
            }
            case "TIMESTAMP": {
                SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                calendar.add(5, autoPartitionCnt * -1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                timeStamp = date.format(calendar.getTime());
                break;
            }
            case "YEAR": {
                SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
                calendar.set(5, 1);
                calendar.set(2, 1);
                calendar.add(1, autoPartitionCnt * -1);
                timeStamp = date.format(calendar.getTime());
                break;
            }
            case "YEARMONTH": {
                SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
                calendar.set(5, 1);
                calendar.add(2, autoPartitionCnt * -1);
                timeStamp = date.format(calendar.getTime());
                break;
            }
            case "INTEGER": {
                SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd");
                calendar.set(5, 1);
                calendar.add(2, autoPartitionCnt * -1);
                timeStamp = date.format(calendar.getTime());
                break;
            }
        }
        return timeStamp;
    }

    private void appendRangeBucket(SqlPartitionFunctionDefinition partitionFunction, SqlWriter writer, UnParserContext context) {
        RangeBucket rangeBucket = partitionFunction.getRangeBucket();
        writer.append("(");
        writer.append("PARTITION P1 START(").append(rangeBucket.getStartVal()).append(") END (").append(rangeBucket.getEndVal()).append(") ").append("EVERY (").append(rangeBucket.getIntervalVal()).append(")");
        writer.append(")");
        writer.sqlEnd();
        writer.append("ALTER TABLE ");
        context.getCurrentTableName().unparse(writer, context);
        writer.append("ADD PARTITION pmax VALUES LESS THAN (maxvalue)");
    }

    private void getExpressionOrColumn(SqlPartitionFunctionDefinition partitionFunction, SqlWriter writer, UnParserContext context) {
        if (partitionFunction.getColumnName() != null) {
            context.setNodeListSeparator(", ");
            partitionFunction.getColumnName().unparse(writer, context);
        }
        if (partitionFunction.getExpression() != null) {
            String expression = partitionFunction.getExpression().replace("`", "\"");
            writer.append(expression);
        }
    }
}

