/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlDistributeOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlQueryCreateTable;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlQueryCreateTable.class)
public class SqlQueryCreateTableUnParser
implements UnParser<SqlQueryCreateTable> {
    @Override
    public void unparse(SqlQueryCreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE").writeSpace(1).append("TABLE").writeSpace(1);
        sqlNode.getTableName().unparse(writer, context);
        if (sqlNode.isConverting()) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Create table tbl_name() [as] select");
        }
        SqlDistributeOptions sqlDistributeOptions = sqlNode.getSqlDistributeOptions();
        if (sqlDistributeOptions != null) {
            writer.newLine().indentation(1).append("DISTRIBUTE").writeSpace(1).append("BY").writeSpace(1);
            if (sqlDistributeOptions.getKeyWord().equalsIgnoreCase("BROADCAST")) {
                writer.append("REPLICATION");
            } else {
                writer.append(sqlDistributeOptions.getKeyWord()).writeSpace(1);
                writer.append("(");
                List<String> uidList = sqlDistributeOptions.getUidList();
                if (uidList != null) {
                    for (int i = 0; i < uidList.size(); ++i) {
                        writer.append(uidList.get(i));
                        if (i == uidList.size() - 1) continue;
                        writer.append(",").writeSpace(1);
                    }
                }
                writer.append(")").writeSpace(1);
            }
        }
        if (sqlNode.getSqlTableOptionComment() != null) {
            writer.append("COMMENT").writeSpace(1).append(sqlNode.getSqlTableOptionComment().getStringLiteral());
        }
        writer.append("AS").writeSpace(1);
        if (sqlNode.getSqlSelectStatement() != null) {
            sqlNode.getSqlSelectStatement().unparse(writer, context);
        }
        writer.sqlEnd();
    }
}

