/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.dws.util.ColumnUtil;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectElement;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.util.UidInKeyWord;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSelectElement.class)
public class SqlSelectElementUnParser
implements UnParser<SqlSelectElement> {
    @Override
    public void unparse(SqlSelectElement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getFullId() != null) {
            writer.append(sqlNode.getFullId()).append(".*");
        }
        if (sqlNode.isIfHaveStar()) {
            writer.append("*");
        }
        if (sqlNode.getSqlSelectElementExcept() != null) {
            writer.append("/* ").append(sqlNode.getSqlSelectElementExcept()).append(" */");
        }
        if (sqlNode.getSqlSelectColumnElement() != null) {
            String fullColumn;
            String beforefullColumn = fullColumn = sqlNode.getSqlSelectColumnElement().getFullColumnName();
            fullColumn = fullColumn.replace("\\'", "''").replace("`", "\"");
            if (QuoteUtils.fieldWithDoubleQuote(fullColumn = ColumnUtil.getFullColumnName(fullColumn)) && beforefullColumn.equals(fullColumn)) {
                writer.append(QuoteUtils.handleDoubleQuotedString(fullColumn)).writeSpace(1);
            } else {
                String processedColumn = UidInKeyWord.getUid(fullColumn);
                writer.append(processedColumn).writeSpace(1);
            }
            if (sqlNode.getSqlSelectColumnElement().isIfHaveAs()) {
                writer.append("AS").writeSpace(1);
                writer.append(QuoteUtils.changeQuoteToDouble(sqlNode.getSqlSelectColumnElement().getUid())).writeSpace(1);
            } else if (sqlNode.getSqlSelectColumnElement().getUid() != null) {
                writer.append(QuoteUtils.changeQuoteToDouble(sqlNode.getSqlSelectColumnElement().getUid())).writeSpace(1);
            }
        }
        if (sqlNode.getSqlSelectExpressionElement() != null) {
            sqlNode.getSqlSelectExpressionElement().unparse(writer, context);
        }
        if (sqlNode.getSqlSelectFunctionElement() != null) {
            sqlNode.getSqlSelectFunctionElement().unparse(writer, context);
        }
        if (sqlNode.getSqlTableElement() != null) {
            writer.append("(");
            sqlNode.getSqlTableElement().unparse(writer, context);
            writer.append(")").writeSpace(1);
        }
    }
}

