/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetCharacter;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetCharacter.class)
public class SqlSetCharacterUnParser
implements UnParser<SqlSetCharacter> {
    private static final Logger LOGGER = LogManager.getLogger(SqlSetCharacter.class);
    private static Map<SqlSetCharacter.CharsetNameBase, String> mysqlCharsetMap = new HashMap<SqlSetCharacter.CharsetNameBase, String>();

    public SqlSetCharacterUnParser() {
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.BINARY, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.DEFAULT, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.ARMSCII8, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.ASCII, "SQL_ASCII");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.BIG5, "BIG5");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.MYSQL_BINARY, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP1250, "WIN1250");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP1251, "WIN1251");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP1256, "WIN1256");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP1257, "WIN1257");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP850, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP852, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP866, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.CP932, "SJIS");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.DEC8, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.EUCJPMS, "EUC_JP");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.EUCKR, "EUC_KR");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.GB2312, "GB18030");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.GBK, "GBK");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.GEOSTD8, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.GREEK, "ISO_8859_7");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.HEBREW, "ISO_8859_8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.HP8, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.KEYBCS2, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.KOI8R, "KOI8R");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.KOI8U, "KOI8U");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.LATIN1, "LATIN1");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.LATIN2, "LATIN2");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.LATIN5, "LATIN5");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.LATIN7, "LATIN7");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.MACCE, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.MACROMAN, null);
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.SJIS, "SJIS");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.SWE7, "UTF8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.TIS620, "WIN874");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UCS2, "UTF8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UJIS, "EUC_JIS_2004");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UTF16, "UTF8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UTF16LE, "UTF8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UTF32, "UTF8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UTF8, "UTF8");
        mysqlCharsetMap.put(SqlSetCharacter.CharsetNameBase.UTF8MB4, "UTF8");
    }

    @Override
    public void unparse(SqlSetCharacter sqlSetCharacter, SqlWriter writer, UnParserContext context) {
        LOGGER.info("SqlSetCharacter unparse enter ");
        writer.append("SET");
        writer.writeSpace(1);
        writer.append("SESSION");
        writer.writeSpace(1);
        writer.append("NAMES");
        writer.writeSpace(1).append("'");
        if (!mysqlCharsetMap.containsKey((Object)sqlSetCharacter.getCharsetNameBase()) || mysqlCharsetMap.get((Object)sqlSetCharacter.getCharsetNameBase()) == null) {
            LOGGER.error("Other charset options are not supported in DSC");
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "the charset " + (Object)((Object)sqlSetCharacter.getCharsetNameBase()));
        }
        writer.append(mysqlCharsetMap.get((Object)sqlSetCharacter.getCharsetNameBase()));
        writer.append("'").append(";");
    }
}

