/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetNames;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetNames.class)
public class SqlSetNamesUnParser
implements UnParser<SqlSetNames> {
    @Override
    public void unparse(SqlSetNames sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (!ConfigUtil.getConfigValue(config, "table.sql.set.names", "true").equalsIgnoreCase("false")) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Set names is not supported in DSC with config.Check the config");
        }
        this.setNamesChange(sqlNode, writer);
    }

    private void setNamesChange(SqlSetNames sqlNode, SqlWriter writer) {
        writer.append("SET").writeSpace(1).append("NAMES").writeSpace(1);
        if (sqlNode.getCharsetName() != null) {
            writer.append(sqlNode.getCharsetName()).writeSpace(1);
        }
        if (sqlNode.getCollationName() != null) {
            writer.append("COLLATE").writeSpace(1).append(sqlNode.getCollationName());
        }
        if (sqlNode.getIsHavingDefault() != null) {
            writer.append(sqlNode.getIsHavingDefault());
        }
        writer.sqlEnd();
    }
}

