/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetRole;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSetRole.class)
public class SqlSetRoleUnParser
implements UnParser<SqlSetRole> {
    private static final Logger LOGGER = LogManager.getLogger(SqlSetRoleUnParser.class);

    @Override
    public void unparse(SqlSetRole sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (!ConfigUtil.getConfigValue(config, "table.sql.set.role", "true").equalsIgnoreCase("false")) {
            LOGGER.error("Not supported set role statement");
            throw new ParserRuntimeException(ParserExceptionDef.DWS_NOT_SUPPORT, "Set role statement", "set role statement");
        }
        this.setRoleChange(sqlNode, writer);
    }

    private void setRoleChange(SqlSetRole sqlNode, SqlWriter writer) {
        int i;
        List<String> roleNames;
        writer.append("SET").writeSpace(1);
        if (sqlNode.getRoleOption() != null) {
            writer.append("ROLE").writeSpace(1);
            if (sqlNode.getRoleOption().getHavingDefault() != null) {
                writer.append("DEFAULT");
            }
            if (sqlNode.getRoleOption().getNone() != null) {
                writer.append("NONE");
            }
            if (sqlNode.getRoleOption().getAll() != null && sqlNode.getRoleOption().getExcept() == null) {
                writer.append("ALL");
            }
            if (sqlNode.getRoleOption().getRoleNames() != null) {
                if (sqlNode.getRoleOption().getExcept() != null) {
                    writer.append("ALL").writeSpace(1).append("EXCEPT").writeSpace(1);
                }
                roleNames = sqlNode.getRoleOption().getRoleNames();
                for (i = 0; i < roleNames.size(); ++i) {
                    writer.append(roleNames.get(i));
                    if (i == roleNames.size() - 1) continue;
                    writer.append(",").writeSpace(1);
                }
            }
        }
        if (sqlNode.getDefaultRole() != null) {
            writer.append("DEFAULT").writeSpace(1).append("ROLE").writeSpace(1);
            if (sqlNode.getDefaultRole().getNone() != null) {
                writer.append("NONE");
            }
            if (sqlNode.getDefaultRole().getAll() != null) {
                writer.append("ALL");
            }
            roleNames = sqlNode.getDefaultRole().getRoleNames();
            for (i = 0; i < roleNames.size(); ++i) {
                writer.append(roleNames.get(i));
                if (i == roleNames.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
            writer.writeSpace(1).append("TO").writeSpace(1);
            List<String> userNames = sqlNode.getDefaultRole().getUserNames();
            for (int i2 = 0; i2 < userNames.size(); ++i2) {
                writer.append(userNames.get(i2));
                if (i2 == userNames.size() - 1) continue;
                writer.append(",").writeSpace(1);
            }
        }
        writer.sqlEnd();
    }
}

