/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlCaseFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlCastDataTypeFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlCharFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlConstantExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlConvertDataTypeFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArg;
import com.huawei.hwclouds.scs.sql.nodes.SqlSpecificFunction;
import com.huawei.hwclouds.scs.sql.nodes.SqlSubstrFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlTrimFunctionCall;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlSpecificFunction.class)
public class SqlSpecificFunctionUnParser
implements UnParser<SqlSpecificFunction> {
    @Override
    public void unparse(SqlSpecificFunction sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSimpleFunction() != null) {
            writer.append(sqlNode.getSimpleFunction()).writeSpace(1);
            if (sqlNode.isIfHaveBrackets()) {
                writer.append("()").writeSpace(1);
            }
        } else if (sqlNode.getSqlLeftAndRightFunctionCall() != null) {
            writer.append(sqlNode.getSqlLeftAndRightFunctionCall().getLeftOrRight()).append("(");
            writer.append(sqlNode.getSqlLeftAndRightFunctionCall().getLeftOrRightStr()).append(", ").append(sqlNode.getSqlLeftAndRightFunctionCall().getLeftOrRightLength()).append(")");
        } else if (sqlNode.getSqlPositionFunctionCall() != null) {
            writer.append("position(").append(sqlNode.getSqlPositionFunctionCall().getPositionString());
            writer.append(" in ").append(sqlNode.getSqlPositionFunctionCall().getInString()).append(")");
        } else if (sqlNode.getSqlSubstrFunctionCall() != null) {
            SqlSubstrFunctionCall sqlSubstrFunctionCall = sqlNode.getSqlSubstrFunctionCall();
            writer.append("substring(").append(sqlSubstrFunctionCall.getSourceString()).append(" from ");
            writer.append(sqlSubstrFunctionCall.getFromDecimal());
            if (sqlSubstrFunctionCall.getForDecimal() != null) {
                writer.append(" for ").append(sqlSubstrFunctionCall.getForDecimal());
            }
            writer.append(")");
        } else if (sqlNode.getSqlTrimFunctionCall() != null) {
            SqlTrimFunctionCall sqlTrimFunctionCall = sqlNode.getSqlTrimFunctionCall();
            writer.append("trim(").append(sqlTrimFunctionCall.getPositionForm()).append(sqlTrimFunctionCall.getSourceString());
            writer.append(" from ").append(sqlTrimFunctionCall.getFromString()).append(")");
        } else if (sqlNode.getSqlConvertDataTypeFunctionCall() != null) {
            SqlConvertDataTypeFunctionCall sqlConvertDataTypeFunctionCall = sqlNode.getSqlConvertDataTypeFunctionCall();
            writer.append(sqlConvertDataTypeFunctionCall.getFunctionName()).writeSpace(1);
            writer.append("(");
            sqlConvertDataTypeFunctionCall.getSqlExpression().unparse(writer, context);
            writer.append(sqlConvertDataTypeFunctionCall.getKeyWords()).writeSpace(1);
            if (sqlConvertDataTypeFunctionCall.getConvertedDataType() != null) {
                writer.append(sqlConvertDataTypeFunctionCall.getConvertedDataType()).writeSpace(1);
            } else if (sqlConvertDataTypeFunctionCall.getCharsetName() != null) {
                writer.append(sqlConvertDataTypeFunctionCall.getCharsetName()).writeSpace(1);
            }
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getSqlCastDataTypeFunctionCall() != null) {
            this.getCastFunctionByArgs(sqlNode.getSqlCastDataTypeFunctionCall(), writer, context);
        } else if (sqlNode.getValuesFunctionFullColumnName() != null) {
            writer.append("VALUES").writeSpace(1);
            writer.append("(");
            writer.append(sqlNode.getValuesFunctionFullColumnName()).writeSpace(1);
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getCaseAndExpressionFunction() != null) {
            SqlCaseFunctionCall caseAndExpressionFunction = sqlNode.getCaseAndExpressionFunction();
            writer.append("CASE").writeSpace(1);
            if (caseAndExpressionFunction.getSqlExpression() != null) {
                caseAndExpressionFunction.getSqlExpression().unparse(writer, context);
            }
            for (int i = 0; i < caseAndExpressionFunction.getSqlCaseFuncAlternativeSqlNodeList().getNodes().size(); ++i) {
                caseAndExpressionFunction.getSqlCaseFuncAlternativeSqlNodeList().getNodes().get(i).unparse(writer, context);
            }
            if (caseAndExpressionFunction.getSqlFunctionArg() != null) {
                writer.append("ELSE").writeSpace(1);
                caseAndExpressionFunction.getSqlFunctionArg().unparse(writer, context);
            }
            writer.append("END").writeSpace(1);
        } else if (sqlNode.getSqlCharFunctionCall() != null) {
            SqlCharFunctionCall sqlCharFunctionCall = sqlNode.getSqlCharFunctionCall();
            writer.append("CHAR").writeSpace(1);
            writer.append("(");
            if (sqlCharFunctionCall.getSqlFunctionArgs() != null) {
                List<SqlFunctionArg> sqlFunctionArgList = sqlCharFunctionCall.getSqlFunctionArgs().getSqlFunctionArgSqlNodeList().getNodes();
                for (int i = 0; i < sqlFunctionArgList.size(); ++i) {
                    sqlFunctionArgList.get(i).unparse(writer, context);
                    if (i == sqlFunctionArgList.size() - 1) continue;
                    writer.append(",").writeSpace(1);
                }
            }
            if (sqlCharFunctionCall.getCharsetName() != null) {
                writer.append("USING").writeSpace(1);
                writer.append(sqlCharFunctionCall.getCharsetName()).writeSpace(1);
            }
            writer.append(")").writeSpace(1);
        } else if (sqlNode.getSqlExtractFunctionCall() != null) {
            writer.append("EXTRACT (");
            switch (sqlNode.getSqlExtractFunctionCall().getIntervalType().toLowerCase(Locale.ROOT)) {
                case "dayofweek": {
                    writer.append("ISODOW");
                    break;
                }
                default: {
                    writer.append(sqlNode.getSqlExtractFunctionCall().getIntervalType());
                }
            }
            writer.writeSpace().append("FROM ");
            if (sqlNode.getSqlExtractFunctionCall().getComplexExpression() != null) {
                sqlNode.getSqlExtractFunctionCall().getComplexExpression().unparse(writer, context);
            } else {
                writer.append(sqlNode.getSqlExtractFunctionCall().getComplex());
            }
            writer.writeSpace().append(")");
        }
    }

    private void getCastFunctionByArgs(SqlCastDataTypeFunctionCall sqlNode, SqlWriter writer, UnParserContext context) {
        SqlConstantExpressionAtom sqlConstantExpressionAtom;
        String convertTypeName = sqlNode.getConvertedDataType();
        String constant = null;
        String complex = sqlNode.getComplex();
        String regexNum = "-?[0-9]+(\\.[0-9]+)?";
        String regexInt = "-?[0-9]*";
        if (sqlNode.getSqlExpression() != null && (sqlConstantExpressionAtom = sqlNode.getSqlExpression().getSqlPredicateExpression().getSqlPredicate().getSqlExpressionAtomPredicate().getSqlExpressionAtom().getSqlConstantExpressionAtom()) != null) {
            constant = sqlConstantExpressionAtom.getLiteral().getLiteral();
        }
        if ((convertTypeName = this.getConvertTypeName(sqlNode, convertTypeName, constant, complex, regexNum, regexInt)).toLowerCase(Locale.ROOT).contains("decimalv3")) {
            convertTypeName = convertTypeName.replaceAll("(?i)decimalv3", "DECIMAL");
        } else if (convertTypeName.toLowerCase(Locale.ROOT).contains("datetimev2")) {
            convertTypeName = convertTypeName.replaceAll("(?i)datetimev2", "TIMESTAMP");
        }
        if (convertTypeName.equalsIgnoreCase("varbinary")) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Varbinary type");
        }
        if (convertTypeName.toLowerCase(Locale.ROOT).startsWith("array") || convertTypeName.toLowerCase(Locale.ROOT).startsWith("map")) {
            convertTypeName = "text";
        }
        if (convertTypeName.toLowerCase(Locale.ROOT).startsWith("decimal") && sqlNode.isStringLiteral()) {
            sqlNode.setFunctionName("try_cast");
        }
        writer.append(sqlNode.getFunctionName()).writeSpace(1);
        writer.append("(");
        if (sqlNode.getSqlExpression() != null) {
            sqlNode.getSqlExpression().unparse(writer, context);
        } else {
            writer.append(sqlNode.getComplex());
        }
        writer.append(" AS ").append(convertTypeName).writeSpace(1);
        writer.append(")").writeSpace(1);
    }

    private String getConvertTypeName(SqlCastDataTypeFunctionCall sqlNode, String convertTypeName, String constant, String complex, String regexNum, String regexInt) {
        switch (convertTypeName.toLowerCase(Locale.ROOT)) {
            case "boolean": {
                if (constant.contains(".") && !constant.contains("'")) {
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Double type");
                }
                sqlNode.setFunctionName("try_cast");
                break;
            }
            case "int": 
            case "integer": {
                this.integerTypeConvert(sqlNode, constant, regexInt, Integer.MAX_VALUE, Integer.MIN_VALUE);
                break;
            }
            case "smallint": {
                this.integerTypeConvert(sqlNode, constant, regexInt, Short.MAX_VALUE, Short.MIN_VALUE);
                break;
            }
            case "tinyint": {
                this.integerTypeConvert(sqlNode, constant, regexInt, 127, 0);
                break;
            }
            case "bigint": {
                this.bigintTypeConvert(sqlNode, constant, regexInt);
                break;
            }
            case "json": {
                if (sqlNode.isStringLiteral()) {
                    sqlNode.setFunctionName("try_cast");
                    break;
                }
                if (sqlNode.getComplex() == null && !constant.matches(regexNum)) break;
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Integer and complex type");
            }
            case "double precision": {
                if (sqlNode.isStringLiteral()) {
                    if ((constant = QuoteUtils.removeSingleQuote(constant)).matches(regexNum)) break;
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Varchar type");
                }
                if (sqlNode.getComplex() == null) break;
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Complex type conversions");
            }
            case "time": {
                this.timeTypeConvert(sqlNode, constant, complex, regexNum);
                break;
            }
            case "date": 
            case "timestamp": {
                this.dateAndTimestampTypeConvert(sqlNode, constant, complex, regexNum);
                break;
            }
            case "signed": 
            case "unsigned": {
                convertTypeName = "NUMBER";
                break;
            }
            case "datev2": {
                convertTypeName = "DATE";
                break;
            }
        }
        return convertTypeName;
    }

    private void dateAndTimestampTypeConvert(SqlCastDataTypeFunctionCall sqlNode, String constant, String complex, String regexNum) {
        if (sqlNode.isStringLiteral()) {
            sqlNode.setFunctionName("try_cast");
        } else if (complex != null) {
            String regexTime = "(?i)^(time)\\s*'[\\S+\\s+]*";
            if (complex.toLowerCase(Locale.ROOT).startsWith("datetime")) {
                sqlNode.setComplex(complex.toLowerCase(Locale.ROOT).replaceAll("datetime", "timestamp"));
            }
            if (complex.matches(regexTime)) {
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Time type");
            }
        } else if (constant != null && constant.matches(regexNum)) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Number type");
        }
    }

    private void timeTypeConvert(SqlCastDataTypeFunctionCall sqlNode, String constant, String complex, String regexNum) {
        if (sqlNode.isStringLiteral()) {
            sqlNode.setFunctionName("try_cast");
        } else if (complex != null) {
            if (complex.toLowerCase(Locale.ROOT).startsWith("datetime")) {
                sqlNode.setComplex(complex.toLowerCase(Locale.ROOT).replaceAll("datetime", "timestamp"));
            }
        } else if (constant != null && constant.matches(regexNum)) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Number type");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bigintTypeConvert(SqlCastDataTypeFunctionCall sqlNode, String constant, String regexInt) {
        BigDecimal maxBigDecimal = new BigDecimal(Long.MAX_VALUE);
        BigDecimal minBigDecimal = new BigDecimal(Long.MIN_VALUE);
        if (sqlNode.isStringLiteral()) {
            if (!(constant = QuoteUtils.removeSingleQuote(constant)).matches(regexInt)) throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Varchar type conversions");
            BigDecimal bigDecimal = new BigDecimal(constant);
            if (bigDecimal.compareTo(maxBigDecimal) != 1 && bigDecimal.compareTo(minBigDecimal) != -1) return;
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Exceeds the boundary value");
        }
        if (constant != null && constant.matches(regexInt)) {
            BigDecimal bigDecimal = new BigDecimal(constant);
            if (bigDecimal.compareTo(maxBigDecimal) != 1 && bigDecimal.compareTo(minBigDecimal) != -1) return;
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Exceeds the boundary value");
        }
        if (sqlNode.getComplex() == null) return;
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Complex type");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void integerTypeConvert(SqlCastDataTypeFunctionCall sqlNode, String constant, String regexInt, int max, int min) {
        if (sqlNode.isStringLiteral()) {
            if (!(constant = QuoteUtils.removeSingleQuote(constant)).matches(regexInt)) throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Varchar type conversions");
            if (Integer.valueOf(constant) <= max && Integer.valueOf(constant) >= min) return;
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Exceeds the boundary value");
        }
        if (constant == null || !constant.matches(regexInt) || Integer.valueOf(constant) <= max && Integer.valueOf(constant) >= min) return;
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Exceeds the boundary value type");
    }
}

