/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.CreateIndexUtil;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlUKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlUKeyTableConstraint.class)
public class SqlUKeyTableConstraintUnParser
implements UnParser<SqlUKeyTableConstraint> {
    private static final Logger LOGGER = LogManager.getLogger(SqlUKeyTableConstraintUnParser.class);

    @Override
    public void unparse(SqlUKeyTableConstraint sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig(context.getCurrentTableName().getTableName().getIdentifier());
        if (ConfigUtil.getConfigValue(config, "table.orientation", "ROW").equalsIgnoreCase("ROW")) {
            if (sqlNode.getIndexName() != null) {
                writer.append("CONSTRAINT").writeSpace(1);
                this.createConstraintNameByArgs(sqlNode, writer, context);
                writer.writeSpace(1);
            }
            writer.append("UNIQUE").writeSpace(1);
            writer.append("(");
            for (int j = 0; j < sqlNode.getIndexColumns().size(); ++j) {
                sqlNode.getIndexColumns().get(j).unparse(writer, context);
                if (j == sqlNode.getIndexColumns().size() - 1) continue;
                writer.append(",");
            }
            writer.append(")");
            if (sqlNode.getIndexOptions() != null && !sqlNode.getIndexOptions().isEmpty()) {
                LOGGER.error("Other index options are not supported in DSC");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "index options");
            }
        }
    }

    private void createConstraintNameByArgs(SqlUKeyTableConstraint sqlUKeyTableConstraint, SqlWriter writer, UnParserContext context) {
        String stringProperty = PropertyLoader.getStringProperty(MysqlPropEnum.MYSQL_OPTION_SQL_MODE.getValue());
        String constraintName = sqlUKeyTableConstraint.getIndexName().getIdentifier();
        String tableName = context.getCurrentTableName().getTableName().getIdentifier();
        if (stringProperty.toUpperCase(Locale.ROOT).contains("INDEX_RENAME")) {
            writer.writeSpace(1).append(CreateIndexUtil.appendIndexNameWithTableName(constraintName, tableName));
            return;
        }
        ConvertConfig config = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(config, "table.index.rename", "false").equalsIgnoreCase("true")) {
            writer.writeSpace(1).append(CreateIndexUtil.appendIndexNameWithTableName(constraintName, tableName));
            return;
        }
        writer.writeSpace(1);
        sqlUKeyTableConstraint.getIndexName().unparse(writer, context);
    }
}

