/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlUpdate;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlUpdate.class)
public class SqlUpdateUnParser
implements UnParser<SqlUpdate> {
    private static final Logger LOGGER = LogManager.getLogger(SqlUpdateUnParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unparse(SqlUpdate update, SqlWriter writer, UnParserContext context) {
        context.setCurrentTableName(update.getTableName());
        writer.append("UPDATE");
        writer.writeSpace(1);
        if (update.getPriority() != null) {
            if (update.getPriority().equalsIgnoreCase("IGNORE")) {
                LOGGER.error("IGNORE is not supported in dws.");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "ignore");
            }
            writer.append("/* " + update.getPriority() + "*/").writeSpace(1);
        }
        context.setOriSchema(true);
        update.getTableName().unparse(writer, context);
        context.setOriSchema(false);
        if (update.getTableNameAlias() != null) {
            writer.writeSpace(1);
            writer.append("AS").writeSpace(1);
            update.getTableNameAlias().unparse(writer, context);
        }
        writer.writeSpace(1);
        this.unparseComment(update.getTableName(), writer);
        writer.append("SET").writeSpace(1);
        context.setNodeListSeparator(",");
        try {
            update.getUpdateColumns().unparse(writer, context);
        }
        finally {
            context.resetNodeListSeparator();
        }
        if (update.getWhereClause() != null) {
            writer.writeSpace(1).append("WHERE").writeSpace(1);
            update.getWhereClause().unparse(writer, context);
        }
        writer.sqlEnd();
    }
}

