/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.unparser;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.config.ConvertConfig;
import com.huawei.hwclouds.scs.sql.nodes.SqlUse;
import com.huawei.hwclouds.scs.sql.util.ConfigUtil;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlnode=SqlUse.class)
public class SqlUseUnParser
implements UnParser<SqlUse> {
    private static final Logger LOGGER = LogManager.getLogger(SqlUse.class);

    @Override
    public void unparse(SqlUse sqlUse, SqlWriter writer, UnParserContext context) {
        LOGGER.info("SqlUse enter");
        ConvertConfig defaultConfig = writer.getConfig("param.config.flag");
        if (ConfigUtil.getConfigValue(defaultConfig, "table.databaseAsSchema", "true").equalsIgnoreCase("true")) {
            this.schemaUnparser(sqlUse, writer, context);
        } else {
            this.databaseUnparser(sqlUse, writer, context);
        }
    }

    private void databaseUnparser(SqlUse sqlUse, SqlWriter writer, UnParserContext context) {
        writer.append("ALTER").writeSpace(1);
        writer.append("DATABASE").writeSpace(1);
        sqlUse.getDatabaseName().unparse(writer, context);
        writer.append(";");
    }

    private void schemaUnparser(SqlUse sqlUse, SqlWriter writer, UnParserContext context) {
        writer.append("SET").writeSpace(1);
        writer.append("CURRENT_SCHEMA").writeSpace(1).append("=").writeSpace(1);
        sqlUse.getDatabaseName().unparse(writer, context);
        writer.append(";");
    }
}

