/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.dws.util;

import com.huawei.hwclouds.scs.dws.enums.MysqlPropEnum;
import com.huawei.hwclouds.scs.dws.util.PropertyLoader;
import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateTable;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlUKeyTableConstraint;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CreateIndexUtil {
    public static String getIndexName(SqlCreateTable sqlCreateTable, SqlColumnDefinition sqlColumnDefinition, SqlWriter writer, UnParserContext context) {
        SqlWriter nWriter = writer.cloneEmpty();
        sqlCreateTable.getTableName().unparse(nWriter, context);
        String fullTName = nWriter.toSqlString().getSql();
        int dbNameIndex = fullTName.lastIndexOf(".");
        String idxPrefix = "IDX_";
        String tName = dbNameIndex > 0 ? QuoteUtils.removeDoubleQuote(fullTName.substring(dbNameIndex + 1)) : fullTName;
        String idxColumns = sqlColumnDefinition.getColumnName().getIdentifier();
        String idxName = idxPrefix + tName + "_" + idxColumns;
        if (idxName.length() > 63) {
            idxName = idxName.substring(0, 63);
        }
        return idxName.toLowerCase(Locale.ROOT);
    }

    public static String getIndexNameConstraint(SqlCreateTable sqlCreateTable, SqlUKeyTableConstraint sqlTableConstraint, SqlWriter writer, UnParserContext context) {
        SqlWriter nWriter = writer.cloneEmpty();
        sqlCreateTable.getTableName().unparse(nWriter, context);
        String fullTName = nWriter.toSqlString().getSql();
        int dbNameIndex = fullTName.lastIndexOf(".");
        String idxPrefix = "IDX_";
        String tName = dbNameIndex > 0 ? QuoteUtils.removeDoubleQuote(fullTName.substring(dbNameIndex + 1)) : fullTName;
        List<SqlIndexColumnName> indexColumns = sqlTableConstraint.getIndexColumns();
        String idxColumns = indexColumns.stream().map(SqlIndexColumnName::getColumnName).map(SqlIdentifier::getIdentifier).collect(Collectors.joining("_"));
        String idxName = idxPrefix + tName + "_" + idxColumns;
        if (idxName.length() > 63) {
            idxName = idxName.substring(0, 63);
        }
        return idxName.toLowerCase(Locale.ROOT);
    }

    public static SqlNodeList<SqlIdentifier> getUniqueColumnNameOfConstraint(SqlUKeyTableConstraint sqlTableConstraint) {
        List<SqlIndexColumnName> indexColumns = sqlTableConstraint.getIndexColumns();
        SqlNodeList<SqlIdentifier> IdentifierListOfIndex = new SqlNodeList<SqlIdentifier>();
        for (SqlIndexColumnName indexColumn : indexColumns) {
            IdentifierListOfIndex.addNode(new SqlIdentifier(indexColumn.getColumnName().getIdentifier()));
        }
        return IdentifierListOfIndex;
    }

    public static String appendIndexNameWithTableName(String indexName, String tableName) {
        String result = tableName + "_" + QuoteUtils.removeDoubleQuote(indexName);
        if (result.length() > 63) {
            result = result.substring(0, 63);
        }
        result = QuoteUtils.addDoubleQuote(result);
        String caseSensitive = PropertyLoader.getStringProperty(MysqlPropEnum.TABLE_COLUMN_CASE_SENSITIVE.getValue());
        if (caseSensitive.equalsIgnoreCase("true")) {
            return result;
        }
        return result.toLowerCase(Locale.ROOT);
    }
}

