/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.FunctionArgVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlDefaultRole;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArg;
import com.huawei.hwclouds.scs.sql.nodes.SqlNewValueInsideTrigger;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPasswordFunctionClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlRoleOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetCharacter;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetNames;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetNewValueInsideTrigger;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetPasswordStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetResourceGroup;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetRole;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetTransation;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetVariable;
import com.huawei.hwclouds.scs.sql.nodes.SqlTransactionOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlVariableClause;
import com.huawei.hwclouds.scs.sql.nodes.SqlVariableStatement;
import com.huawei.hwclouds.scs.sql.nodes.TransactionMode;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdministrationStatementVisitor
extends AbstractVisitor<SqlCommentNode> {
    private static final Logger LOGGER = LogManager.getLogger(AdministrationStatementVisitor.class);

    @Override
    protected SqlCommentNode defaultResult() {
        return null;
    }

    @Override
    public SqlCommentNode visitAlterUserMysqlV56(MySqlParser.AlterUserMysqlV56Context ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter user");
    }

    @Override
    public SqlCommentNode visitAlterUserMysqlV57(MySqlParser.AlterUserMysqlV57Context ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter user");
    }

    @Override
    public SqlCommentNode visitCreateUserMysqlV56(MySqlParser.CreateUserMysqlV56Context ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create user");
    }

    @Override
    public SqlCommentNode visitCreateUserMysqlV57(MySqlParser.CreateUserMysqlV57Context ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create user");
    }

    @Override
    public SqlCommentNode visitDropUser(MySqlParser.DropUserContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "drop user");
    }

    @Override
    public SqlCommentNode visitGrantStatement(MySqlParser.GrantStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "grant statement");
    }

    @Override
    public SqlCommentNode visitGrantProxy(MySqlParser.GrantProxyContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "grant proxy");
    }

    @Override
    public SqlCommentNode visitRenameUser(MySqlParser.RenameUserContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "rename user");
    }

    @Override
    public SqlCommentNode visitDetailRevoke(MySqlParser.DetailRevokeContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "revoke statement");
    }

    @Override
    public SqlCommentNode visitShortRevoke(MySqlParser.ShortRevokeContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "revoke statement");
    }

    @Override
    public SqlCommentNode visitRevokeProxy(MySqlParser.RevokeProxyContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "revoke statement");
    }

    @Override
    public SqlCommentNode visitAnalyzeTable(MySqlParser.AnalyzeTableContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "analyze table");
    }

    @Override
    public SqlCommentNode visitCheckTable(MySqlParser.CheckTableContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "check table");
    }

    @Override
    public SqlCommentNode visitChecksumTable(MySqlParser.ChecksumTableContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "checksum table");
    }

    @Override
    public SqlCommentNode visitOptimizeTable(MySqlParser.OptimizeTableContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "optimize table");
    }

    @Override
    public SqlCommentNode visitRepairTable(MySqlParser.RepairTableContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "repair table");
    }

    @Override
    public SqlCommentNode visitCreateUdfunction(MySqlParser.CreateUdfunctionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "create function");
    }

    @Override
    public SqlCommentNode visitInstallPlugin(MySqlParser.InstallPluginContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "install plugin");
    }

    @Override
    public SqlCommentNode visitUninstallPlugin(MySqlParser.UninstallPluginContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "uninstall plugin");
    }

    @Override
    public SqlCommentNode visitSetVariable(MySqlParser.SetVariableContext ctx) {
        SqlSetVariable sqlSetVariable = new SqlSetVariable();
        ArrayList<SqlVariableStatement> list = new ArrayList<SqlVariableStatement>();
        List<MySqlParser.VariableStatementContext> variableStatement = ctx.variableStatement();
        for (int i = 0; i < variableStatement.size(); ++i) {
            SqlVariableStatement sqlVariableStatement = new SqlVariableStatement();
            SqlVariableClause sqlVariableClause = new SqlVariableClause();
            MySqlParser.VariableClauseContext variableClauseContext = variableStatement.get(i).variableClause();
            if (variableClauseContext.GLOBAL() != null) {
                sqlVariableClause.setSystemVariable(variableClauseContext.GLOBAL().getText());
            } else if (variableClauseContext.LOCAL() != null) {
                sqlVariableClause.setSystemVariable(variableClauseContext.LOCAL().getText());
            } else if (variableClauseContext.SESSION() != null) {
                sqlVariableClause.setSystemVariable(variableClauseContext.SESSION().getText());
            }
            if (variableClauseContext.LOCAL_ID() != null) {
                sqlVariableClause.setLocalId(variableClauseContext.LOCAL_ID().getText());
            }
            if (variableClauseContext.GLOBAL_ID() != null) {
                sqlVariableClause.setGlobalId(variableClauseContext.GLOBAL_ID().getText());
            }
            if (variableClauseContext.AT_SIGN() != null && !variableClauseContext.AT_SIGN().isEmpty()) {
                sqlVariableClause.setAtSign(variableClauseContext.AT_SIGN().toString());
            }
            if (variableClauseContext.uid() != null) {
                sqlVariableClause.setUid(variableClauseContext.uid().getText());
            }
            if (variableClauseContext.uid() != null && variableClauseContext.LOCAL() == null && variableClauseContext.GLOBAL() == null && variableClauseContext.SESSION() == null) {
                sqlSetVariable.setOnlyUid(true);
            }
            sqlVariableStatement.setSqlVariableClause(sqlVariableClause);
            TerminalNode equalSymbol = variableStatement.get(i).EQUAL_SYMBOL();
            if (equalSymbol != null && !equalSymbol.getText().isEmpty()) {
                sqlVariableStatement.setEqualSymbol(true);
            }
            if (variableStatement.get(i).expression() != null) {
                SqlExpression expression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)variableStatement.get(i).expression());
                sqlVariableStatement.setSqlExpression(expression);
            }
            if (variableStatement.get(i).ON() != null) {
                sqlVariableStatement.setIsHavingOn(variableStatement.get(i).ON().getText());
            }
            list.add(sqlVariableStatement);
        }
        sqlSetVariable.setSqlVariableClauseList(list);
        return sqlSetVariable;
    }

    @Override
    public SqlCommentNode visitSetCharset(MySqlParser.SetCharsetContext ctx) {
        LOGGER.info("visitSetCharset enter ");
        SqlSetCharacter sqlSetCharacter = new SqlSetCharacter();
        if (ctx.DEFAULT() != null) {
            sqlSetCharacter.setCharsetNameBase(SqlSetCharacter.CharsetNameBase.DEFAULT);
            return sqlSetCharacter;
        }
        if (ctx.charsetName().BINARY() != null) {
            sqlSetCharacter.setCharsetNameBase(SqlSetCharacter.CharsetNameBase.BINARY);
            return sqlSetCharacter;
        }
        if (ctx.charsetName().charsetNameBase() != null) {
            sqlSetCharacter.setCharsetNameBase(SqlSetCharacter.CharsetNameBase.getInstanceByname(ctx.charsetName().charsetNameBase().getText()));
            return sqlSetCharacter;
        }
        if (ctx.charsetName().STRING_LITERAL() != null) {
            sqlSetCharacter.setCharsetNameBase(SqlSetCharacter.CharsetNameBase.getInstanceByname(QuoteUtils.removeSingleQuote(ctx.charsetName().getText())));
            return sqlSetCharacter;
        }
        if (ctx.charsetName().CHARSET_REVERSE_QOUTE_STRING() != null) {
            sqlSetCharacter.setCharsetNameBase(SqlSetCharacter.CharsetNameBase.getInstanceByname(QuoteUtils.removeQuote(ctx.charsetName().getText())));
            return sqlSetCharacter;
        }
        return sqlSetCharacter;
    }

    @Override
    public SqlCommentNode visitSetNames(MySqlParser.SetNamesContext ctx) {
        SqlSetNames sqlSetNames = new SqlSetNames();
        if (ctx.charsetName() != null) {
            sqlSetNames.setCharsetName(ctx.charsetName().getText());
        }
        if (ctx.collationName() != null) {
            sqlSetNames.setCollationName(ctx.collationName().getText());
        }
        if (ctx.DEFAULT() != null) {
            sqlSetNames.setIsHavingDefault(ctx.DEFAULT().getText());
        }
        return sqlSetNames;
    }

    @Override
    public SqlCommentNode visitSetPassword(MySqlParser.SetPasswordContext ctx) {
        SqlSetPasswordStatement sqlSetPasswordStatement = new SqlSetPasswordStatement();
        if (ctx.setPasswordStatement().userName() != null) {
            sqlSetPasswordStatement.setUserName(ctx.setPasswordStatement().userName().getText());
        }
        if (ctx.setPasswordStatement().STRING_LITERAL() != null) {
            sqlSetPasswordStatement.setStringLiteral(ctx.setPasswordStatement().STRING_LITERAL().getText());
        }
        SqlPasswordFunctionClause sqlPasswordFunctionClause = new SqlPasswordFunctionClause();
        MySqlParser.PasswordFunctionClauseContext functionClause = ctx.setPasswordStatement().passwordFunctionClause();
        if (functionClause != null) {
            if (functionClause.functionName != null) {
                sqlPasswordFunctionClause.setFunctionName(functionClause.functionName.getText());
            }
            if (functionClause.functionArg() != null) {
                sqlPasswordFunctionClause.setFunctionArg((SqlFunctionArg)new FunctionArgVisitor().visit((ParseTree)functionClause.functionArg()));
            }
            sqlSetPasswordStatement.setPasswordFunctionClause(sqlPasswordFunctionClause);
        }
        return sqlSetPasswordStatement;
    }

    @Override
    public SqlCommentNode visitSetRole(MySqlParser.SetRoleContext ctx) {
        int i;
        List<MySqlParser.RoleNameContext> roleNameContexts;
        SqlSetRole sqlSetRole = new SqlSetRole();
        SqlRoleOption sqlRoleOption = new SqlRoleOption();
        SqlDefaultRole sqlDefaultRole = new SqlDefaultRole();
        if (ctx.roleOption() != null) {
            if (ctx.roleOption().DEFAULT() != null) {
                sqlRoleOption.setHavingDefault(ctx.roleOption().DEFAULT().getText());
            }
            if (ctx.roleOption().NONE() != null) {
                sqlRoleOption.setNone(ctx.roleOption().NONE().getText());
            }
            if (ctx.roleOption().ALL() != null) {
                sqlRoleOption.setAll(ctx.roleOption().ALL().getText());
            }
            if (ctx.roleOption().EXCEPT() != null) {
                sqlRoleOption.setExcept(ctx.roleOption().EXCEPT().getText());
            }
            ArrayList<String> list = new ArrayList<String>();
            if (ctx.roleOption().roleName() != null) {
                roleNameContexts = ctx.roleOption().roleName();
                for (i = 0; i < roleNameContexts.size(); ++i) {
                    list.add(roleNameContexts.get(i).getText());
                }
                sqlRoleOption.setRoleNames(list);
            }
            sqlSetRole.setRoleOption(sqlRoleOption);
        }
        if (ctx.defaultRole() != null) {
            if (ctx.defaultRole().NONE() != null) {
                sqlDefaultRole.setNone(ctx.defaultRole().NONE().getText());
            }
            if (ctx.defaultRole().ALL() != null) {
                sqlDefaultRole.setAll(ctx.defaultRole().ALL().getText());
            }
            ArrayList<String> roleList = new ArrayList<String>();
            if (ctx.defaultRole().roleName() != null) {
                roleNameContexts = ctx.defaultRole().roleName();
                for (i = 0; i < roleNameContexts.size(); ++i) {
                    roleList.add(roleNameContexts.get(i).getText());
                }
                sqlDefaultRole.setRoleNames(roleList);
            }
            ArrayList<String> userList = new ArrayList<String>();
            if (ctx.defaultRole().userName() != null) {
                List<MySqlParser.UserNameContext> userNameContexts = ctx.defaultRole().userName();
                for (int i2 = 0; i2 < userNameContexts.size(); ++i2) {
                    userList.add(userNameContexts.get(i2).getText());
                }
                sqlDefaultRole.setUserNames(userList);
            }
            sqlSetRole.setDefaultRole(sqlDefaultRole);
        }
        return sqlSetRole;
    }

    @Override
    public SqlCommentNode visitSetResourceGroup(MySqlParser.SetResourceGroupContext ctx) {
        SqlSetResourceGroup sqlSetResourceGroup = new SqlSetResourceGroup();
        ArrayList<String> list = new ArrayList<String>();
        if (ctx.groupName() != null) {
            sqlSetResourceGroup.setGroupName(ctx.groupName().getText());
        }
        if (ctx.constant() != null) {
            for (int i = 0; i < ctx.constant().size(); ++i) {
                list.add(ctx.constant().get(i).getText());
                sqlSetResourceGroup.setConstants(list);
            }
        }
        return sqlSetResourceGroup;
    }

    @Override
    public SqlCommentNode visitSetTransactionStatement(MySqlParser.SetTransactionStatementContext ctx) {
        LOGGER.info("Set Transaction enter ");
        SqlSetTransation sqlSetTransation = new SqlSetTransation();
        if (ctx.GLOBAL() != null) {
            sqlSetTransation.setTransactionContext(SqlSetTransation.TransactionContext.GLOBAL);
        }
        if (ctx.SESSION() != null) {
            sqlSetTransation.setTransactionContext(SqlSetTransation.TransactionContext.SESSION);
        }
        if (ctx.SESSION() == null && ctx.GLOBAL() == null) {
            sqlSetTransation.setTransactionContext(SqlSetTransation.TransactionContext.DEFAULT);
        }
        SqlNodeList<SqlTransactionOption> sqlTransactionOptionSqlNodeList = new SqlNodeList<SqlTransactionOption>();
        SqlTransactionOption sqlTransactionOption = new SqlTransactionOption();
        ArrayList<TransactionMode> modeList = new ArrayList<TransactionMode>();
        List<MySqlParser.TransactionOptionContext> transactionOption = ctx.transactionOption();
        for (int i = 0; i < transactionOption.size(); ++i) {
            MySqlParser.TransactionLevelContext level;
            MySqlParser.TransactionOptionContext option = transactionOption.get(i);
            if (option.ONLY() != null) {
                sqlTransactionOption.setAccessMode(SqlTransactionOption.AccessMode.READ_ONLY);
            }
            if (option.WRITE() != null) {
                sqlTransactionOption.setAccessMode(SqlTransactionOption.AccessMode.READ_WRITE);
            }
            if ((level = option.transactionLevel()) == null) continue;
            if (level.REPEATABLE() != null) {
                modeList.add(TransactionMode.REPEATABLE_READ);
                continue;
            }
            if (level.COMMITTED() != null) {
                modeList.add(TransactionMode.READ_COMMITTED);
                continue;
            }
            if (level.UNCOMMITTED() != null) {
                modeList.add(TransactionMode.READ_UNCOMMITTED);
                continue;
            }
            if (level.SERIALIZABLE() == null) continue;
            modeList.add(TransactionMode.SERIALIZABLE);
        }
        sqlTransactionOption.setTransactionMode(modeList);
        sqlTransactionOptionSqlNodeList.addNode(sqlTransactionOption);
        sqlSetTransation.setSqlTransactionOption(sqlTransactionOptionSqlNodeList);
        return sqlSetTransation;
    }

    @Override
    public SqlCommentNode visitSetAutocommit(MySqlParser.SetAutocommitContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "set autocommit");
    }

    @Override
    public SqlCommentNode visitSetNewValueInsideTrigger(MySqlParser.SetNewValueInsideTriggerContext ctx) {
        SqlSetNewValueInsideTrigger sqlSetNewValueInsideTrigger = new SqlSetNewValueInsideTrigger();
        SqlNodeList<SqlNewValueInsideTrigger> sqlNewValueInsideTriggerSqlNodeList = new SqlNodeList<SqlNewValueInsideTrigger>();
        List<MySqlParser.NewValueInsideTriggerStatementContext> contextList = ctx.newValueInsideTriggerStatement();
        for (int i = 0; i < contextList.size(); ++i) {
            MySqlParser.ExpressionContext expression;
            SqlNewValueInsideTrigger sqlNewValueInsideTrigger = new SqlNewValueInsideTrigger();
            if (contextList.get(i).fullId() != null) {
                sqlNewValueInsideTrigger.setFullId(contextList.get(i).fullId().getText());
            }
            if ((expression = contextList.get(i).expression()) != null) {
                sqlNewValueInsideTrigger.setSqlExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)expression));
            }
            sqlNewValueInsideTriggerSqlNodeList.addNode(sqlNewValueInsideTrigger);
        }
        sqlSetNewValueInsideTrigger.setSqlNewValueInsideTriggers(sqlNewValueInsideTriggerSqlNodeList);
        return sqlSetNewValueInsideTrigger;
    }

    @Override
    public SqlCommentNode visitShowMasterLogs(MySqlParser.ShowMasterLogsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show master logs");
    }

    @Override
    public SqlCommentNode visitShowLogEvents(MySqlParser.ShowLogEventsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show log events");
    }

    @Override
    public SqlCommentNode visitShowObjectFilter(MySqlParser.ShowObjectFilterContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show common statement");
    }

    @Override
    public SqlCommentNode visitShowColumns(MySqlParser.ShowColumnsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show column");
    }

    @Override
    public SqlCommentNode visitShowCreateDb(MySqlParser.ShowCreateDbContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show create db");
    }

    @Override
    public SqlCommentNode visitShowCreateFullIdObject(MySqlParser.ShowCreateFullIdObjectContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show create statement");
    }

    @Override
    public SqlCommentNode visitShowCreateUser(MySqlParser.ShowCreateUserContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show create user");
    }

    @Override
    public SqlCommentNode visitShowEngine(MySqlParser.ShowEngineContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show engine");
    }

    @Override
    public SqlCommentNode visitShowGlobalInfo(MySqlParser.ShowGlobalInfoContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show global info");
    }

    @Override
    public SqlCommentNode visitShowErrors(MySqlParser.ShowErrorsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show error");
    }

    @Override
    public SqlCommentNode visitShowCountErrors(MySqlParser.ShowCountErrorsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show count error");
    }

    @Override
    public SqlCommentNode visitShowSchemaFilter(MySqlParser.ShowSchemaFilterContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show statement");
    }

    @Override
    public SqlCommentNode visitShowRoutine(MySqlParser.ShowRoutineContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show statement");
    }

    @Override
    public SqlCommentNode visitShowGrants(MySqlParser.ShowGrantsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show grant");
    }

    @Override
    public SqlCommentNode visitShowIndexes(MySqlParser.ShowIndexesContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show statement");
    }

    @Override
    public SqlCommentNode visitShowOpenTables(MySqlParser.ShowOpenTablesContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show statement");
    }

    @Override
    public SqlCommentNode visitShowProfile(MySqlParser.ShowProfileContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show profile");
    }

    @Override
    public SqlCommentNode visitShowSlaveStatus(MySqlParser.ShowSlaveStatusContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "show slave status");
    }

    @Override
    public SqlCommentNode visitBinlogStatement(MySqlParser.BinlogStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "binlog statement");
    }

    @Override
    public SqlCommentNode visitKillStatement(MySqlParser.KillStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "kill statement");
    }

    @Override
    public SqlCommentNode visitLoadIndexIntoCache(MySqlParser.LoadIndexIntoCacheContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "load index into cache");
    }

    @Override
    public SqlCommentNode visitResetStatement(MySqlParser.ResetStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "reset query cache");
    }

    @Override
    public SqlCommentNode visitShutdownStatement(MySqlParser.ShutdownStatementContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "shutdown");
    }
}

