/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.DataTypeVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.DefaultValueVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCheckColumnConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlColumnDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlDataTypeSpec;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.postgresql.util.PGTimestamp;

public class ColumnDefinitionVisitor
extends AbstractVisitor<SqlColumnDefinition> {
    private SqlColumnDefinition columnDefinition = new SqlColumnDefinition();
    private static final Pattern PATTERN_DATETIME = Pattern.compile("^0000-00-00 00:00:00.?0*$");
    private static final Pattern PATTERN_DATE = Pattern.compile("^-00-00|[0-9]*-00|00-[0-9]*$");

    @Override
    protected SqlColumnDefinition defaultResult() {
        return this.columnDefinition;
    }

    @Override
    public SqlColumnDefinition visitColumnDefinition(MySqlParser.ColumnDefinitionContext ctx) {
        this.columnDefinition.setDataType((SqlDataTypeSpec)new DataTypeVisitor().visit((ParseTree)ctx.dataType()));
        if (ctx.columnConstraint() != null && !ctx.columnConstraint().isEmpty()) {
            for (MySqlParser.ColumnConstraintContext c : ctx.columnConstraint()) {
                this.visit((ParseTree)c);
            }
        }
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitNullColumnConstraint(MySqlParser.NullColumnConstraintContext ctx) {
        if (ctx.nullNotnull().NOT() != null) {
            this.defaultResult().setNonNotNon(SqlLiteral.setNonNotNon(false));
        } else {
            this.defaultResult().setNonNotNon(SqlLiteral.setNonNotNon(true));
        }
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitDefaultColumnConstraint(MySqlParser.DefaultColumnConstraintContext ctx) {
        SqlLiteral defaultValue = (SqlLiteral)new DefaultValueVisitor(this.defaultResult().getDefaultValue()).visit((ParseTree)ctx.defaultValue());
        if (defaultValue.getValue() != null) {
            Matcher matcherDateTime = PATTERN_DATETIME.matcher(defaultValue.getValue().toString());
            switch (this.columnDefinition.getDataType().getTypeName().getName().toLowerCase(Locale.ROOT)) {
                case "date": {
                    if (!defaultValue.getValue().equals("0000-00-00")) break;
                    defaultValue.setValue("1970-01-01");
                    break;
                }
                case "datetime": {
                    try {
                        Timestamp t = PGTimestamp.valueOf((String)defaultValue.getValue().toString());
                        defaultValue.setValue(t.toString());
                    }
                    catch (Exception e) {
                        String date;
                        Matcher matcherDate;
                        String dateTime;
                        int index;
                        if (matcherDateTime.find()) {
                            defaultValue.setValue("1970-01-01 00:00:00.0");
                        }
                        if ((index = (dateTime = defaultValue.getValue().toString()).indexOf("-")) < 0) break;
                        int spaceIndex = dateTime.lastIndexOf(32);
                        if (spaceIndex < 0) {
                            spaceIndex = dateTime.length();
                        }
                        if (!(matcherDate = PATTERN_DATE.matcher(date = dateTime.substring(index, spaceIndex))).find()) break;
                        defaultValue.setValue("1970-01-01 00:00:00.0");
                    }
                    break;
                }
                case "timestamp": {
                    if (!matcherDateTime.find()) break;
                    defaultValue.setValue("1970-01-01 00:00:00.0");
                    break;
                }
            }
        }
        this.defaultResult().setDefaultValue(defaultValue);
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitAutoIncrementColumnConstraint(MySqlParser.AutoIncrementColumnConstraintContext ctx) {
        this.defaultResult().setAutoIncrement(true);
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitOnUpdateCurrentTimestampConstraint(MySqlParser.OnUpdateCurrentTimestampConstraintContext ctx) {
        this.defaultResult().setOnUpdateValue(ctx.currentTimestamp().getText());
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitPrimaryKeyColumnConstraint(MySqlParser.PrimaryKeyColumnConstraintContext ctx) {
        this.defaultResult().setPrimaryKey(true);
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitUniqueKeyColumnConstraint(MySqlParser.UniqueKeyColumnConstraintContext ctx) {
        this.defaultResult().setUniquekey(true);
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitCommentColumnConstraint(MySqlParser.CommentColumnConstraintContext ctx) {
        String replaceSingleQuoteInComment = ctx.getText().replace("\\'", "''");
        StringBuilder comment = new StringBuilder(replaceSingleQuoteInComment);
        comment.replace(0, 7, "COMMENT ");
        comment.replace(8, 9, "'");
        comment.replace(comment.length() - 1, comment.length(), "'");
        this.defaultResult().setComment(new SqlLiteral(SqlTypeName.ANY, comment));
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitCheckColumnConstraint(MySqlParser.CheckColumnConstraintContext ctx) {
        SqlCheckColumnConstraint sqlCheckColumnConstraint = new SqlCheckColumnConstraint();
        SqlExpression sqlExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression());
        sqlCheckColumnConstraint.setSqlExpression(sqlExpression);
        this.defaultResult().setSqlCheckColumnConstraint(sqlCheckColumnConstraint);
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitFormatColumnConstraint(MySqlParser.FormatColumnConstraintContext ctx) {
        this.defaultResult().setColumnFormat(ctx.getText());
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitStorageColumnConstraint(MySqlParser.StorageColumnConstraintContext ctx) {
        this.defaultResult().setStorage(ctx.getText());
        return this.defaultResult();
    }

    @Override
    public SqlColumnDefinition visitReferenceColumnConstraint(MySqlParser.ReferenceColumnConstraintContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "references statement");
    }
}

