/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexColumnNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.IndexOptionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCreateIndex;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;

public class CreateIndexVisitor
extends AbstractVisitor<SqlCreateIndex> {
    @Override
    public SqlCreateIndex visitCreateIndex(MySqlParser.CreateIndexContext ctx) {
        SqlCreateIndex index = new SqlCreateIndex();
        if (ctx.indexCategory != null) {
            String category = ctx.indexCategory.getText().toUpperCase(Locale.ROOT);
            index.setSpecialType(SqlCreateIndex.SpecialType.valueOf(category));
        }
        index.setIndexName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
        if (ctx.indexType() != null) {
            index.setIndexType(ctx.indexType().BTREE() == null ? "HASH" : "BTREE");
        }
        index.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)ctx.tableName()));
        SqlNodeList<SqlIndexColumnName> indexColumns = new SqlNodeList<SqlIndexColumnName>();
        for (int i = 0; i < ctx.indexColumnNames().indexColumnName().size(); ++i) {
            indexColumns.addNode((SqlIndexColumnName)((SqlNode)new IndexColumnNameVisitor().visit((ParseTree)ctx.indexColumnNames().indexColumnName(i))));
        }
        index.setIndexColumns(indexColumns);
        if (ctx.indexOption() != null && ctx.indexOption().size() != 0) {
            index.setOptions((SqlIndexOptions)new IndexOptionVisitor().visit((ParseTree)ctx));
        }
        if (ctx.ALGORITHM() != null) {
            index.getOptions().getIndexOptions().put(ctx.ALGORITHM().getText(), ctx.algType.getText());
        }
        if (ctx.LOCK() != null) {
            index.getOptions().getIndexOptions().put(ctx.LOCK().getText(), ctx.lockType.getText());
        }
        return index;
    }

    @Override
    protected SqlCreateIndex defaultResult() {
        return null;
    }
}

