/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlArrayAndMapDataType;
import com.huawei.hwclouds.scs.sql.nodes.SqlDataTypeSpec;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlStructDataType;
import com.huawei.hwclouds.scs.sql.nodes.SqlStructType;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import java.util.ArrayList;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;

public class DataTypeVisitor
extends AbstractVisitor<SqlDataTypeSpec> {
    private SqlDataTypeSpec type = new SqlDataTypeSpec();

    @Override
    protected SqlDataTypeSpec defaultResult() {
        return this.type;
    }

    @Override
    public SqlDataTypeSpec visitStringDataType(MySqlParser.StringDataTypeContext ctx) {
        String typeName = this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US);
        String length = null;
        String specPre = null;
        if (ctx.lengthOneDimension() != null) {
            if (ctx.lengthOneDimension().decimalLiteral().getText().equalsIgnoreCase("max")) {
                specPre = "max";
            } else {
                length = ctx.lengthOneDimension().decimalLiteral().getText();
            }
        }
        boolean binary = ctx.BINARY() != null;
        String charsetName = ctx.charsetName() == null ? null : ctx.charsetName().getText();
        String collate = ctx.collationName() == null ? null : ctx.collationName().getText();
        return SqlDataTypeSpec.constructStringDataType(SqlTypeName.get(typeName), length == null ? null : Long.valueOf(length), binary, charsetName, collate, specPre);
    }

    @Override
    public SqlDataTypeSpec visitLengthOneDimensionDataType(MySqlParser.LengthOneDimensionDataTypeContext ctx) {
        Long precision = null;
        String specPre = null;
        if (ctx.lengthOneDimension() != null) {
            if (ctx.lengthOneDimension().decimalLiteral().getText().equalsIgnoreCase("max")) {
                specPre = "max";
            } else {
                precision = Long.valueOf(ctx.lengthOneDimension().decimalLiteral().getText());
            }
        }
        return SqlDataTypeSpec.oneDimensionDataType(SqlTypeName.get(this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US)), precision, ctx.UNSIGNED() != null, ctx.ZEROFILL() != null, specPre);
    }

    @Override
    public SqlDataTypeSpec visitLengthOneTwoDimensionDataType(MySqlParser.LengthOneTwoDimensionDataTypeContext ctx) {
        Long precision = null;
        Integer scale = null;
        if (ctx.lengthOneDimension() != null) {
            precision = Long.valueOf(ctx.lengthOneDimension().decimalLiteral().getText());
        }
        if (ctx.lengthTwoDimension() != null) {
            precision = Long.valueOf(ctx.lengthTwoDimension().decimalLiteral(0).getText());
            scale = Integer.valueOf(ctx.lengthTwoDimension().decimalLiteral(1).getText());
        }
        return SqlDataTypeSpec.constructNumericDataType(SqlTypeName.get(this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US)), precision, scale, ctx.UNSIGNED() != null, ctx.ZEROFILL() != null);
    }

    @Override
    public SqlDataTypeSpec visitLengthDoublePrecisionDataType(MySqlParser.LengthDoublePrecisionDataTypeContext ctx) {
        Long precision = null;
        Integer scale = null;
        if (ctx.lengthTwoDimension() != null) {
            precision = Long.valueOf(ctx.lengthTwoDimension().decimalLiteral(0).getText());
            scale = Integer.valueOf(ctx.lengthTwoDimension().decimalLiteral(1).getText());
        }
        return SqlDataTypeSpec.constructNumericDataType(SqlTypeName.get(this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US)), precision, scale, ctx.UNSIGNED() != null, ctx.ZEROFILL() != null);
    }

    @Override
    public SqlDataTypeSpec visitLengthTwoOptionalDimensionDataType(MySqlParser.LengthTwoOptionalDimensionDataTypeContext ctx) {
        Long precision = null;
        Integer scale = null;
        if (ctx.lengthOneDimension() != null) {
            precision = Long.valueOf(ctx.lengthOneDimension().decimalLiteral().getText());
        }
        if (ctx.lengthTwoOptionalDimension() != null) {
            precision = Long.valueOf(ctx.lengthTwoOptionalDimension().decimalLiteral(0).getText());
            scale = Integer.valueOf(ctx.lengthTwoOptionalDimension().decimalLiteral(1).getText());
        }
        return SqlDataTypeSpec.constructNumericDataType(SqlTypeName.get(this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US)), precision, scale, ctx.UNSIGNED() != null, ctx.ZEROFILL() != null);
    }

    @Override
    public SqlDataTypeSpec visitSimpleDataType(MySqlParser.SimpleDataTypeContext ctx) {
        String typeName = this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US);
        return SqlDataTypeSpec.simpleDataType(SqlTypeName.get(typeName));
    }

    @Override
    public SqlDataTypeSpec visitBlobSimpleDataType(MySqlParser.BlobSimpleDataTypeContext ctx) {
        Long precision = null;
        if (ctx.lengthOneDimension() != null) {
            precision = Long.valueOf(ctx.lengthOneDimension().decimalLiteral().getText());
        }
        return SqlDataTypeSpec.blobSimpleDataType(SqlTypeName.get(this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US)), precision);
    }

    @Override
    public SqlDataTypeSpec visitCollectionDataType(MySqlParser.CollectionDataTypeContext ctx) {
        String typeName = this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US);
        boolean binary = ctx.BINARY() != null;
        String charset = ctx.charSet() == null ? null : ctx.charSet().getText();
        String collate = ctx.COLLATE() == null ? null : ctx.COLLATE().getText();
        ArrayList<String> literalList = new ArrayList<String>();
        if (ctx.STRING_LITERAL() != null) {
            for (int i = 0; i < ctx.STRING_LITERAL().size(); ++i) {
                String literal = String.valueOf(ctx.STRING_LITERAL(i));
                literalList.add(literal);
            }
        }
        return SqlDataTypeSpec.constructCollectionDataType(SqlTypeName.get(typeName), literalList, binary, charset, collate);
    }

    @Override
    public SqlDataTypeSpec visitSpatialDataType(MySqlParser.SpatialDataTypeContext ctx) {
        String typeName = this.getTypeName(ctx.typeName.getText()).toUpperCase(Locale.US);
        return SqlDataTypeSpec.spatialDataType(SqlTypeName.get(typeName));
    }

    @Override
    public SqlDataTypeSpec visitComplexDataType(MySqlParser.ComplexDataTypeContext ctx) {
        SqlArrayAndMapDataType sqlArrayAndMapDataType = new SqlArrayAndMapDataType();
        if (ctx.ARRAY() != null) {
            sqlArrayAndMapDataType.setTypeName(SqlTypeName.ARRAY);
        } else {
            sqlArrayAndMapDataType.setTypeName(SqlTypeName.MAP);
            sqlArrayAndMapDataType.setValueType((SqlDataTypeSpec)new DataTypeVisitor().visit((ParseTree)ctx.valueType));
        }
        sqlArrayAndMapDataType.setKeyType((SqlDataTypeSpec)new DataTypeVisitor().visit((ParseTree)ctx.keyType));
        return SqlDataTypeSpec.complexDataType(sqlArrayAndMapDataType);
    }

    @Override
    public SqlDataTypeSpec visitStructDataType(MySqlParser.StructDataTypeContext ctx) {
        SqlDataTypeSpec sqlDataTypeSpec = new SqlDataTypeSpec();
        sqlDataTypeSpec.setOriTypeName(SqlTypeName.STRUCT);
        sqlDataTypeSpec.setTypeName(SqlTypeName.STRUCT);
        SqlStructDataType structDataType = new SqlStructDataType();
        SqlNodeList<SqlStructType> sqlStructTypeSqlNodeList = new SqlNodeList<SqlStructType>();
        for (int i = 0; i < ctx.structType().size(); ++i) {
            SqlStructType sqlStructType = new SqlStructType();
            sqlStructType.setUid(ctx.structType().get(i).uid().getText());
            sqlStructType.setDataType((SqlDataTypeSpec)new DataTypeVisitor().visit((ParseTree)ctx.structType().get(i).dataType()));
            sqlStructTypeSqlNodeList.addNode(sqlStructType);
        }
        structDataType.setSqlStructTypeSqlNodeList(sqlStructTypeSqlNodeList);
        sqlDataTypeSpec.setStructDataType(structDataType);
        return sqlDataTypeSpec;
    }

    public String getTypeName(String ctx) {
        return ctx.replace(" ", "");
    }
}

