/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.math.BigDecimal;
import org.antlr.v4.runtime.tree.ParseTree;

public class DefaultValueVisitor
extends AbstractVisitor<SqlLiteral> {
    private SqlLiteral defaultValue = null;

    public DefaultValueVisitor() {
        this((SqlLiteral)null);
    }

    public DefaultValueVisitor(SqlLiteral defaultValue) {
        this.defaultValue = defaultValue == null ? new SqlLiteral(null, null) : defaultValue;
    }

    @Override
    protected SqlLiteral defaultResult() {
        return null;
    }

    @Override
    public SqlLiteral visitDefaultValue(MySqlParser.DefaultValueContext ctx) {
        if (ctx.NULL_LITERAL() != null) {
            this.defaultValue.setType(SqlTypeName.UNKOWN);
            this.defaultValue.setValue(null);
            return this.defaultValue;
        }
        if (ctx.constant() != null) {
            this.setAttributes(ctx);
            return this.defaultValue;
        }
        if (ctx.expression() != null) {
            SqlExpression visit = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression());
            this.defaultValue.setType(SqlTypeName.ANY);
            this.defaultValue.setValue(visit);
            this.defaultValue.setExpression(true);
            return this.defaultValue;
        }
        if (ctx.currentTimestamp() != null && ctx.currentTimestamp().CURRENT_DATE() != null) {
            this.defaultValue.setType(SqlTypeName.ANY);
            this.defaultValue.setValue("CURRENT_DATE");
            return this.defaultValue;
        }
        this.defaultValue.setType(SqlTypeName.ANY);
        this.defaultValue.setValue("CURRENT_TIMESTAMP");
        return this.defaultValue;
    }

    private SqlLiteral setAttributes(MySqlParser.DefaultValueContext ctx) {
        if (ctx.constant().stringLiteral() != null) {
            this.defaultValue.setType(SqlTypeName.VARCHAR);
            this.defaultValue.setValue(QuoteUtils.removeSingleQuote(ctx.constant().stringLiteral().getText()));
            return this.defaultValue;
        }
        if (ctx.constant().decimalLiteral() != null) {
            this.defaultValue.setType(SqlTypeName.DECIMAL);
            this.defaultValue.setValue(new BigDecimal(ctx.getText()));
            return this.defaultValue;
        }
        if (ctx.constant().hexadecimalLiteral() != null) {
            this.defaultValue.setType(SqlTypeName.DECIMAL);
            this.defaultValue.setValue(new BigDecimal(ctx.constant().hexadecimalLiteral().getText()));
            return this.defaultValue;
        }
        if (ctx.constant().booleanLiteral() != null) {
            this.defaultValue.setType(SqlTypeName.BOOLEAN);
            this.defaultValue.setValue(Boolean.valueOf(ctx.constant().booleanLiteral().getText()));
            return this.defaultValue;
        }
        if (ctx.constant().REAL_LITERAL() != null) {
            this.defaultValue.setType(SqlTypeName.REAL);
            this.defaultValue.setValue(ctx.constant().REAL_LITERAL().getText());
            return this.defaultValue;
        }
        if (ctx.constant().BIT_STRING() != null) {
            this.defaultValue.setType(SqlTypeName.BIT);
            this.defaultValue.setValue(ctx.constant().BIT_STRING().getText());
            this.defaultValue.setSpecialType(true);
            return this.defaultValue;
        }
        return this.defaultValue;
    }
}

