/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.entity.PlaceHolderParam;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.FunctionCallVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ParenthesisSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SimpleSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableStatementVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlBinaryExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlCollateExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlConstantExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlExistsAndSubQueryExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCallExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlIntervalExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlMathExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlNestedAndCheckRowExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlOpExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlParenthesisSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSimpleSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlStringLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlUnaryExpressionAtom;
import com.huawei.hwclouds.scs.sql.util.UidInKeyWord;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpressionAtomVisitor
extends AbstractVisitor<SqlExpressionAtom> {
    private static final Logger LOGGER = LogManager.getLogger(ExpressionAtomVisitor.class);
    protected SqlExpressionAtom sqlExpressionAtom = new SqlExpressionAtom();

    @Override
    public SqlExpressionAtom defaultResult() {
        return this.sqlExpressionAtom;
    }

    @Override
    public SqlExpressionAtom visitConstantExpressionAtom(MySqlParser.ConstantExpressionAtomContext ctx) {
        SqlConstantExpressionAtom sqlConstantExpressionAtom = new SqlConstantExpressionAtom();
        SqlStringLiteral sqlStringLiteral = new SqlStringLiteral();
        if (ctx.constant().stringLiteral() != null) {
            MySqlParser.StringLiteralContext stringLiteralContext = ctx.constant().stringLiteral();
            this.getStringLiteral(stringLiteralContext, sqlStringLiteral);
        } else {
            sqlStringLiteral.setLiteral(ctx.constant().getText());
        }
        sqlConstantExpressionAtom.setLiteral(sqlStringLiteral);
        sqlConstantExpressionAtom.setIfHaveNot(ctx.constant().NOT() != null);
        this.sqlExpressionAtom.setSqlConstantExpressionAtom(sqlConstantExpressionAtom);
        return this.defaultResult();
    }

    private void getStringLiteral(MySqlParser.StringLiteralContext ctx, SqlStringLiteral sqlStringLiteral) {
        StringBuilder strLiteral = new StringBuilder();
        if (ctx.strFir != null) {
            if (ctx.STRING_CHARSET_NAME() != null) {
                strLiteral.append(ctx.STRING_CHARSET_NAME().getText());
            }
            strLiteral.append(ctx.strFir.getText());
        } else {
            strLiteral.append(ctx.START_NATIONAL_STRING_LITERAL().getText());
        }
        for (int i = 0; i < ctx.strSec().size(); ++i) {
            strLiteral.append(ctx.strSec().get(i).getText());
        }
        sqlStringLiteral.setLiteral(strLiteral.toString());
        if (ctx.collationName() != null) {
            sqlStringLiteral.setCollationName(ctx.collationName().getText());
        }
    }

    @Override
    public SqlExpressionAtom visitFullColumnNameExpressionAtom(MySqlParser.FullColumnNameExpressionAtomContext ctx) {
        String fullColumnNameText = UidInKeyWord.getUid(ctx.fullColumnName().getText());
        if (!this.parsePlaceHolder(ctx.fullColumnName(), this.sqlExpressionAtom, fullColumnNameText)) {
            this.sqlExpressionAtom.setFullColumnName(fullColumnNameText);
        }
        return this.defaultResult();
    }

    private boolean parsePlaceHolder(MySqlParser.FullColumnNameContext ctx, SqlExpressionAtom sqlExpressionAtom, String fullColumnNameText) {
        String identifier;
        if (ctx.uid() != null && ctx.uid().simpleId() != null && ctx.uid().simpleId().namedPlaceHolder() != null) {
            identifier = ctx.uid().simpleId().namedPlaceHolder().ID().getText();
        } else if (fullColumnNameText.startsWith("$")) {
            identifier = fullColumnNameText.substring(1);
        } else {
            return false;
        }
        PlaceHolderParam placeHolderParam = MigrationContextUtil.getPlaceHolderParam();
        Map<String, String> placeHolderMap = placeHolderParam.getPlaceHolderMap();
        String placeHolderFormat = placeHolderParam.getPlaceHolderFormat();
        int index = placeHolderMap.size();
        sqlExpressionAtom.setFullColumnName(":" + index);
        if (placeHolderFormat != null && !placeHolderFormat.isEmpty()) {
            placeHolderMap.put(String.valueOf(index), String.format(placeHolderFormat, identifier));
        } else {
            placeHolderMap.put(String.valueOf(index), fullColumnNameText);
        }
        return true;
    }

    @Override
    public SqlExpressionAtom visitFunctionCallExpressionAtom(MySqlParser.FunctionCallExpressionAtomContext ctx) {
        SqlFunctionCallExpressionAtom sqlFunctionCallExpressionAtom = new SqlFunctionCallExpressionAtom();
        SqlFunctionCall sqlFunctionCall = (SqlFunctionCall)new FunctionCallVisitor().visit((ParseTree)ctx.functionCall());
        sqlFunctionCallExpressionAtom.setSqlFunctionCall(sqlFunctionCall);
        this.sqlExpressionAtom.setSqlFunctionCallExpressionAtom(sqlFunctionCallExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitCollateExpressionAtom(MySqlParser.CollateExpressionAtomContext ctx) {
        SqlCollateExpressionAtom sqlCollateExpressionAtom = new SqlCollateExpressionAtom();
        SqlExpressionAtom expressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.expressionAtom());
        sqlCollateExpressionAtom.setSqlExpressionAtom(expressionAtom);
        sqlCollateExpressionAtom.setCollationName(ctx.collationName().getText());
        this.sqlExpressionAtom.setSqlCollateExpressionAtom(sqlCollateExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitMysqlVariableExpressionAtom(MySqlParser.MysqlVariableExpressionAtomContext ctx) {
        this.sqlExpressionAtom.setMysqlVariable(ctx.getText());
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitUnaryExpressionAtom(MySqlParser.UnaryExpressionAtomContext ctx) {
        SqlUnaryExpressionAtom sqlUnaryExpressionAtom = new SqlUnaryExpressionAtom();
        sqlUnaryExpressionAtom.setUnaryOperator(ctx.unaryOperator().getText());
        SqlExpressionAtom expressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.expressionAtom());
        sqlUnaryExpressionAtom.setSqlExpressionAtom(expressionAtom);
        this.sqlExpressionAtom.setSqlUnaryExpressionAtom(sqlUnaryExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitBinaryExpressionAtom(MySqlParser.BinaryExpressionAtomContext ctx) {
        SqlBinaryExpressionAtom sqlBinaryExpressionAtom = new SqlBinaryExpressionAtom();
        SqlExpressionAtom expressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.expressionAtom());
        sqlBinaryExpressionAtom.setKeywords(ctx.BINARY().getText());
        sqlBinaryExpressionAtom.setSqlExpressionAtom(expressionAtom);
        this.sqlExpressionAtom.setSqlBinaryExpressionAtom(sqlBinaryExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitNestedExpressionAtom(MySqlParser.NestedExpressionAtomContext ctx) {
        SqlNestedAndCheckRowExpressionAtom sqlNestedAndCheckRowExpressionAtom = new SqlNestedAndCheckRowExpressionAtom();
        SqlNodeList<SqlExpression> sqlExpressionSqlNodeList = new SqlNodeList<SqlExpression>();
        for (int i = 0; i < ctx.expression().size(); ++i) {
            SqlExpression expression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression(i));
            sqlExpressionSqlNodeList.addNode(expression);
        }
        sqlNestedAndCheckRowExpressionAtom.setSqlExpressionSqlNodeList(sqlExpressionSqlNodeList);
        this.sqlExpressionAtom.setSqlNestedAndCheckRowExpressionAtom(sqlNestedAndCheckRowExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitNestedRowExpressionAtom(MySqlParser.NestedRowExpressionAtomContext ctx) {
        SqlNestedAndCheckRowExpressionAtom sqlNestedAndCheckRowExpressionAtom = new SqlNestedAndCheckRowExpressionAtom();
        SqlNodeList<SqlExpression> sqlExpressionSqlNodeList = new SqlNodeList<SqlExpression>();
        for (int i = 0; i < ctx.expression().size(); ++i) {
            SqlExpression expression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression(i));
            sqlExpressionSqlNodeList.addNode(expression);
        }
        sqlNestedAndCheckRowExpressionAtom.setSqlExpressionSqlNodeList(sqlExpressionSqlNodeList);
        sqlNestedAndCheckRowExpressionAtom.setKeywords(ctx.ROW().getText());
        this.sqlExpressionAtom.setSqlNestedAndCheckRowExpressionAtom(sqlNestedAndCheckRowExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitExistsExpressionAtom(MySqlParser.ExistsExpressionAtomContext ctx) {
        SqlExistsAndSubQueryExpressionAtom sqlExistsAndSubQueryExpressionAtom = new SqlExistsAndSubQueryExpressionAtom();
        if (ctx.selectStatement() != null) {
            String ctxTypeName;
            SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
            int index = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().indexOf("$");
            switch (ctxTypeName = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().substring(index + 1)) {
                case "SimpleSelectContext": {
                    SqlSimpleSelect sqlSimpleSelect = (SqlSimpleSelect)new SimpleSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlSimpleSelect(sqlSimpleSelect);
                    break;
                }
                case "ParenthesisSelectContext": {
                    SqlParenthesisSelect sqlParenthesisSelect = (SqlParenthesisSelect)new ParenthesisSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlParenthesisSelect(sqlParenthesisSelect);
                    break;
                }
                default: {
                    LOGGER.error("Not supported other select statement");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "(collection select)");
                }
            }
            sqlExistsAndSubQueryExpressionAtom.setSqlSelectStatement(sqlSelectStatement);
        } else if (ctx.tableStatement() != null) {
            sqlExistsAndSubQueryExpressionAtom.setSqlTableElement((SqlTableElement)new TableStatementVisitor().visit((ParseTree)ctx.tableStatement()));
        }
        sqlExistsAndSubQueryExpressionAtom.setKeywords(ctx.EXISTS().getText());
        this.sqlExpressionAtom.setSqlExistsAndSubQueryExpressionAtom(sqlExistsAndSubQueryExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitSubqueryExpressionAtom(MySqlParser.SubqueryExpressionAtomContext ctx) {
        String ctxTypeName;
        SqlExistsAndSubQueryExpressionAtom sqlExistsAndSubQueryExpressionAtom = new SqlExistsAndSubQueryExpressionAtom();
        SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
        int index = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().indexOf("$");
        switch (ctxTypeName = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().substring(index + 1)) {
            case "SimpleSelectContext": {
                SqlSimpleSelect sqlSimpleSelect = (SqlSimpleSelect)new SimpleSelectVisitor().visit((ParseTree)ctx.selectStatement());
                sqlSelectStatement.setSqlSimpleSelect(sqlSimpleSelect);
                break;
            }
            case "ParenthesisSelectContext": {
                SqlParenthesisSelect sqlParenthesisSelect = (SqlParenthesisSelect)new ParenthesisSelectVisitor().visit((ParseTree)ctx.selectStatement());
                sqlSelectStatement.setSqlParenthesisSelect(sqlParenthesisSelect);
                break;
            }
            default: {
                LOGGER.error("Not supported other select statement");
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "(collection select)");
            }
        }
        sqlExistsAndSubQueryExpressionAtom.setSqlSelectStatement(sqlSelectStatement);
        this.sqlExpressionAtom.setSqlExistsAndSubQueryExpressionAtom(sqlExistsAndSubQueryExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitIntervalExpressionAtom(MySqlParser.IntervalExpressionAtomContext ctx) {
        SqlIntervalExpressionAtom sqlIntervalExpressionAtom = new SqlIntervalExpressionAtom();
        SqlExpression expression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression());
        if (ctx.INTERVAL() != null) {
            sqlIntervalExpressionAtom.setKeywords(ctx.INTERVAL().getText());
        }
        sqlIntervalExpressionAtom.setSqlExpression(expression);
        sqlIntervalExpressionAtom.setIntervalType(ctx.intervalType().getText());
        this.sqlExpressionAtom.setSqlIntervalExpressionAtom(sqlIntervalExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitBitExpressionAtom(MySqlParser.BitExpressionAtomContext ctx) {
        SqlOpExpressionAtom sqlOpExpressionAtom = new SqlOpExpressionAtom();
        SqlExpressionAtom leftExpressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.left);
        sqlOpExpressionAtom.setOp(ctx.bitOperator().getText());
        SqlExpressionAtom rightExpressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.right);
        sqlOpExpressionAtom.setFrontExpressionAtom(leftExpressionAtom);
        sqlOpExpressionAtom.setBehindExpressionAtom(rightExpressionAtom);
        this.sqlExpressionAtom.setSqlOpExpressionAtom(sqlOpExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitMathExpressionAtom(MySqlParser.MathExpressionAtomContext ctx) {
        SqlMathExpressionAtom sqlMathExpressionAtom = new SqlMathExpressionAtom();
        SqlExpressionAtom left = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.left);
        sqlMathExpressionAtom.setMathOperator(ctx.mathOperator().getText());
        SqlExpressionAtom right = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.right);
        sqlMathExpressionAtom.setLeft(left);
        sqlMathExpressionAtom.setRight(right);
        this.sqlExpressionAtom.setSqlMathExpressionAtom(sqlMathExpressionAtom);
        return this.defaultResult();
    }

    @Override
    public SqlExpressionAtom visitJsonExpressionAtom(MySqlParser.JsonExpressionAtomContext ctx) {
        SqlOpExpressionAtom sqlOpExpressionAtom = new SqlOpExpressionAtom();
        SqlExpressionAtom leftExpressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.left);
        sqlOpExpressionAtom.setOp(ctx.jsonOperator().getText());
        SqlExpressionAtom rightExpressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.right);
        sqlOpExpressionAtom.setFrontExpressionAtom(leftExpressionAtom);
        sqlOpExpressionAtom.setBehindExpressionAtom(rightExpressionAtom);
        sqlOpExpressionAtom.setExpressionType("json");
        this.sqlExpressionAtom.setSqlOpExpressionAtom(sqlOpExpressionAtom);
        return this.defaultResult();
    }
}

