/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.FunctionCallVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArg;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArgs;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.util.UidInKeyWord;

public class FunctionArgsVisitor
extends AbstractVisitor<SqlFunctionArgs> {
    private SqlFunctionArgs sqlFunctionArgs = new SqlFunctionArgs();

    @Override
    protected SqlFunctionArgs defaultResult() {
        return this.sqlFunctionArgs;
    }

    @Override
    public SqlFunctionArgs visitFunctionArgs(MySqlParser.FunctionArgsContext ctx) {
        SqlNodeList<SqlFunctionArg> list = new SqlNodeList<SqlFunctionArg>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            SqlFunctionArg sqlFunctionArg = new SqlFunctionArg();
            if (ctx.getChild(i) instanceof MySqlParser.ConstantContext) {
                sqlFunctionArg.setConstantUid(ctx.getChild(i).getText());
                list.addNode(sqlFunctionArg);
                continue;
            }
            if (ctx.getChild(i) instanceof MySqlParser.FullColumnNameContext) {
                sqlFunctionArg.setFullColumnName(UidInKeyWord.getUid(ctx.getChild(i).getText()));
                list.addNode(sqlFunctionArg);
                continue;
            }
            if (ctx.getChild(i) instanceof MySqlParser.FunctionCallContext) {
                SqlFunctionCall sqlFunctionCall = (SqlFunctionCall)new FunctionCallVisitor().visit(ctx.getChild(i));
                sqlFunctionArg.setSqlFunctionCall(sqlFunctionCall);
                list.addNode(sqlFunctionArg);
                continue;
            }
            if (ctx.getChild(i) instanceof MySqlParser.ExpressionContext) {
                ExpressionVisitor visitor = new ExpressionVisitor();
                SqlExpression sqlExpression = (SqlExpression)visitor.visit(ctx.getChild(i));
                sqlFunctionArg.setSqlExpression(sqlExpression);
                list.addNode(sqlFunctionArg);
                continue;
            }
            if (!(ctx.getChild(i) instanceof MySqlParser.ComplexContext)) continue;
            if (((MySqlParser.ComplexContext)ctx.getChild(i)).dataTypeBase().DATETIME() != null) {
                sqlFunctionArg.setComplex("timestamp" + ((MySqlParser.ComplexContext)ctx.getChild(i)).constant().getText());
                sqlFunctionArg.setConvertDateFormat(true);
            } else if (((MySqlParser.ComplexContext)ctx.getChild(i)).dataTypeBase().DATE() != null || ((MySqlParser.ComplexContext)ctx.getChild(i)).dataTypeBase().TIMESTAMP() != null) {
                sqlFunctionArg.setComplex(ctx.getChild(i).getText());
                sqlFunctionArg.setConvertDateFormat(true);
            } else {
                sqlFunctionArg.setComplex(ctx.getChild(i).getText());
            }
            list.addNode(sqlFunctionArg);
        }
        this.sqlFunctionArgs.setSqlFunctionArgSqlNodeList(list);
        return this.defaultResult();
    }
}

