/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlIndexColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlLiteral;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import org.antlr.v4.runtime.tree.ParseTree;

public class IndexColumnNameVisitor
extends AbstractVisitor<SqlIndexColumnName> {
    @Override
    protected SqlIndexColumnName defaultResult() {
        return null;
    }

    @Override
    public SqlIndexColumnName visitIndexColumnName(MySqlParser.IndexColumnNameContext ctx) {
        SqlIndexColumnName indexColumnName = new SqlIndexColumnName();
        if (ctx.uid() != null) {
            indexColumnName.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
            if (ctx.decimalLiteral() != null) {
                indexColumnName.setPrecision(new SqlLiteral(SqlTypeName.INTEGER, QuoteUtils.removeSingleQuote(ctx.decimalLiteral().getText())));
            }
        } else if (ctx.expression() != null) {
            indexColumnName.setExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        }
        if (ctx.sortType != null) {
            indexColumnName.setSortType(ctx.ASC() != null ? SqlIndexColumnName.SortType.ASC : SqlIndexColumnName.SortType.DESC);
        }
        return indexColumnName;
    }

    public SqlIndexColumnName visitIndexColumnNameIsConstraint(MySqlParser.IndexColumnNameContext ctx, boolean isConstraint) {
        SqlIndexColumnName indexColumnName = new SqlIndexColumnName();
        if (ctx.uid() != null) {
            indexColumnName.setColumnName(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid().getText()), false));
            if (ctx.decimalLiteral() != null) {
                indexColumnName.setPrecision(new SqlLiteral(SqlTypeName.INTEGER, QuoteUtils.removeSingleQuote(ctx.decimalLiteral().getText())));
            }
        } else if (ctx.expression() != null) {
            indexColumnName.setExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        }
        if (ctx.sortType != null && !isConstraint) {
            indexColumnName.setSortType(ctx.ASC() != null ? SqlIndexColumnName.SortType.ASC : SqlIndexColumnName.SortType.DESC);
        }
        return indexColumnName;
    }
}

