/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.CollectionSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ParenthesisSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SimpleSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableStatementVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCollectionSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlFullColumnName;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlInsertReplaceStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlParenthesisSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlSimpleSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlUpdatedElement;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InsertReplaceStatementVisitor
extends AbstractVisitor<SqlInsertReplaceStatement> {
    private static final Logger LOGGER = LogManager.getLogger(InsertReplaceStatementVisitor.class);
    private SqlInsertReplaceStatement insert = new SqlInsertReplaceStatement();
    private List<MySqlParser.UidContext> columnNameContexts = new ArrayList<MySqlParser.UidContext>();

    @Override
    protected SqlInsertReplaceStatement defaultResult() {
        return this.insert;
    }

    @Override
    public SqlInsertReplaceStatement visitTableName(MySqlParser.TableNameContext ctx) {
        this.insert.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)ctx));
        this.visitComment(this.insert.getTableName(), ctx, CommentPosition.POST);
        return this.defaultResult();
    }

    @Override
    public SqlInsertReplaceStatement visitUidList(MySqlParser.UidListContext ctx) {
        ParserRuleContext parent;
        boolean ispartition = false;
        if (ctx.parent instanceof MySqlParser.InsertStatementContext) {
            parent = (MySqlParser.InsertStatementContext)ctx.parent;
            ispartition = ctx == parent.partitions;
        } else if (ctx.parent instanceof MySqlParser.ReplaceStatementContext) {
            parent = (MySqlParser.ReplaceStatementContext)ctx.parent;
            boolean bl = ispartition = ctx == parent.partitions;
        }
        if (!ispartition) {
            this.columnNameContexts.addAll(ctx.uid());
            SqlNodeList<SqlFullColumnName> uidList = new SqlNodeList<SqlFullColumnName>();
            for (int i = 0; i < ctx.uid().size(); ++i) {
                SqlNodeList<SqlIdentifier> names = new SqlNodeList<SqlIdentifier>();
                names.addNode(new SqlIdentifier(QuoteUtils.removeQuote(ctx.uid(i).getText()), false));
                SqlFullColumnName columnName = new SqlFullColumnName();
                columnName.setNames(names);
                this.visitComment(columnName, ctx.uid(i), CommentPosition.INLIST);
                uidList.addNode(columnName);
            }
            this.insert.setParameterList(uidList);
        }
        return this.defaultResult();
    }

    @Override
    public SqlInsertReplaceStatement visitInsertStatementValue(MySqlParser.InsertStatementValueContext ctx) {
        MySqlParser.SelectStatementContext selectStatementContext = ctx.selectStatement();
        if (selectStatementContext instanceof MySqlParser.SimpleSelectContext) {
            this.insert.setSqlSimpleSelect((SqlSimpleSelect)new SimpleSelectVisitor().visit((ParseTree)selectStatementContext));
        } else if (selectStatementContext instanceof MySqlParser.ParenthesisSelectContext) {
            this.insert.setSqlParenthesisSelect((SqlParenthesisSelect)new ParenthesisSelectVisitor().visit((ParseTree)selectStatementContext));
        } else if (selectStatementContext instanceof MySqlParser.CollectionSelectContext) {
            this.insert.setSqlCollectionSelect((SqlCollectionSelect)new CollectionSelectVisitor().visit((ParseTree)selectStatementContext));
        }
        if (ctx.tableStatement() != null) {
            this.insert.setSqlTableElement((SqlTableElement)new TableStatementVisitor().visit((ParseTree)ctx.tableStatement()));
        }
        if (ctx.AS() != null) {
            this.insert.setHavingAs(true);
        }
        SqlNodeList<SqlNodeList<SqlUpdatedElement>> multiSqlNodeList = new SqlNodeList<SqlNodeList<SqlUpdatedElement>>();
        List<List<MySqlParser.ExpressionOrDefaultContext>> multiValues = this.getExpressionMultiValues(ctx);
        for (List<MySqlParser.ExpressionOrDefaultContext> values : multiValues) {
            if (!this.columnNameContexts.isEmpty() && values.size() % this.columnNameContexts.size() != 0) {
                throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "inconsistent number of values and columns");
            }
            SqlNodeList<SqlUpdatedElement> updatedElements = new SqlNodeList<SqlUpdatedElement>();
            for (int i = 0; i < values.size(); ++i) {
                SqlUpdatedElement updatedElement = new SqlUpdatedElement();
                if (!this.columnNameContexts.isEmpty()) {
                    this.setColumnsNames(this.columnNameContexts.get(i), updatedElement);
                    this.visitComment(updatedElement, this.columnNameContexts.get(i), CommentPosition.INLIST);
                }
                this.setInsertColumnValue(values.get(i), updatedElement);
                updatedElements.addNode(updatedElement);
            }
            multiSqlNodeList.addNode(updatedElements);
        }
        this.insert.setSqlUpdatedElement(multiSqlNodeList);
        return this.defaultResult();
    }

    @Override
    public SqlInsertReplaceStatement visitUpdatedElement(MySqlParser.UpdatedElementContext ctx) {
        boolean duplicate = false;
        if (ctx.parent instanceof MySqlParser.InsertStatementContext) {
            MySqlParser.InsertStatementContext parent = (MySqlParser.InsertStatementContext)ctx.parent;
            if (ctx == parent.duplicatedFirst) {
                duplicate = true;
            }
            if (!duplicate && parent.duplicatedElements != null) {
                Optional<MySqlParser.UpdatedElementContext> op = parent.duplicatedElements.stream().filter(element -> element == ctx).findAny();
                duplicate = op.isPresent();
            }
        }
        if (duplicate) {
            this.insert.getSqlDuplicateUpdatedElement().addNode(this.parseUpdateElement(ctx));
        } else {
            SqlNodeList<SqlUpdatedElement> nodeList = new SqlNodeList<SqlUpdatedElement>();
            nodeList.addNode(this.parseUpdateElement(ctx));
            this.insert.getSqlUpdatedElement().addNode(nodeList);
            this.insert.setSqlUpdatedElement(this.combineUpdateElements(this.insert.getSqlUpdatedElement()));
        }
        return this.defaultResult();
    }

    private SqlNodeList<SqlNodeList<SqlUpdatedElement>> combineUpdateElements(SqlNodeList<SqlNodeList<SqlUpdatedElement>> updateElements) {
        SqlNodeList<SqlNodeList<SqlUpdatedElement>> resElement = new SqlNodeList<SqlNodeList<SqlUpdatedElement>>();
        SqlNodeList<SqlUpdatedElement> res = new SqlNodeList<SqlUpdatedElement>();
        for (SqlNodeList<SqlUpdatedElement> es : updateElements.getNodes()) {
            for (SqlUpdatedElement e : es.getNodes()) {
                res.addNode(e);
            }
        }
        resElement.addNode(res);
        return resElement;
    }

    @Override
    public SqlInsertReplaceStatement visitInsertStatement(MySqlParser.InsertStatementContext ctx) {
        LOGGER.info("visitInsertToTable enter ");
        if (ctx.IGNORE() != null) {
            this.insert.setDuplicationPriority(SqlInsertReplaceStatement.DuplicationPriority.IGNORE);
        }
        if (ctx.OVERWRITE() != null) {
            this.insert.setDuplicationPriority(SqlInsertReplaceStatement.DuplicationPriority.OVERWRITE);
        }
        if (ctx.HIGH_PRIORITY() != null) {
            this.insert.setDuplicationPriority(SqlInsertReplaceStatement.DuplicationPriority.HIGH_PRIORITY);
        }
        if (ctx.LOW_PRIORITY() != null) {
            this.insert.setDuplicationPriority(SqlInsertReplaceStatement.DuplicationPriority.LOW_PRIORITY);
        }
        if (ctx.AS() != null) {
            this.insert.setHavingAs(true);
        }
        if (ctx.DUPLICATE() != null) {
            this.insert.setHavingDuplicate(true);
        }
        this.visitChildren((RuleNode)ctx);
        return this.defaultResult();
    }

    @Override
    public SqlInsertReplaceStatement visitReplaceStatement(MySqlParser.ReplaceStatementContext ctx) {
        LOGGER.info("visitInsertToTable enter ");
        if (ctx.LOW_PRIORITY() != null) {
            this.insert.setDuplicationPriority(SqlInsertReplaceStatement.DuplicationPriority.LOW_PRIORITY);
        }
        this.visitChildren((RuleNode)ctx);
        return this.defaultResult();
    }

    private void setInsertColumnValue(MySqlParser.ExpressionOrDefaultContext context, SqlUpdatedElement updatedElement) {
        if (context.DEFAULT() != null) {
            updatedElement.setUseDefault(true);
        } else {
            ExpressionVisitor expressionVisitor = new ExpressionVisitor();
            SqlExpression sqlExpression = (SqlExpression)expressionVisitor.visit((ParseTree)context.expression());
            updatedElement.setSqlExpression(sqlExpression);
        }
    }

    private void setColumnsNames(MySqlParser.UidContext columnNameConext, SqlUpdatedElement updatedElement) {
        SqlNodeList<SqlIdentifier> names = new SqlNodeList<SqlIdentifier>();
        names.addNode(new SqlIdentifier(QuoteUtils.removeQuote(columnNameConext.getText()), false));
        SqlFullColumnName columnName = new SqlFullColumnName();
        columnName.setNames(names);
        updatedElement.setColumnName(columnName);
    }

    private List<List<MySqlParser.ExpressionOrDefaultContext>> getExpressionMultiValues(MySqlParser.InsertStatementValueContext insertStatementValueContexts) {
        ArrayList<List<MySqlParser.ExpressionOrDefaultContext>> arrays = new ArrayList<List<MySqlParser.ExpressionOrDefaultContext>>();
        for (MySqlParser.ExpressionsWithDefaultsContext expressionsWithDefault : insertStatementValueContexts.expressionsWithDefaults()) {
            arrays.add(expressionsWithDefault.expressionOrDefault().stream().collect(Collectors.toList()));
        }
        return arrays;
    }

    private SqlUpdatedElement parseUpdateElement(MySqlParser.UpdatedElementContext updatedElementContext) {
        SqlUpdatedElement updatedElement = new SqlUpdatedElement();
        SqlNodeList<SqlIdentifier> names = new SqlNodeList<SqlIdentifier>();
        if (updatedElementContext.fullColumnName().uid() != null) {
            names.addNode(new SqlIdentifier(QuoteUtils.removeQuote(updatedElementContext.fullColumnName().uid().getText()), false));
        }
        if (updatedElementContext.fullColumnName().dottedId() != null) {
            for (MySqlParser.DottedIdContext dottedId : updatedElementContext.fullColumnName().dottedId()) {
                names.addNode(new SqlIdentifier(QuoteUtils.removeQuote(dottedId.uid().getText()), false));
            }
        }
        SqlFullColumnName columnName = new SqlFullColumnName();
        columnName.setNames(names);
        updatedElement.setColumnName(columnName);
        if (updatedElementContext.DEFAULT() != null) {
            updatedElement.setUseDefault(true);
        } else {
            ExpressionVisitor expressionVisitor = new ExpressionVisitor();
            SqlExpression sqlExpression = (SqlExpression)expressionVisitor.visit((ParseTree)updatedElementContext.expression());
            updatedElement.setSqlExpression(sqlExpression);
        }
        return updatedElement;
    }
}

