/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.CollectionSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionAtomVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ParenthesisSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.SimpleSelectVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableStatementVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlBetweenPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlBinaryComparisonPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlCollectionSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpressionAtom;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpressionAtomPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlInPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlIsNullPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlJsonMemberOfPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlLikePredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlParenthesisSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlRegexpPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlSelectStatement;
import com.huawei.hwclouds.scs.sql.nodes.SqlSimpleSelect;
import com.huawei.hwclouds.scs.sql.nodes.SqlSoundsLikePredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlSubqueryComparisonPredicate;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableElement;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PredicateVisitor
extends AbstractVisitor<SqlPredicate> {
    private static final Logger LOGGER = LogManager.getLogger(PredicateVisitor.class);
    protected SqlPredicate sqlPredicate = new SqlPredicate();

    @Override
    public SqlPredicate defaultResult() {
        return this.sqlPredicate;
    }

    @Override
    public SqlPredicate visitInPredicate(MySqlParser.InPredicateContext ctx) {
        SqlInPredicate sqlInPredicate = new SqlInPredicate();
        SqlPredicate predicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate());
        sqlInPredicate.setSqlPredicate(predicate);
        sqlInPredicate.setIfHaveNot(ctx.NOT() != null);
        if (ctx.selectStatement() != null) {
            String ctxTypeName;
            SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
            int index = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().indexOf("$");
            switch (ctxTypeName = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().substring(index + 1)) {
                case "SimpleSelectContext": {
                    SqlSimpleSelect sqlSimpleSelect = (SqlSimpleSelect)new SimpleSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlSimpleSelect(sqlSimpleSelect);
                    break;
                }
                case "ParenthesisSelectContext": {
                    SqlParenthesisSelect sqlParenthesisSelect = (SqlParenthesisSelect)new ParenthesisSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlParenthesisSelect(sqlParenthesisSelect);
                    break;
                }
                case "CollectionSelectContext": {
                    SqlCollectionSelect sqlCollectionSelect = (SqlCollectionSelect)new CollectionSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlCollectionSelect(sqlCollectionSelect);
                    break;
                }
                default: {
                    LOGGER.error("Not supported other select statement");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "(collection select)");
                }
            }
            sqlInPredicate.setSqlSelectStatement(sqlSelectStatement);
        } else if (ctx.expressions() != null) {
            SqlNodeList<SqlExpression> sqlExpressionSqlNodeList = new SqlNodeList<SqlExpression>();
            for (int i = 0; i < ctx.expressions().expression().size(); ++i) {
                SqlExpression sqlExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expressions().expression(i));
                sqlExpressionSqlNodeList.addNode(sqlExpression);
            }
            sqlInPredicate.setSqlExpressionSqlNodeList(sqlExpressionSqlNodeList);
        } else if (ctx.tableStatement() != null) {
            sqlInPredicate.setSqlTableElement((SqlTableElement)new TableStatementVisitor().visit((ParseTree)ctx.tableStatement()));
        }
        this.sqlPredicate.setSqlInPredicate(sqlInPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitIsNullPredicate(MySqlParser.IsNullPredicateContext ctx) {
        SqlIsNullPredicate sqlIsNullPredicate = new SqlIsNullPredicate();
        SqlPredicate predicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate());
        sqlIsNullPredicate.setSqlPredicate(predicate);
        sqlIsNullPredicate.setIfHaveNot(ctx.nullNotnull().NOT() != null);
        if (ctx.nullNotnull().NULL_LITERAL() != null) {
            sqlIsNullPredicate.setNullNotNull(ctx.nullNotnull().NULL_LITERAL().getText());
        } else {
            sqlIsNullPredicate.setNullNotNull(ctx.nullNotnull().NULL_SPEC_LITERAL().getText());
        }
        this.sqlPredicate.setSqlIsNullPredicate(sqlIsNullPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitBinaryComparisonPredicate(MySqlParser.BinaryComparisonPredicateContext ctx) {
        SqlBinaryComparisonPredicate sqlBinaryComparisonPredicate = new SqlBinaryComparisonPredicate();
        SqlPredicate leftPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.left);
        String op = ctx.comparisonOperator().getText();
        SqlPredicate rightPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.right);
        sqlBinaryComparisonPredicate.setLeft(leftPredicate);
        sqlBinaryComparisonPredicate.setComparisonOperator(op);
        sqlBinaryComparisonPredicate.setRight(rightPredicate);
        this.sqlPredicate.setSqlBinaryComparisonPredicate(sqlBinaryComparisonPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitSubqueryComparisonPredicate(MySqlParser.SubqueryComparisonPredicateContext ctx) {
        SqlSubqueryComparisonPredicate sqlSubqueryComparisonPredicate = new SqlSubqueryComparisonPredicate();
        SqlPredicate predicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate());
        String op = ctx.comparisonOperator().getText();
        String quantifier = "";
        if (ctx.ALL() != null) {
            quantifier = "ALL";
        } else if (ctx.ANY() != null) {
            quantifier = "ANY";
        } else if (ctx.SOME() != null) {
            quantifier = "SOME";
        }
        sqlSubqueryComparisonPredicate.setSqlPredicate(predicate);
        sqlSubqueryComparisonPredicate.setComparisonOperator(op);
        sqlSubqueryComparisonPredicate.setQuantifier(quantifier);
        if (ctx.selectStatement() != null) {
            String ctxTypeName;
            SqlSelectStatement sqlSelectStatement = new SqlSelectStatement();
            int index = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().indexOf("$");
            switch (ctxTypeName = ((Object)((Object)ctx.selectStatement())).getClass().getTypeName().substring(index + 1)) {
                case "SimpleSelectContext": {
                    SqlSimpleSelect sqlSimpleSelect = (SqlSimpleSelect)new SimpleSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlSimpleSelect(sqlSimpleSelect);
                    break;
                }
                case "ParenthesisSelectContext": {
                    SqlParenthesisSelect sqlParenthesisSelect = (SqlParenthesisSelect)new ParenthesisSelectVisitor().visit((ParseTree)ctx.selectStatement());
                    sqlSelectStatement.setSqlParenthesisSelect(sqlParenthesisSelect);
                    break;
                }
                default: {
                    LOGGER.error("Not supported other select statement");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "(collection select)");
                }
            }
            sqlSubqueryComparisonPredicate.setSqlSelectStatement(sqlSelectStatement);
        } else if (ctx.tableStatement() != null) {
            sqlSubqueryComparisonPredicate.setSqlTableElement((SqlTableElement)new TableStatementVisitor().visit((ParseTree)ctx.tableStatement()));
        }
        this.sqlPredicate.setSqlSubqueryComparisonPredicate(sqlSubqueryComparisonPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitBetweenPredicate(MySqlParser.BetweenPredicateContext ctx) {
        SqlBetweenPredicate sqlBetweenPredicate = new SqlBetweenPredicate();
        SqlPredicate frontPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(0));
        SqlPredicate mediumPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(1));
        SqlPredicate behindPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(2));
        sqlBetweenPredicate.setFrontPredicate(frontPredicate);
        sqlBetweenPredicate.setMediumPredicate(mediumPredicate);
        sqlBetweenPredicate.setBehindPredicate(behindPredicate);
        sqlBetweenPredicate.setIfHaveNot(ctx.NOT() != null);
        this.sqlPredicate.setSqlBetweenPredicate(sqlBetweenPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitSoundsLikePredicate(MySqlParser.SoundsLikePredicateContext ctx) {
        SqlSoundsLikePredicate sqlSoundsLikePredicate = new SqlSoundsLikePredicate();
        SqlPredicate frontPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(0));
        SqlPredicate behindPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(1));
        sqlSoundsLikePredicate.setFrontPredicate(frontPredicate);
        sqlSoundsLikePredicate.setBehindPredicate(behindPredicate);
        this.sqlPredicate.setSqlSoundsLikePredicate(sqlSoundsLikePredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitLikePredicate(MySqlParser.LikePredicateContext ctx) {
        SqlLikePredicate sqlLikePredicate = new SqlLikePredicate();
        SqlPredicate frontPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(0));
        SqlPredicate behindPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(1));
        sqlLikePredicate.setFrontPredicate(frontPredicate);
        sqlLikePredicate.setBehindPredicate(behindPredicate);
        sqlLikePredicate.setIfHaveNot(ctx.NOT() != null);
        if (ctx.STRING_LITERAL() != null) {
            sqlLikePredicate.setLiteral(ctx.STRING_LITERAL().getText());
        }
        this.sqlPredicate.setSqlLikePredicate(sqlLikePredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitRegexpPredicate(MySqlParser.RegexpPredicateContext ctx) {
        SqlRegexpPredicate sqlRegexpPredicate = new SqlRegexpPredicate();
        SqlPredicate frontPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(0));
        SqlPredicate behindPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(1));
        sqlRegexpPredicate.setFrontPredicate(frontPredicate);
        sqlRegexpPredicate.setBehindPredicate(behindPredicate);
        sqlRegexpPredicate.setIfHaveNot(ctx.NOT() != null);
        sqlRegexpPredicate.setRegex(ctx.REGEXP().getText());
        this.sqlPredicate.setSqlRegexpPredicate(sqlRegexpPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitExpressionAtomPredicate(MySqlParser.ExpressionAtomPredicateContext ctx) {
        SqlExpressionAtomPredicate sqlExpressionAtomPredicate = new SqlExpressionAtomPredicate();
        if (ctx.VAR_ASSIGN() != null) {
            sqlExpressionAtomPredicate.setVarAssign(ctx.VAR_ASSIGN().getText());
        }
        SqlExpressionAtom sqlExpressionAtom = (SqlExpressionAtom)new ExpressionAtomVisitor().visit((ParseTree)ctx.expressionAtom());
        sqlExpressionAtomPredicate.setSqlExpressionAtom(sqlExpressionAtom);
        this.sqlPredicate.setSqlExpressionAtomPredicate(sqlExpressionAtomPredicate);
        return this.defaultResult();
    }

    @Override
    public SqlPredicate visitJsonMemberOfPredicate(MySqlParser.JsonMemberOfPredicateContext ctx) {
        SqlJsonMemberOfPredicate sqlJsonMemberOfPredicate = new SqlJsonMemberOfPredicate();
        SqlPredicate frontPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(0));
        SqlPredicate behindPredicate = (SqlPredicate)new PredicateVisitor().visit((ParseTree)ctx.predicate(1));
        sqlJsonMemberOfPredicate.setFrontPredicate(frontPredicate);
        sqlJsonMemberOfPredicate.setBehindPredicate(behindPredicate);
        this.sqlPredicate.setSqlJsonMemberOfPredicate(sqlJsonMemberOfPredicate);
        return this.defaultResult();
    }
}

