/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.FunctionArgVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.FunctionArgsVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCaseFuncAlternative;
import com.huawei.hwclouds.scs.sql.nodes.SqlCaseFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlCastDataTypeFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlCharFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlConvertDataTypeFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlExtractFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArg;
import com.huawei.hwclouds.scs.sql.nodes.SqlFunctionArgs;
import com.huawei.hwclouds.scs.sql.nodes.SqlLeftAndRightFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPositionFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlSpecificFunction;
import com.huawei.hwclouds.scs.sql.nodes.SqlSubstrFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlTrimFunctionCall;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeName;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpecificFunctionVisitor
extends AbstractVisitor<SqlSpecificFunction> {
    private static final Logger LOGGER = LogManager.getLogger(SpecificFunctionVisitor.class);
    protected SqlSpecificFunction sqlSpecificFunction = new SqlSpecificFunction();

    @Override
    public SqlSpecificFunction defaultResult() {
        return this.sqlSpecificFunction;
    }

    @Override
    public SqlSpecificFunction visitSimpleFunctionCall(MySqlParser.SimpleFunctionCallContext ctx) {
        this.sqlSpecificFunction.setSimpleFunction(this.getSimpleFunctionName(ctx));
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (!ctx.getChild(i).getText().equals("(")) continue;
            this.sqlSpecificFunction.setIfHaveBrackets(true);
        }
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitConvertDataTypeFunctionCall(MySqlParser.ConvertDataTypeFunctionCallContext ctx) {
        SqlConvertDataTypeFunctionCall sqlConvertDataTypeFunctionCall = new SqlConvertDataTypeFunctionCall();
        sqlConvertDataTypeFunctionCall.setSqlExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        sqlConvertDataTypeFunctionCall.setFunctionName(ctx.CONVERT().getText());
        if (ctx.convertedDataType() != null) {
            sqlConvertDataTypeFunctionCall.setConvertedDataType(ctx.convertedDataType().getText());
        } else {
            sqlConvertDataTypeFunctionCall.setKeyWords(ctx.USING().getText());
            sqlConvertDataTypeFunctionCall.setCharsetName(ctx.charsetName().getText());
        }
        this.sqlSpecificFunction.setSqlConvertDataTypeFunctionCall(sqlConvertDataTypeFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitCastDataTypeFunctionCall(MySqlParser.CastDataTypeFunctionCallContext ctx) {
        SqlCastDataTypeFunctionCall sqlCastDataTypeFunctionCall = new SqlCastDataTypeFunctionCall();
        if (ctx.expression() != null) {
            MySqlParser.PredicateContext predicate;
            if (ctx.expression() instanceof MySqlParser.PredicateExpressionContext && (predicate = ((MySqlParser.PredicateExpressionContext)ctx.expression()).predicate()) instanceof MySqlParser.ExpressionAtomPredicateContext && ((MySqlParser.ExpressionAtomPredicateContext)predicate).expressionAtom() instanceof MySqlParser.ConstantExpressionAtomContext && ((MySqlParser.ConstantExpressionAtomContext)((MySqlParser.ExpressionAtomPredicateContext)predicate).expressionAtom()).constant().stringLiteral() != null) {
                sqlCastDataTypeFunctionCall.setStringLiteral(true);
            }
            sqlCastDataTypeFunctionCall.setSqlExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        } else {
            sqlCastDataTypeFunctionCall.setComplex(ctx.complex().getText());
        }
        if (ctx.CAST() != null) {
            sqlCastDataTypeFunctionCall.setFunctionName(ctx.CAST().getText());
        } else if (ctx.TRY_CAST() != null) {
            sqlCastDataTypeFunctionCall.setFunctionName(ctx.TRY_CAST().getText());
        }
        SqlTypeName sqlTypeName = SqlTypeName.get(ctx.convertedDataType().getText());
        if (sqlTypeName != null) {
            sqlCastDataTypeFunctionCall.setConvertedDataType(sqlTypeName.getName());
        } else {
            sqlCastDataTypeFunctionCall.setConvertedDataType(ctx.convertedDataType().getText());
        }
        this.sqlSpecificFunction.setSqlCastDataTypeFunctionCall(sqlCastDataTypeFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitValuesFunctionCall(MySqlParser.ValuesFunctionCallContext ctx) {
        this.sqlSpecificFunction.setValuesFunctionFullColumnName(ctx.fullColumnName().getText());
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitCaseExpressionFunctionCall(MySqlParser.CaseExpressionFunctionCallContext ctx) {
        SqlCaseFunctionCall sqlCaseFunctionCall = new SqlCaseFunctionCall();
        SqlExpression sqlExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression());
        sqlCaseFunctionCall.setSqlExpression(sqlExpression);
        SqlNodeList<SqlCaseFuncAlternative> caseFuncAlternativeList = new SqlNodeList<SqlCaseFuncAlternative>();
        for (int i = 0; i < ctx.caseFuncAlternative().size(); ++i) {
            FunctionArgVisitor visitor = new FunctionArgVisitor();
            SqlFunctionArg condition = (SqlFunctionArg)visitor.visit((ParseTree)ctx.caseFuncAlternative((int)i).functionCondition);
            visitor = new FunctionArgVisitor();
            SqlFunctionArg consequent = (SqlFunctionArg)visitor.visit((ParseTree)ctx.caseFuncAlternative((int)i).consequent);
            SqlCaseFuncAlternative sqlCaseFuncAlternative = new SqlCaseFuncAlternative();
            sqlCaseFuncAlternative.setCondition(condition);
            sqlCaseFuncAlternative.setConsequent(consequent);
            caseFuncAlternativeList.addNode(sqlCaseFuncAlternative);
        }
        sqlCaseFunctionCall.setSqlCaseFuncAlternativeSqlNodeList(caseFuncAlternativeList);
        if (ctx.ELSE() != null) {
            SqlFunctionArg elseArg = (SqlFunctionArg)new FunctionArgVisitor().visit((ParseTree)ctx.elseArg);
            sqlCaseFunctionCall.setSqlFunctionArg(elseArg);
        }
        this.sqlSpecificFunction.setCaseAndExpressionFunction(sqlCaseFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitCaseFunctionCall(MySqlParser.CaseFunctionCallContext ctx) {
        SqlCaseFunctionCall sqlCaseFunctionCall = new SqlCaseFunctionCall();
        SqlNodeList<SqlCaseFuncAlternative> caseFuncAlternativeList = new SqlNodeList<SqlCaseFuncAlternative>();
        for (int i = 0; i < ctx.caseFuncAlternative().size(); ++i) {
            FunctionArgVisitor visitor = new FunctionArgVisitor();
            SqlFunctionArg condition = (SqlFunctionArg)visitor.visit((ParseTree)ctx.caseFuncAlternative((int)i).functionCondition);
            visitor = new FunctionArgVisitor();
            SqlFunctionArg consequent = (SqlFunctionArg)visitor.visit((ParseTree)ctx.caseFuncAlternative((int)i).consequent);
            SqlCaseFuncAlternative sqlCaseFuncAlternative = new SqlCaseFuncAlternative();
            sqlCaseFuncAlternative.setCondition(condition);
            sqlCaseFuncAlternative.setConsequent(consequent);
            caseFuncAlternativeList.addNode(sqlCaseFuncAlternative);
        }
        sqlCaseFunctionCall.setSqlCaseFuncAlternativeSqlNodeList(caseFuncAlternativeList);
        if (ctx.ELSE() != null) {
            SqlFunctionArg elseArg = (SqlFunctionArg)new FunctionArgVisitor().visit((ParseTree)ctx.elseArg);
            sqlCaseFunctionCall.setSqlFunctionArg(elseArg);
        }
        this.sqlSpecificFunction.setCaseAndExpressionFunction(sqlCaseFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitCharFunctionCall(MySqlParser.CharFunctionCallContext ctx) {
        SqlCharFunctionCall sqlCharFunctionCall = new SqlCharFunctionCall();
        SqlFunctionArgs sqlFunctionArgs = (SqlFunctionArgs)new FunctionArgsVisitor().visit((ParseTree)ctx.functionArgs());
        sqlCharFunctionCall.setSqlFunctionArgs(sqlFunctionArgs);
        if (ctx.USING() != null) {
            sqlCharFunctionCall.setCharsetName(ctx.charsetName().getText());
        }
        this.sqlSpecificFunction.setSqlCharFunctionCall(sqlCharFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitExtractFunctionCall(MySqlParser.ExtractFunctionCallContext ctx) {
        SqlExtractFunctionCall sqlExtractFunctionCall = new SqlExtractFunctionCall();
        sqlExtractFunctionCall.setIntervalType(ctx.intervalType().getText());
        if (ctx.sourceString != null) {
            if (ctx.intervalType().getText().equalsIgnoreCase("YEAR")) {
                sqlExtractFunctionCall.setComplex("DATE" + ctx.sourceString.getText());
            } else if (ctx.intervalType().getText().equalsIgnoreCase("SECOND")) {
                sqlExtractFunctionCall.setComplex("TIME" + ctx.sourceString.getText());
            } else {
                if (ctx.intervalType().getText().contains("_")) {
                    LOGGER.error("Other time type conversions are not supported.");
                    throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "time type " + ctx.intervalType().getText());
                }
                sqlExtractFunctionCall.setComplex("timestamp" + ctx.sourceString.getText());
            }
        } else if (ctx.complex() != null) {
            if (ctx.complex().dataTypeBase().getText().equalsIgnoreCase("DATETIME")) {
                sqlExtractFunctionCall.setComplex("timestamp" + ctx.complex().constant().getText());
            } else if (ctx.complex().dataTypeBase().getText().equalsIgnoreCase("TIME")) {
                sqlExtractFunctionCall.setComplex("NOW()");
            } else {
                sqlExtractFunctionCall.setComplex(ctx.complex().getText());
            }
        } else if (ctx.expression() != null) {
            sqlExtractFunctionCall.setComplexExpression((SqlExpression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        }
        this.sqlSpecificFunction.setSqlExtractFunctionCall(sqlExtractFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitLeftFunctionCall(MySqlParser.LeftFunctionCallContext ctx) {
        SqlLeftAndRightFunctionCall sqlLeftAndRightFunctionCall = new SqlLeftAndRightFunctionCall();
        sqlLeftAndRightFunctionCall.setLeftOrRight("LEFT");
        sqlLeftAndRightFunctionCall.setLeftOrRightStr(ctx.leftStr.getText());
        sqlLeftAndRightFunctionCall.setLeftOrRightLength(ctx.leftLength.getText());
        this.sqlSpecificFunction.setSqlLeftAndRightFunctionCall(sqlLeftAndRightFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitRightFunctionCall(MySqlParser.RightFunctionCallContext ctx) {
        SqlLeftAndRightFunctionCall sqlLeftAndRightFunctionCall = new SqlLeftAndRightFunctionCall();
        sqlLeftAndRightFunctionCall.setLeftOrRight("RIGHT");
        sqlLeftAndRightFunctionCall.setLeftOrRightStr(ctx.rightStr.getText());
        sqlLeftAndRightFunctionCall.setLeftOrRightLength(ctx.rightLength.getText());
        this.sqlSpecificFunction.setSqlLeftAndRightFunctionCall(sqlLeftAndRightFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitPositionFunctionCall(MySqlParser.PositionFunctionCallContext ctx) {
        SqlPositionFunctionCall sqlPositionFunctionCall = new SqlPositionFunctionCall();
        if (ctx.positionString != null) {
            sqlPositionFunctionCall.setPositionString(ctx.positionString.getText());
        }
        if (ctx.inString != null) {
            sqlPositionFunctionCall.setInString(ctx.inString.getText());
        }
        this.sqlSpecificFunction.setSqlPositionFunctionCall(sqlPositionFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitSubstrFunctionCall(MySqlParser.SubstrFunctionCallContext ctx) {
        SqlSubstrFunctionCall sqlSubstrFunctionCall = new SqlSubstrFunctionCall();
        if (ctx.sourceString != null) {
            sqlSubstrFunctionCall.setSourceString(ctx.sourceString.getText());
        }
        if (ctx.fromDecimal != null) {
            sqlSubstrFunctionCall.setFromDecimal(ctx.fromDecimal.getText());
        }
        if (ctx.forDecimal != null) {
            sqlSubstrFunctionCall.setForDecimal(ctx.forDecimal.getText());
        }
        this.sqlSpecificFunction.setSqlSubstrFunctionCall(sqlSubstrFunctionCall);
        return this.defaultResult();
    }

    @Override
    public SqlSpecificFunction visitTrimFunctionCall(MySqlParser.TrimFunctionCallContext ctx) {
        SqlTrimFunctionCall sqlTrimFunctionCall = new SqlTrimFunctionCall();
        sqlTrimFunctionCall.setPositionForm(ctx.positionForm.getText());
        if (ctx.sourceString != null) {
            sqlTrimFunctionCall.setSourceString(ctx.sourceString.getText());
        }
        if (ctx.fromString != null) {
            sqlTrimFunctionCall.setFromString(ctx.fromString.getText());
        }
        this.sqlSpecificFunction.setSqlTrimFunctionCall(sqlTrimFunctionCall);
        return this.defaultResult();
    }

    public String getSimpleFunctionName(MySqlParser.SimpleFunctionCallContext context) {
        if (context.CURRENT_DATE() != null) {
            return context.CURRENT_DATE().getText();
        }
        if (context.CURRENT_TIME() != null) {
            return context.CURRENT_TIME().getText();
        }
        if (context.CURRENT_TIMESTAMP() != null) {
            return context.CURRENT_TIMESTAMP().getText();
        }
        if (context.CURRENT_USER() != null) {
            return context.CURRENT_USER().getText();
        }
        return context.LOCALTIME().getText();
    }
}

