/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.PartitionDefinitionVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterByAddCheckTableConstraint;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterByAddPartition;
import com.huawei.hwclouds.scs.sql.nodes.SqlAlterByDropPartition;
import com.huawei.hwclouds.scs.sql.nodes.SqlDistributeOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlExpression;
import com.huawei.hwclouds.scs.sql.nodes.SqlKeysTypeOptions;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlPartitionDefinition;
import com.huawei.hwclouds.scs.sql.nodes.SqlSetCharset;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOption;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionAutoIncrement;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionAverage;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionCharset;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionChecksum;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionCollate;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionComment;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionConnection;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionDataDirectory;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionDelay;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionEngine;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionIndexDirectory;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionInsertMethod;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionKeyBlockSize;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionMaxRows;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionMinRows;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionPackKeys;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionPassword;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionPersistent;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionRecalculation;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionRowFormat;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionSamplePage;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionTablespace;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOptionUnion;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class TableOptionVisitor<T>
extends AbstractVisitor<T> {
    protected abstract void addOption(SqlTableOption var1);

    @Override
    public T visitTableOptionEngine(MySqlParser.TableOptionEngineContext ctx) {
        SqlTableOptionEngine engine = new SqlTableOptionEngine();
        engine.setEngineName(SqlTableOptionEngine.EngineName.getInstanceByname(ctx.engineName().getText()));
        this.addOption(engine);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionAutoIncrement(MySqlParser.TableOptionAutoIncrementContext ctx) {
        SqlTableOptionAutoIncrement autoIncrement = new SqlTableOptionAutoIncrement();
        autoIncrement.setDecimalLiteral(ctx.decimalLiteral().getText());
        this.addOption(autoIncrement);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionAverage(MySqlParser.TableOptionAverageContext ctx) {
        SqlTableOptionAverage average = new SqlTableOptionAverage();
        average.setDecimalLiteral(ctx.decimalLiteral().getText());
        this.addOption(average);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionCharset(MySqlParser.TableOptionCharsetContext ctx) {
        SqlTableOptionCharset charset = new SqlTableOptionCharset();
        charset.setSqlSetCharset(SqlSetCharset.getInstanceByname(ctx.charsetName().getText()));
        this.addOption(charset);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionChecksum(MySqlParser.TableOptionChecksumContext ctx) {
        SqlTableOptionChecksum checksum = new SqlTableOptionChecksum();
        checksum.setBoolValue(ctx.boolValue.getText());
        this.addOption(checksum);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionCollate(MySqlParser.TableOptionCollateContext ctx) {
        SqlTableOptionCollate collate = new SqlTableOptionCollate();
        collate.setCollationName(ctx.collationName().getText());
        this.addOption(collate);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionComment(MySqlParser.TableOptionCommentContext ctx) {
        SqlTableOptionComment comment = new SqlTableOptionComment();
        comment.setStringLiteral(ctx.STRING_LITERAL().getText());
        this.addOption(comment);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionConnection(MySqlParser.TableOptionConnectionContext ctx) {
        SqlTableOptionConnection connection = new SqlTableOptionConnection();
        connection.setStringLiteral(ctx.STRING_LITERAL().getText());
        this.addOption(connection);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionDataDirectory(MySqlParser.TableOptionDataDirectoryContext ctx) {
        SqlTableOptionDataDirectory dataDirectory = new SqlTableOptionDataDirectory();
        dataDirectory.setStringLiteral(ctx.STRING_LITERAL().getText());
        this.addOption(dataDirectory);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionDelay(MySqlParser.TableOptionDelayContext ctx) {
        SqlTableOptionDelay delay = new SqlTableOptionDelay();
        delay.setBoolValue(ctx.boolValue.getText());
        this.addOption(delay);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionDistribute(MySqlParser.TableOptionDistributeContext ctx) {
        SqlDistributeOptions sqlDistributeOptions = new SqlDistributeOptions();
        if (ctx.HASH() != null) {
            sqlDistributeOptions.setKeyWord(ctx.HASH().getText());
        } else if (ctx.BROADCAST() != null) {
            sqlDistributeOptions.setKeyWord(ctx.BROADCAST().getText());
        }
        LinkedList<String> list = new LinkedList<String>();
        if (ctx.uidList() != null) {
            for (int i = 0; i < ctx.uidList().uid().size(); ++i) {
                list.add(ctx.uidList().uid(i).getText());
            }
        }
        sqlDistributeOptions.setUidList(list);
        this.addOption(sqlDistributeOptions);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionIndexDirectory(MySqlParser.TableOptionIndexDirectoryContext ctx) {
        SqlTableOptionIndexDirectory indexDirectory = new SqlTableOptionIndexDirectory();
        indexDirectory.setStringLiteral(ctx.STRING_LITERAL().getText());
        this.addOption(indexDirectory);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionInsertMethod(MySqlParser.TableOptionInsertMethodContext ctx) {
        SqlTableOptionInsertMethod insertMethod = new SqlTableOptionInsertMethod();
        insertMethod.setInsertMethod(ctx.insertMethod.getText());
        this.addOption(insertMethod);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionKeyBlockSize(MySqlParser.TableOptionKeyBlockSizeContext ctx) {
        SqlTableOptionKeyBlockSize keyBlockSize = new SqlTableOptionKeyBlockSize();
        keyBlockSize.setFileSizeLiteral(ctx.fileSizeLiteral().getText());
        this.addOption(keyBlockSize);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionMaxRows(MySqlParser.TableOptionMaxRowsContext ctx) {
        SqlTableOptionMaxRows maxRows = new SqlTableOptionMaxRows();
        maxRows.setDecimalLiteral(ctx.decimalLiteral().getText());
        this.addOption(maxRows);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionMinRows(MySqlParser.TableOptionMinRowsContext ctx) {
        SqlTableOptionMinRows minRows = new SqlTableOptionMinRows();
        minRows.setDecimalLiteral(ctx.decimalLiteral().getText());
        this.addOption(minRows);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionPackKeys(MySqlParser.TableOptionPackKeysContext ctx) {
        SqlTableOptionPackKeys packKeys = new SqlTableOptionPackKeys();
        packKeys.setExtBoolValue(ctx.extBoolValue.getText());
        this.addOption(packKeys);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionPassword(MySqlParser.TableOptionPasswordContext ctx) {
        SqlTableOptionPassword password = new SqlTableOptionPassword();
        password.setStringLiteral(ctx.STRING_LITERAL().getText());
        this.addOption(password);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionRowFormat(MySqlParser.TableOptionRowFormatContext ctx) {
        SqlTableOptionRowFormat rowFormat = new SqlTableOptionRowFormat();
        rowFormat.setRowFormat(SqlTableOptionRowFormat.FormatType.valueOf(ctx.rowFormat.getText().toUpperCase(Locale.US)));
        this.addOption(rowFormat);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionRecalculation(MySqlParser.TableOptionRecalculationContext ctx) {
        SqlTableOptionRecalculation recalculation = new SqlTableOptionRecalculation();
        recalculation.setExtBoolValue(ctx.extBoolValue.getText());
        this.addOption(recalculation);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionPersistent(MySqlParser.TableOptionPersistentContext ctx) {
        SqlTableOptionPersistent persistent = new SqlTableOptionPersistent();
        persistent.setExtBoolValue(ctx.STATS_PERSISTENT().getText());
        this.addOption(persistent);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionSamplePage(MySqlParser.TableOptionSamplePageContext ctx) {
        SqlTableOptionSamplePage samplePage = new SqlTableOptionSamplePage();
        samplePage.setDecimalLiteral(ctx.decimalLiteral().getText());
        this.addOption(samplePage);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionTablespace(MySqlParser.TableOptionTablespaceContext ctx) {
        SqlTableOptionTablespace tablespace = new SqlTableOptionTablespace();
        if (ctx.uid() != null) {
            tablespace.setTablespaceStorage(ctx.uid().getText());
        }
        if (ctx.tablespaceStorage() != null) {
            tablespace.setTablespaceStorage(ctx.uid().getText());
        }
        if (ctx.TABLESPACE() != null) {
            tablespace.setTablespaceStorage(ctx.uid().getText());
        }
        this.addOption(tablespace);
        return this.defaultResult();
    }

    @Override
    public T visitTableOptionUnion(MySqlParser.TableOptionUnionContext ctx) {
        SqlNodeList tableNames = new SqlNodeList();
        if (ctx.tables() != null) {
            ctx.tables().tableName().stream().map(parseTree -> (SqlTableName)new TableNameVisitor().visit((ParseTree)parseTree)).forEach(tbl -> tableNames.addNode(tbl));
        }
        List<SqlTableName> tableNamesList = new ArrayList<SqlTableName>();
        SqlTableOptionUnion union = new SqlTableOptionUnion();
        if (tableNames.getNodes().size() != 0) {
            tableNamesList = tableNames.getNodes();
        }
        union.setTableNameList(tableNamesList);
        this.addOption(union);
        return this.defaultResult();
    }

    @Override
    public T visitPartitionDefinitions(MySqlParser.PartitionDefinitionsContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "partition by");
    }

    @Override
    public T visitAlterByAddForeignKey(MySqlParser.AlterByAddForeignKeyContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "add foreign key");
    }

    @Override
    public T visitAlterByAddCheckTableConstraint(MySqlParser.AlterByAddCheckTableConstraintContext ctx) {
        this.alterByAddCheckTableConstraint(ctx, null);
        return this.defaultResult();
    }

    @Override
    public T visitAlterAddCheckTableConstraint(MySqlParser.AlterAddCheckTableConstraintContext ctx) {
        this.alterByAddCheckTableConstraint(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddCheckTableConstraint(MySqlParser.AlterByAddCheckTableConstraintContext ctx, MySqlParser.AlterAddCheckTableConstraintContext ctxNoBy) {
        MySqlParser.ExpressionContext expression;
        MySqlParser.UidContext uid;
        if (ctx != null) {
            uid = ctx.uid();
            expression = ctx.expression();
        } else {
            uid = ctxNoBy.uid();
            expression = ctxNoBy.expression();
        }
        SqlAlterByAddCheckTableConstraint checkTableConstraint = new SqlAlterByAddCheckTableConstraint();
        if (uid != null && uid.simpleId() != null) {
            checkTableConstraint.setSimpleId(uid.simpleId().getText());
        }
        SqlExpression sqlExpression = (SqlExpression)new ExpressionVisitor().visit((ParseTree)expression);
        checkTableConstraint.setSqlExpression(sqlExpression);
        this.addOption(checkTableConstraint);
    }

    @Override
    public T visitAlterBySetAlgorithm(MySqlParser.AlterBySetAlgorithmContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "algorithm assign");
    }

    @Override
    public T visitAlterByDisableKeys(MySqlParser.AlterByDisableKeysContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "disable keys");
    }

    @Override
    public T visitAlterByEnableKeys(MySqlParser.AlterByEnableKeysContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "enable keys");
    }

    @Override
    public T visitAlterByOrder(MySqlParser.AlterByOrderContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "order by");
    }

    @Override
    public T visitAlterByDiscardTablespace(MySqlParser.AlterByDiscardTablespaceContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "discard tablespace");
    }

    @Override
    public T visitAlterByImportTablespace(MySqlParser.AlterByImportTablespaceContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "import tablespace");
    }

    @Override
    public T visitAlterByForce(MySqlParser.AlterByForceContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "alter by force");
    }

    @Override
    public T visitAlterByValidate(MySqlParser.AlterByValidateContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "without/with validation");
    }

    @Override
    public T visitAlterByAddPartition(MySqlParser.AlterByAddPartitionContext ctx) {
        this.alterByAddPartition(ctx, null);
        return this.defaultResult();
    }

    @Override
    public T visitAlterAddPartition(MySqlParser.AlterAddPartitionContext ctx) {
        this.alterByAddPartition(null, ctx);
        return this.defaultResult();
    }

    private void alterByAddPartition(MySqlParser.AlterByAddPartitionContext ctx, MySqlParser.AlterAddPartitionContext ctxNoBy) {
        List<MySqlParser.PartitionDefinitionContext> partitionDefinitionContexts;
        TerminalNode partitions;
        if (ctx != null) {
            partitions = ctx.PARTITIONS();
            partitionDefinitionContexts = ctx.partitionDefinition();
        } else {
            partitions = ctxNoBy.PARTITIONS();
            partitionDefinitionContexts = ctxNoBy.partitionDefinition();
        }
        if (partitions != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "Alter table add partitions");
        }
        SqlAlterByAddPartition sqlAlterByAddPartition = new SqlAlterByAddPartition();
        ArrayList<SqlPartitionDefinition> sqlPartitionDefinitions = new ArrayList<SqlPartitionDefinition>();
        for (MySqlParser.PartitionDefinitionContext partitionDefinitionContext : partitionDefinitionContexts) {
            sqlPartitionDefinitions.add((SqlPartitionDefinition)new PartitionDefinitionVisitor().visit((ParseTree)partitionDefinitionContext));
        }
        sqlAlterByAddPartition.setPartitionDefinitionList(sqlPartitionDefinitions);
        this.addOption(sqlAlterByAddPartition);
    }

    @Override
    public T visitAlterByDropPartition(MySqlParser.AlterByDropPartitionContext ctx) {
        SqlAlterByDropPartition sqlAlterByDropPartition = new SqlAlterByDropPartition();
        ArrayList<String> partitionNames = new ArrayList<String>();
        for (int i = 0; i < ctx.uidList().uid().size(); ++i) {
            partitionNames.add(QuoteUtils.addDoubleQuoteAndToLowerCase(ctx.uidList().uid().get(i).getText()));
        }
        sqlAlterByDropPartition.setPartitionNames(partitionNames);
        this.addOption(sqlAlterByDropPartition);
        return this.defaultResult();
    }

    @Override
    public T visitAlterByDiscardPartition(MySqlParser.AlterByDiscardPartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "partition");
    }

    @Override
    public T visitAlterByImportPartition(MySqlParser.AlterByImportPartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "import partition");
    }

    @Override
    public T visitAlterByCoalescePartition(MySqlParser.AlterByCoalescePartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "coalesce partition");
    }

    @Override
    public T visitAlterByReorganizePartition(MySqlParser.AlterByReorganizePartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "reorganize partition");
    }

    @Override
    public T visitAlterByExchangePartition(MySqlParser.AlterByExchangePartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "exchange partition");
    }

    @Override
    public T visitAlterByAnalyzePartition(MySqlParser.AlterByAnalyzePartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "analyze partition");
    }

    @Override
    public T visitAlterByCheckPartition(MySqlParser.AlterByCheckPartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "check partition");
    }

    @Override
    public T visitAlterByOptimizePartition(MySqlParser.AlterByOptimizePartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "optimize partition");
    }

    @Override
    public T visitAlterByRebuildPartition(MySqlParser.AlterByRebuildPartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "rebuild partition");
    }

    @Override
    public T visitAlterByRepairPartition(MySqlParser.AlterByRepairPartitionContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "repair partition");
    }

    @Override
    public T visitAlterByUpgradePartitioning(MySqlParser.AlterByUpgradePartitioningContext ctx) {
        throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "upgrade partitioning");
    }

    @Override
    public T visitTableOptionKeysType(MySqlParser.TableOptionKeysTypeContext ctx) {
        SqlKeysTypeOptions sqlKeysTypeOptions = new SqlKeysTypeOptions();
        if (ctx.UNIQUE() != null) {
            sqlKeysTypeOptions.setKeyWord(ctx.UNIQUE().getText());
        } else if (ctx.AGGREGATE() != null) {
            sqlKeysTypeOptions.setKeyWord(ctx.AGGREGATE().getText());
        } else if (ctx.DUPLICATE() != null) {
            sqlKeysTypeOptions.setKeyWord(ctx.DUPLICATE().getText());
        } else if (ctx.PRIMARY() != null) {
            sqlKeysTypeOptions.setKeyWord(ctx.PRIMARY().getText());
        }
        ArrayList<String> list = new ArrayList<String>();
        if (ctx.uidList() != null) {
            for (int i = 0; i < ctx.uidList().uid().size(); ++i) {
                list.add(ctx.uidList().uid(i).getText());
            }
        }
        sqlKeysTypeOptions.setUidList(list);
        this.addOption(sqlKeysTypeOptions);
        return this.defaultResult();
    }
}

