/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.mysql.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.scs.mysql.parser.MySqlParser;
import com.huawei.hwclouds.scs.mysql.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.scs.mysql.parser.visitor.TableNameVisitor;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommentNode;
import com.huawei.hwclouds.scs.sql.nodes.SqlCommitRollbackTransaction;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlLockTableElement;
import com.huawei.hwclouds.scs.sql.nodes.SqlLockTables;
import com.huawei.hwclouds.scs.sql.nodes.SqlNodeList;
import com.huawei.hwclouds.scs.sql.nodes.SqlStartTransaction;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableName;
import com.huawei.hwclouds.scs.sql.nodes.TransactionMode;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionStatementVisitor
extends AbstractVisitor<SqlCommentNode> {
    private static final Logger LOGGER = LogManager.getLogger(TransactionStatementVisitor.class);

    @Override
    protected SqlCommentNode defaultResult() {
        return null;
    }

    @Override
    public SqlCommentNode visitStartTransaction(MySqlParser.StartTransactionContext ctx) {
        SqlStartTransaction transaction = new SqlStartTransaction();
        if (ctx.transactionMode() == null || ctx.transactionMode().isEmpty()) {
            return transaction;
        }
        ArrayList<TransactionMode> modeList = new ArrayList<TransactionMode>();
        for (MySqlParser.TransactionModeContext modeContext : ctx.transactionMode()) {
            if (modeContext.CONSISTENT() != null) {
                modeList.add(TransactionMode.MYSQL_CONSISTENT_SNAPSHOT);
                continue;
            }
            if (modeContext.WRITE() != null) {
                modeList.add(TransactionMode.READ_WRITE);
                continue;
            }
            if (modeContext.ONLY() != null) {
                modeList.add(TransactionMode.READ_ONLY);
                continue;
            }
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "unrecognized mode " + modeContext.getText());
        }
        transaction.setTransactionMode(modeList);
        return transaction;
    }

    @Override
    public SqlCommentNode visitCommitWork(MySqlParser.CommitWorkContext ctx) {
        SqlCommitRollbackTransaction st = new SqlCommitRollbackTransaction();
        st.setCommit(true);
        return st;
    }

    @Override
    public SqlCommentNode visitRollbackWork(MySqlParser.RollbackWorkContext ctx) {
        SqlCommitRollbackTransaction st = new SqlCommitRollbackTransaction();
        st.setCommit(false);
        return st;
    }

    @Override
    public SqlCommentNode visitLockTables(MySqlParser.LockTablesContext ctx) {
        LOGGER.info("LockTables enter ");
        SqlLockTables lockTables = new SqlLockTables();
        SqlNodeList<SqlLockTableElement> lockTableElements = new SqlNodeList<SqlLockTableElement>();
        for (MySqlParser.LockTableElementContext lockElement : ctx.lockTableElement()) {
            SqlLockTableElement lockTableElement = new SqlLockTableElement();
            lockTableElement.setTableName((SqlTableName)new TableNameVisitor().visit((ParseTree)lockElement.tableName()));
            if (lockElement.uid() != null) {
                lockTableElement.setTableNameAlias(new SqlIdentifier(QuoteUtils.removeQuote(lockElement.uid().getText()), false));
            }
            if (lockElement.lockAction().READ() != null) {
                if (lockElement.lockAction().LOCAL() == null) {
                    lockTableElement.setLockActions(SqlLockTableElement.LockActions.READ);
                } else {
                    lockTableElement.setLockActions(SqlLockTableElement.LockActions.MYSQL_READ_LOCAL);
                }
            }
            if (lockElement.lockAction().WRITE() != null) {
                if (lockElement.lockAction().LOW_PRIORITY() == null) {
                    lockTableElement.setLockActions(SqlLockTableElement.LockActions.WRITE);
                } else {
                    lockTableElement.setLockActions(SqlLockTableElement.LockActions.MYSQL_LOW_PRIORITY_WRITE);
                }
            }
            lockTableElements.addNode(lockTableElement);
        }
        lockTables.setSqlLockTableElement(lockTableElements);
        return lockTables;
    }

    @Override
    public SqlCommentNode visitUnlockTables(MySqlParser.UnlockTablesContext ctx) {
        SqlLockTables lockTables = new SqlLockTables();
        if (ctx.UNLOCK() != null) {
            lockTables.setUnlock(true);
        } else {
            lockTables.setUnlock(false);
        }
        return lockTables;
    }
}

