/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql;

import com.huawei.hwclouds.scs.sql.UnParser;
import com.huawei.hwclouds.scs.sql.UnParserAnnotation;
import com.huawei.hwclouds.scs.sql.nodes.SqlNode;
import com.huawei.hwclouds.scs.sql.util.ClassScanner;
import com.huawei.hwclouds.scs.sql.util.ConvertRuntimeException;
import com.huawei.hwclouds.scs.sql.util.SqlDialect;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnParserFactory {
    private static final Logger LOGGER = LogManager.getLogger(UnParserFactory.class);
    private static final Map<SqlDialect, Map<Class<? extends SqlNode>, Class<? extends UnParser>>> UNPARSERS = new HashMap<SqlDialect, Map<Class<? extends SqlNode>, Class<? extends UnParser>>>();
    private static final String UNPARSER_ANNOATION_SCAN_DWS = "com.huawei.hwclouds.scs.dws.unparser";

    public static UnParser getUnParser(Class<? extends SqlNode> c, SqlDialect dialect) {
        LOGGER.debug("get unparser from sqlnode :{}, dialect: {}", (Object)c.getSimpleName(), (Object)dialect);
        Map<Class<? extends SqlNode>, Class<? extends UnParser>> dialectMap = UNPARSERS.get((Object)dialect);
        if (dialectMap == null) {
            LOGGER.error("Can not found unparser for dailect : {}", (Object)dialect);
            throw new ConvertRuntimeException("Can not found unparser for dailect : " + (Object)((Object)dialect));
        }
        try {
            Class<? extends UnParser> unparser = dialectMap.get(c);
            if (unparser == null) {
                LOGGER.error("Can not found unparser class from sqlnode :" + c.getSimpleName());
                throw new ConvertRuntimeException("Can not found unparser class from sqlnode :" + c.getSimpleName());
            }
            return unparser.newInstance();
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Can not found unparser class from sqlnode :" + c.getSimpleName());
            throw new ConvertRuntimeException("Can not found unparser class from sqlnode :" + c.getSimpleName(), e);
        }
    }

    static {
        new ClassScanner(classHandler -> {
            UnParserAnnotation annotation = classHandler.getAnnotation(UnParserAnnotation.class);
            if (annotation == null) {
                return;
            }
            if (!UNPARSERS.containsKey((Object)annotation.dialect())) {
                UNPARSERS.put(annotation.dialect(), new HashMap());
            }
            LOGGER.debug("Add class {}, for dialect {}, sqlnode {}.", (Object[])new String[]{classHandler.getSimpleName(), annotation.dialect().toString(), annotation.sqlnode().getSimpleName()});
            UNPARSERS.get((Object)annotation.dialect()).put(annotation.sqlnode(), classHandler);
        }).scan(UNPARSER_ANNOATION_SCAN_DWS);
    }
}

