/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.nodes;

import com.huawei.hwclouds.scs.sql.UnParserContext;
import com.huawei.hwclouds.scs.sql.nodes.SqlIdentifier;
import com.huawei.hwclouds.scs.sql.nodes.SqlTableOption;
import com.huawei.hwclouds.scs.sql.util.QuoteUtils;
import com.huawei.hwclouds.scs.sql.writer.SqlWriter;
import java.util.List;
import java.util.stream.Collectors;

public class SqlKeysTypeOptions
extends SqlTableOption {
    private String keyWord;
    private List<String> uidList;
    private boolean partition = false;

    public SqlIdentifier getConstructedIndexName(SqlWriter writer, UnParserContext context) {
        SqlWriter nWriter = writer.cloneEmpty();
        this.getTableName().unparse(nWriter, context);
        String fullTName = nWriter.toSqlString().getSql();
        int dbNameIndex = fullTName.lastIndexOf(".");
        String idxPrefix = "IDX_";
        String tName = dbNameIndex > 0 ? QuoteUtils.removeDoubleQuote(fullTName.substring(dbNameIndex + 1)) : fullTName;
        String idxColumns = this.getUidList().stream().map(QuoteUtils::removeQuote).collect(Collectors.joining("_"));
        String idxName = idxPrefix + tName + "_" + idxColumns;
        if (idxName.length() > 63) {
            idxName = idxName.substring(0, 63);
        }
        return new SqlIdentifier(idxName, false);
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public List<String> getUidList() {
        return this.uidList;
    }

    public boolean isPartition() {
        return this.partition;
    }

    public void setKeyWord(String keyWord) {
        this.keyWord = keyWord;
    }

    public void setUidList(List<String> uidList) {
        this.uidList = uidList;
    }

    public void setPartition(boolean partition) {
        this.partition = partition;
    }
}

