/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.nodes;

import com.google.common.collect.ImmutableMap;
import com.huawei.hwclouds.scs.sql.nodes.SqlTypeFamily;
import java.util.Map;

public enum SqlTypeName {
    BIT("BIT", 3, -7, SqlTypeFamily.NUMERIC),
    TINYINT("TINYINT", 3, -6, SqlTypeFamily.NUMERIC),
    SMALLINT("SMALLINT", 3, 5, SqlTypeFamily.NUMERIC),
    MEDIUMINT("MEDIUMINT", 3, 4, SqlTypeFamily.NUMERIC),
    INT("INT", 3, 4, SqlTypeFamily.NUMERIC),
    INT32("INT32", 3, 4, SqlTypeFamily.NUMERIC),
    INT64("BIGINT", 3, 4, SqlTypeFamily.NUMERIC),
    LARGEINT("LARGEINT", 3, 4, SqlTypeFamily.NUMERIC),
    INTEGER("INTEGER", 3, 4, SqlTypeFamily.NUMERIC),
    BIGINT("BIGINT", 3, -5, SqlTypeFamily.NUMERIC),
    FLOAT("FLOAT", 7, 6, SqlTypeFamily.NUMERIC),
    FLOAT64("FLOAT64", 7, 6, SqlTypeFamily.NUMERIC),
    DOUBLE("DOUBLE", 7, 8, SqlTypeFamily.NUMERIC),
    DOUBLE_PRECISION("DOUBLE_PRECISION", 7, 8, SqlTypeFamily.NUMERIC),
    REAL("REAL", 7, 8, SqlTypeFamily.NUMERIC),
    DECIMAL("DECIMAL", 7, 3, SqlTypeFamily.NUMERIC),
    DEC("DEC", 7, 3, SqlTypeFamily.NUMERIC),
    NUMERIC("NUMERIC", 7, 3, SqlTypeFamily.NUMERIC),
    BIGNUMERIC("BIGNUMERIC", 7, 3, SqlTypeFamily.NUMERIC),
    FIXED("FIXED", 7, 3, SqlTypeFamily.NUMERIC),
    BOOLEAN("BOOLEAN", 1, 16, SqlTypeFamily.BOOLEAN),
    BOOL("BOOL", 1, 16, SqlTypeFamily.BOOLEAN),
    SERIAL("SERIAL", 1, 7, SqlTypeFamily.NUMERIC),
    SMALLSERIAL("SMALLSERIAL", 1, 7, SqlTypeFamily.NUMERIC),
    INTERVAL("INTERVAL", 1, 7, SqlTypeFamily.NUMERIC),
    BIGSERIAL("BIGSERIAL", 1, 7, SqlTypeFamily.NUMERIC),
    CHAR("CHAR", 3, 1, SqlTypeFamily.CHARACTER),
    VARCHAR("VARCHAR", 3, 12, SqlTypeFamily.CHARACTER),
    VARCHAR2("VARCHAR2", 3, 12, SqlTypeFamily.CHARACTER),
    CHARACTERVARYING("CHARACTERVARYING", 3, 12, SqlTypeFamily.CHARACTER),
    BINARY("BINARY", 3, -2, SqlTypeFamily.BINARY),
    CHARBYTE("CHARBYTE", 3, 12, SqlTypeFamily.CHARACTER),
    NVARCHAR("NVARCHAR", 3, -9, SqlTypeFamily.CHARACTER),
    NCHAR("NCHAR", 3, 1, SqlTypeFamily.CHARACTER),
    BYTES("BYTES", 3, 1, SqlTypeFamily.CHARACTER),
    CHARACTER("CHARACTER", 3, 1, SqlTypeFamily.CHARACTER),
    TINYTEXT("TINYTEXT", 1, -1, SqlTypeFamily.CHARACTER),
    TEXT("TEXT", 2, -1, SqlTypeFamily.CHARACTER),
    STRING("STRING", 2, -1, SqlTypeFamily.CHARACTER),
    STRUCT("STRUCT", 2, -1, SqlTypeFamily.CHARACTER),
    MEDIUMTEXT("MEDIUMTEXT", 2, -1, SqlTypeFamily.CHARACTER),
    LONGTEXT("LONGTEXT", 2, -1, SqlTypeFamily.CHARACTER),
    ENUM("ENUM", 1, 12, SqlTypeFamily.CHARACTER),
    SET("SET", 1, 12, SqlTypeFamily.CHARACTER),
    VARBINARY("VARBINARY", 3, -3, SqlTypeFamily.BINARY),
    TINYBLOB("TINYBLOB", 1, 2004, SqlTypeFamily.BINARY),
    BLOB("BLOB", 1, 2004, SqlTypeFamily.BINARY),
    MEDIUMBLOB("MEDIUMBLOB", 1, 2004, SqlTypeFamily.BINARY),
    LONGBLOB("LONGBLOB", 1, 2004, SqlTypeFamily.BINARY),
    BYTEA("BYTEA", 1, 2004, SqlTypeFamily.BINARY),
    DATE("DATE", 1, 91, SqlTypeFamily.DATE),
    TIME("TIME", 3, 92, SqlTypeFamily.TIME),
    YEAR("YEAR", 3, 92, SqlTypeFamily.TIME),
    DATETIME("DATETIME", 3, 93, SqlTypeFamily.TIMESTAMP),
    SMALLDATETIME("SMALLDATETIME", 3, 93, SqlTypeFamily.TIMESTAMP),
    TIMESTAMP("TIMESTAMP", 3, 93, SqlTypeFamily.TIMESTAMP),
    TIMESTAMPTZ("TIMESTAMPTZ", 3, 93, SqlTypeFamily.TIMESTAMP),
    DATETIMEOFFSET("DATETIMEOFFSET", 3, 93, SqlTypeFamily.TIMESTAMP),
    DATETIME2("DATETIME2", 3, 93, SqlTypeFamily.TIMESTAMP),
    INTERVAL_YEAR("INTERVAL_YEAR", 1, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH),
    INTERVAL_YEAR_MONTH("INTERVAL_YEAR_MONTH", 1, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH),
    INTERVAL_MONTH("INTERVAL_MONTH", 1, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH),
    INTERVAL_DAY("INTERVAL_DAY", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_DAY_HOUR("INTERVAL_DAY_HOUR", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_DAY_MINUTE("INTERVAL_DAY_MINUTE", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_DAY_SECOND("INTERVAL_DAY_SECOND", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_HOUR("INTERVAL_HOUR", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_HOUR_MINUTE("INTERVAL_HOUR_MINUTE", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_HOUR_SECOND("INTERVAL_HOUR_SECOND", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_MINUTE("INTERVAL_MINUTE", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_MINUTE_SECOND("INTERVAL_MINUTE_SECOND", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    INTERVAL_SECOND("INTERVAL_SECOND", 7, 1111, SqlTypeFamily.INTERVAL_DAY_TIME),
    JSON("JSON", 1, 1111, null),
    JSONB("JSONB", 1, 1111, null),
    ARRAY("ARRAY", 1, 1111, SqlTypeFamily.ARRAY),
    MAP("MAP", 1, 1111, SqlTypeFamily.MAP),
    MONEY("MONEY", 1, 1111, null),
    SMALLMONEY("SMALLMONEY", 1, 1111, null),
    UNIQUEIDENTIFIER("UNIQUEIDENTIFIER", 1, 1111, null),
    HLL("HLL", 1, 1111, null),
    BITMAP("BITMAP", 1, 1111, null),
    POINT("POINT", 1, -3, SqlTypeFamily.GEOGRAPHY),
    POLYGON("POLYGON", 3, -3, SqlTypeFamily.GEOGRAPHY),
    GEOMETRY("GEOMETRY", 3, -3, SqlTypeFamily.GEOGRAPHY),
    GEOMETRYCOLLECTION("GEOMETRYCOLLECTION", 3, -3, SqlTypeFamily.GEOGRAPHY),
    LINESTRING("LINESTRING", 3, -3, SqlTypeFamily.GEOGRAPHY),
    MULTILINESTRING("MULTILINESTRING", 3, -3, SqlTypeFamily.GEOGRAPHY),
    MULTIPOINT("MULTIPOINT", 3, -3, SqlTypeFamily.GEOGRAPHY),
    MULTIPOLYGON("MULTIPOLYGON", 3, -3, SqlTypeFamily.GEOGRAPHY),
    BOX("BOX", 3, -3, SqlTypeFamily.GEOGRAPHY),
    NULL("NULL", 1, 0, SqlTypeFamily.NULL),
    ANY("ANY", 7, 2000, SqlTypeFamily.ANY),
    GEOGRAPHY("GEOGRAPHY", 3, -3, SqlTypeFamily.GEOGRAPHY),
    GEOGRAPHY_POINT("GEOGRAPHY_POINT", 1, -3, SqlTypeFamily.GEOGRAPHY),
    GEOGRAPHY_POLYGON("GEOGRAPHY_POLYGON", 3, -3, SqlTypeFamily.GEOGRAPHY),
    SYMBOL("SYMBOL", 1, 1111, null),
    MULTISET("MULTISET", 1, 2003, SqlTypeFamily.MULTISET),
    STRUCTURED("STRUCTURED", 1, 2002, null),
    UNKOWN("UNKOWN", 1, 0, null),
    XML("XML", 1, -16, null);

    private static final Map<String, SqlTypeName> VALUES_MAP;
    private final String name;
    private final int signatures;
    private final int jdbcOrdinal;
    private final SqlTypeFamily family;

    private SqlTypeName(String name, int signatures, int jdbcType, SqlTypeFamily family) {
        this.name = name;
        this.signatures = signatures;
        this.jdbcOrdinal = jdbcType;
        this.family = family;
    }

    public boolean allowsNoPrecNoScale() {
        return (this.signatures & 1) != 0;
    }

    public boolean allowsPrecNoScale() {
        return (this.signatures & 2) != 0;
    }

    public boolean allowsPrec() {
        return this.allowsPrecScale(true, true) || this.allowsPrecScale(true, false);
    }

    public boolean allowsScale() {
        return this.allowsPrecScale(true, true);
    }

    public boolean allowsPrecScale(boolean precision, boolean scale) {
        int mask = precision ? (scale ? 4 : 2) : (scale ? 0 : 1);
        return (this.signatures & mask) != 0;
    }

    public String getName() {
        return this.name;
    }

    public SqlTypeFamily getFamily() {
        return this.family;
    }

    public static SqlTypeName get(String name) {
        return VALUES_MAP.get(name);
    }

    public static <Type extends Enum<Type>> Map<String, Type> enumConstants(Class<Type> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        if (enumConstants == null) {
            throw new AssertionError((Object)"not an enum type");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum t : enumConstants) {
            builder.put((Object)t.name(), (Object)t);
        }
        return builder.build();
    }

    static {
        VALUES_MAP = SqlTypeName.enumConstants(SqlTypeName.class);
    }

    private static interface PrecScale {
        public static final int NO_NO = 1;
        public static final int YES_NO = 2;
        public static final int YES_YES = 4;
    }
}

