/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.scs.sql.util;

import java.util.Locale;
import java.util.regex.Pattern;

public class QuoteUtils {
    private static final String QUOTE = "`";
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";

    public static String replaceSingleQuote(String text) {
        String newText = text;
        if (text.startsWith(QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        if (newText.contains("\\\"")) {
            newText = newText.replace("\\\"", DOUBLE_QUOTE);
        }
        return newText.replace("\\'", "''");
    }

    public static String removeQuote(String text) {
        String newText = text;
        if (text.startsWith(QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        return newText.replace("``", QUOTE);
    }

    public static String removeSingleQuote(String text) {
        String newText = text;
        if (text.startsWith(SINGLE_QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(SINGLE_QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        return newText.replace("''", SINGLE_QUOTE);
    }

    public static String removeDoubleQuote(String text) {
        String newText = text;
        if (text.startsWith(DOUBLE_QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(DOUBLE_QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        return newText.replace("\"\"", DOUBLE_QUOTE);
    }

    public static String removeAllQuote(String text) {
        String newText = text;
        if (text.startsWith(DOUBLE_QUOTE) || text.startsWith(QUOTE) || text.startsWith(SINGLE_QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(DOUBLE_QUOTE) || newText.endsWith(QUOTE) || newText.endsWith(SINGLE_QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        if (newText.endsWith(DOUBLE_QUOTE)) {
            newText = newText.replace("\"\"", DOUBLE_QUOTE);
        } else if (newText.endsWith(QUOTE)) {
            newText = newText.replace("``", QUOTE);
        } else if (newText.endsWith(SINGLE_QUOTE)) {
            newText = newText.replace("''", SINGLE_QUOTE);
        }
        return newText;
    }

    public static String removeAllQuoteForField(String text) {
        String newText = text;
        if (text.startsWith(DOUBLE_QUOTE) || text.startsWith(QUOTE) || text.startsWith(SINGLE_QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(DOUBLE_QUOTE) || newText.endsWith(QUOTE) || newText.endsWith(SINGLE_QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        return newText;
    }

    public static String addQuote(String text) {
        String newText = text;
        newText = newText.replace(QUOTE, "``");
        return QUOTE + newText + QUOTE;
    }

    public static String addSingleQuote(String text) {
        String newText = text;
        return QuoteUtils.replaceSingleQuote(SINGLE_QUOTE + newText + SINGLE_QUOTE);
    }

    public static String addDoubleQuote(String text) {
        String newText = text;
        newText = newText.replace(DOUBLE_QUOTE, "\"\"");
        return DOUBLE_QUOTE + newText + DOUBLE_QUOTE;
    }

    public static String replaceSingleToDoubleQuote(String text) {
        String newText = text;
        if (text.startsWith(SINGLE_QUOTE) && text.endsWith(SINGLE_QUOTE)) {
            newText = newText.substring(1);
            newText = newText.substring(0, newText.length() - 1);
            return DOUBLE_QUOTE + newText + DOUBLE_QUOTE;
        }
        return newText;
    }

    public static String addDoubleQuoteForDigitField(String text) {
        String newText = text;
        String pattern = "[0-9]+\\D.*";
        boolean isMatch = Pattern.matches(pattern, text);
        if (isMatch) {
            newText = QuoteUtils.addDoubleQuote(newText);
        }
        return newText;
    }

    public static String addDoubleQuoteAndToLowerCase(String text) {
        String newText = text;
        if (text.startsWith(QUOTE)) {
            newText = newText.substring(1);
        }
        if (newText.endsWith(QUOTE)) {
            newText = newText.substring(0, newText.length() - 1);
        }
        newText = newText.replace("``", QUOTE);
        return DOUBLE_QUOTE + newText.toLowerCase(Locale.ROOT) + DOUBLE_QUOTE;
    }

    public static String changeQuoteToDouble(String text) {
        String pattern = "[0-9]+\\D.*";
        boolean isMatch = Pattern.matches(pattern, text);
        if (text.startsWith(QUOTE) && text.endsWith(QUOTE)) {
            String newText = text;
            if (text.startsWith(QUOTE)) {
                newText = newText.substring(1);
            }
            if (newText.endsWith(QUOTE)) {
                newText = newText.substring(0, newText.length() - 1);
            }
            newText = newText.replace("``", QUOTE);
            return DOUBLE_QUOTE + newText + DOUBLE_QUOTE;
        }
        if (text.startsWith(SINGLE_QUOTE) && text.endsWith(SINGLE_QUOTE)) {
            String letter;
            boolean isLetter;
            String newText = text;
            if (text.startsWith(SINGLE_QUOTE)) {
                newText = newText.substring(1);
            }
            if (newText.endsWith(SINGLE_QUOTE)) {
                newText = newText.substring(0, newText.length() - 1);
            }
            if (!(isLetter = Pattern.matches(letter = "^[a-zA-Z].*", newText = newText.replace("``", QUOTE)))) {
                return DOUBLE_QUOTE + newText + DOUBLE_QUOTE;
            }
            return newText;
        }
        if (isMatch) {
            return QuoteUtils.addDoubleQuote(text);
        }
        return text;
    }

    public static boolean fieldWithDoubleQuote(String text) {
        String strWithOutBlank = text.trim();
        return strWithOutBlank.startsWith(DOUBLE_QUOTE) && strWithOutBlank.endsWith(DOUBLE_QUOTE);
    }

    public static boolean fieldWithSingleQuote(String text) {
        String strWithOutBlank = text.trim();
        return strWithOutBlank.startsWith(SINGLE_QUOTE) && strWithOutBlank.endsWith(SINGLE_QUOTE);
    }

    public static String handleDoubleQuotedString(String text) {
        String newText = text;
        if (QuoteUtils.fieldWithDoubleQuote(newText)) {
            newText = newText.substring(1, newText.length() - 1);
            newText = newText.replace(SINGLE_QUOTE, "''");
            newText = newText.replaceAll("\"{2}", DOUBLE_QUOTE);
            newText = QuoteUtils.addSingleQuote(newText);
            newText = newText.replaceAll("\"\\.\"", "'.'");
        }
        return newText;
    }
}

