/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td;

import com.huawei.db.migration.exception.ParserException;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AntlrErrorListener
extends BaseErrorListener {
    private static final Logger LOGGER = LogManager.getLogger(AntlrErrorListener.class);
    private static final String SYMBOL_EOF = "<EOF>";
    private static final int MIN_SIZE_FOR_TOKENS = 2;
    private ParserException parserException;

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.parserException == null) {
            String errorSymbol = this.getOffendingSymbol(recognizer, offendingSymbol, charPositionInLine);
            this.parserException = new ParserException("You have an error in your SQL syntax; check the manual that corresponds to your Database version for the right syntax to use near '" + errorSymbol + "' at line " + line + ":" + charPositionInLine);
            LOGGER.error(this.parserException.getMessage(), (Throwable)this.parserException);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public ParserException getRecException() {
        return this.parserException;
    }

    private String getOffendingSymbol(Recognizer<?, ?> recognizer, Object offendingSymbol, int charPositionInLine) {
        if (null != offendingSymbol) {
            return this.getOffendingSymbolWithHint(recognizer, offendingSymbol);
        }
        String inputSentence = recognizer.getInputStream().toString();
        return inputSentence.isEmpty() ? "" : this.getOffendingSymbolWithoutHint(inputSentence, charPositionInLine);
    }

    private String getOffendingSymbolWithHint(Recognizer<?, ?> recognizer, Object offendingSymbol) {
        Token token = (Token)offendingSymbol;
        String tokenText = token.getText();
        if (tokenText.equals(SYMBOL_EOF)) {
            List allTokens = ((CommonTokenStream)recognizer.getInputStream()).getTokens();
            int tokensCount = allTokens.size();
            return tokensCount < 2 ? "" : ((Token)allTokens.get(tokensCount - 2)).getText();
        }
        return tokenText;
    }

    private int findPositionNotSpaceBackForward(String input, int offset) {
        String subStr = input.substring(0, offset);
        for (int index = offset - 1; index >= 0; --index) {
            if (subStr.charAt(index) == ' ') continue;
            return index;
        }
        return 0;
    }

    private String getOffendingSymbolWithoutHint(String input, int charPositionInLine) {
        int start = 0;
        int offset = charPositionInLine;
        if (offset > input.length()) {
            offset = input.length() - 1;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (input.charAt(offset) == ' ') {
            offset = this.findPositionNotSpaceBackForward(input, offset);
        }
        start = input.lastIndexOf(" ", offset);
        int end = input.indexOf(" ", offset);
        start = start == -1 ? 0 : start + 1;
        end = end == -1 ? input.length() : end;
        return input.substring(start, end);
    }
}

