/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.cli;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.hwclouds.migration.common.config.Constants;
import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.td.cli.CliOptions;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CliParser {
    private static final Logger LOGGER = LogManager.getLogger(CliParser.class);
    private static final String PARSER_ERROR_MSG = "Failed to parse arguments";

    public CliOptions parser(String[] args) throws ParserException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(this.getCliOptions(), args, true);
        }
        catch (ParseException e) {
            LOGGER.error("Failed to parse arguments.", (Throwable)e);
        }
        if (cmd == null || cmd.getOptions() == null || cmd.getOptions().length == 0 || cmd.hasOption(Constants.OptionsEnum.H.name())) {
            this.printHelp();
            return null;
        }
        CliOptions options = new CliOptions();
        if (cmd.hasOption(Constants.OptionsEnum.V.name())) {
            LOGGER.info("Version DSC v3.0.0");
            return null;
        }
        this.checkOptions(cmd, options);
        return options;
    }

    private Options getCliOptions() {
        Options options = new Options();
        options.addOption("S", "source-db", true, "The source database, which can be either MySQL or Oracle.");
        options.addOption("I", "input-folder", true, "The input/source folder that contains the Teradata/Oracle scripts to be migrated.");
        options.addOption("O", "output-folder", true, "The output/target folder where the migrated scripts are placed.");
        options.addOption("A", "application-lang", false, "The application language type, which can be either SQL or Perl. Default it SQL. It was a Compatibility parameter in schema convert tool.");
        options.addOption("M", "conversion-type", false, "The conversion type, which can be either Bulk or BLogic. It was a Compatibility parameter in schema convert tool.");
        options.addOption("L", "log-folder", false, "The log file path where the log files are created. It was a Compatibility parameter in schema convert tool, the log folder can be changed in log4j2_td.xml.");
        options.addOption("V", "version", false, "Version of DSC");
        options.addOption("H", "help", false, "Lists for help");
        return options;
    }

    private void printHelp() {
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(120);
        hf.printHelp("H", this.getCliOptions());
    }

    private void checkOptions(CommandLine cmd, CliOptions options) throws ParserException {
        if (!cmd.hasOption("S")) {
            LOGGER.error("Source-db can not be null");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (!cmd.hasOption("I")) {
            LOGGER.error("input-folder can not be null.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (!cmd.hasOption("O")) {
            LOGGER.error("output-folder can not be null.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        SqlDialect dialect = SqlDialect.getDialect(cmd.getOptionValue("S"));
        if (dialect == null) {
            LOGGER.error("invalid source db");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        options.setSourceDialect(dialect);
        String inputFolder = cmd.getOptionValue("I");
        File fileInputFolder = new File(inputFolder);
        if (!fileInputFolder.exists()) {
            LOGGER.error("input-folder does not exists.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        try {
            String canonicalInputPath = fileInputFolder.getCanonicalPath();
            LOGGER.debug("canonical input path : ", (Object)canonicalInputPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to get canonicalPath " + fileInputFolder, (Throwable)e);
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (!fileInputFolder.isDirectory()) {
            LOGGER.error("input-folder is not a directory.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (!fileInputFolder.canRead()) {
            LOGGER.error("input-folder can not be read.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        options.setInputFolder(inputFolder);
        String outputFolder = cmd.getOptionValue("O");
        File fOutputFolder = new File(outputFolder);
        if (!CommonUtils.createNewFile(outputFolder, false)) {
            LOGGER.error("Cannot create file " + outputFolder);
            throw new ParserException("Cannot create file " + outputFolder);
        }
        if (!fOutputFolder.isDirectory()) {
            LOGGER.error("output-folder is not a directory.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        if (!fOutputFolder.canWrite()) {
            LOGGER.error("no write permissions for output folder.");
            throw new ParserException(PARSER_ERROR_MSG);
        }
        options.setOutputFolder(outputFolder);
    }
}

