/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TdPropertyLoader {
    static ThreadLocal<Map<String, String>> propMapCxt = new ThreadLocal();
    private static final Logger LOGGER = LogManager.getLogger(TdPropertyLoader.class);

    public static void loadPropertyMap(Map<String, String> inPropMap) {
        Objects.requireNonNull(inPropMap, "Input property map must not be null");
        HashMap<String, String> copy = new HashMap<String, String>(inPropMap);
        propMapCxt.set(copy);
        LOGGER.info("Features from input parameter have been loaded successfully");
    }

    public static String getStringProperty(String propertyName) {
        Map<String, String> propMap = propMapCxt.get();
        if (propMap == null) {
            return "";
        }
        String value = propMap.get(propertyName);
        value = value != null ? value : "";
        return value;
    }

    public static void clearPropMapCxt() {
        propMapCxt.remove();
    }
}

