/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.nodes;

import java.util.HashMap;
import java.util.Map;

public enum TypeName {
    INTEGER("INTEGER", "INTEGER"),
    INT("INT", "INTEGER"),
    SMALLINT("SMALLINT", "SMALLINT"),
    TINYINT("TINYINT", "TINYINT"),
    BIGINT("BIGINT", "BIGINT"),
    BYTEINT("BYTEINT", "SMALLINT"),
    REAL("REAL", "REAL"),
    DOUBLE_PRECISION("DOUBLE PRECISION", "DOUBLE PRECISION"),
    FLOAT("FLOAT", "FLOAT"),
    NUMBER("NUMBER", "NUMERIC"),
    NUMERIC("NUMERIC", "NUMERIC"),
    DECIMAL("DECIMAL", "DECIMAL"),
    DEC("DEC", "DECIMAL"),
    DATE("DATE", "DATE"),
    INTERVAL("INTERVAL", "INTERVAL"),
    PERIOD("PERIOD", "PERIOD"),
    YEAR("YEAR", "YEAR"),
    MONTH("MONTH", "MONTH"),
    DAY("DAY", "DAY"),
    HOUR("HOUR", "HOUR"),
    MINUTE("MINUTE", "MINUTE"),
    SECOND("SECOND", "SECOND"),
    TIME("TIME", "TIME"),
    TIMESTAMP("TIMESTAMP", "TIMESTAMP"),
    LONG_VARCHAR("LONG VARCHAR", "TEXT"),
    LONG_VARGRAPHIC("LONG VARGRAPHIC", "bytea"),
    CHAR("CHAR", "CHAR"),
    CHARACTER("CHARACTER", "CHAR"),
    BYTE("BYTE", "bytea"),
    GRAPHIC("GRAPHIC", "bytea"),
    VARCHAR("VARCHAR", "VARCHAR"),
    CHAR_VARYING("CHAR VARYING", "VARCHAR"),
    CHARACTER_VARYING("CHARACTER VARYING", "VARCHAR"),
    VARBYTE("VARBYTE", "bytea"),
    VARGRAPHIC("VARGRAPHIC", "bytea"),
    BINARY_LARGE_OBJECT("BINARY_LARGE_OBJECT", "blob"),
    BLOB("BLOB", "blob"),
    CHARACTER_LARGE_OBJECT("CHARACTER_LARGE_OBJECT", "CLOB"),
    CLOB("CLOB", "CLOB"),
    NVARCHAR2("NVARCHAR2", "NVARCHAR2"),
    JSON("JSON", "JSON"),
    XML("XML", "XML"),
    BINARY("BINARY", "bytea"),
    TEXT("TEXT", "TEXT");

    private final String source;
    private final String target;
    private static final Map<String, TypeName> typeNameMap;

    private TypeName(String source, String target) {
        this.source = source;
        this.target = target;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public static TypeName getTypeName(String source) {
        return typeNameMap.get(source);
    }

    public static boolean isChar(TypeName typeName) {
        return typeName == VARCHAR || typeName == CHAR_VARYING || typeName == LONG_VARCHAR || typeName == CHARACTER_VARYING || typeName == CHARACTER || typeName == CHAR || typeName == NVARCHAR2;
    }

    public static boolean isDate(TypeName typeName) {
        return typeName == DATE || typeName == TIMESTAMP;
    }

    static {
        typeNameMap = new HashMap<String, TypeName>();
        for (TypeName value : TypeName.values()) {
            typeNameMap.put(value.source, value);
        }
    }
}

